/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.util.ArrayList;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineFns;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoCombineTransformExample {
    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        PipelineOptions options = PipelineOptionsFactory.create();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        PCollection inputKV = (PCollection)pipeline.apply((PTransform)Create.of((Object)KV.of((Object)1L, (Object)1L), (Object[])new KV[]{KV.of((Object)1L, (Object)5L), KV.of((Object)2L, (Object)10L), KV.of((Object)2L, (Object)20L), KV.of((Object)3L, (Object)1L)}));
        SimpleFunction<Long, Long> identityFn = new SimpleFunction<Long, Long>(){

            public @UnknownKeyFor @NonNull @Initialized Long apply(@UnknownKeyFor @NonNull @Initialized Long input) {
                return input;
            }
        };
        final TupleTag sumTag = new TupleTag("sum_n");
        final TupleTag minTag = new TupleTag("min_n");
        final TupleTag maxTag = new TupleTag("max_n");
        CombineFns.ComposedCombineFn composedCombine = CombineFns.compose().with((SimpleFunction)identityFn, new DropNullFn(Sum.ofLongs()), sumTag).with((SimpleFunction)identityFn, new DropNullFn(Min.ofLongs()), minTag).with((SimpleFunction)identityFn, new DropNullFn(Max.ofLongs()), maxTag);
        PCollection combinedData = (PCollection)inputKV.apply("Combine all", (PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)composedCombine));
        PCollection result = (PCollection)combinedData.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<Long, CombineFns.CoCombineResult>, KV<Long, Iterable<KV<String, Long>>>>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                CombineFns.CoCombineResult e = (CombineFns.CoCombineResult)((KV)c.element()).getValue();
                ArrayList<KV> o = new ArrayList<KV>();
                o.add(KV.of((Object)minTag.getId(), (Object)((Long)e.get(minTag))));
                o.add(KV.of((Object)maxTag.getId(), (Object)((Long)e.get(maxTag))));
                o.add(KV.of((Object)sumTag.getId(), (Object)((Long)e.get(sumTag))));
                c.output((Object)KV.of((Object)((Long)((KV)c.element()).getKey()), o));
            }
        }));
        result.apply((PTransform)ParDo.of(new LogOutput("PCollection values after CoCombine transform: ")));
        pipeline.run();
    }

    static class LogOutput<@UnknownKeyFor T>
    extends DoFn<T, T> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(LogOutput.class);
        private final @UnknownKeyFor @NonNull @Initialized String prefix;

        public LogOutput(@UnknownKeyFor @NonNull @Initialized String prefix) {
            this.prefix = prefix;
        }

        @DoFn.ProcessElement
        public void processElement(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            LOG.info(this.prefix + c.element());
            c.output(c.element());
        }
    }

    public static class DropNullFn<@UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends Combine.CombineFn<InputT, AccumT, OutputT> {
        protected final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

        public DropNullFn(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            this.combineFn = combineFn;
        }

        public AccumT createAccumulator() {
            return null;
        }

        public AccumT addInput(AccumT accumulator, InputT input) {
            if (input == null) {
                return accumulator;
            }
            if (accumulator == null) {
                accumulator = this.combineFn.createAccumulator();
            }
            return (AccumT)this.combineFn.addInput(accumulator, input);
        }

        public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators) {
            if (!(accumulators = Iterables.filter(accumulators, (Predicate)Predicates.notNull())).iterator().hasNext()) {
                return null;
            }
            return (AccumT)this.combineFn.mergeAccumulators(accumulators);
        }

        public OutputT extractOutput(AccumT accumulator) {
            if (accumulator == null) {
                return null;
            }
            return (OutputT)this.combineFn.extractOutput(accumulator);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<AccumT> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            Coder coder = this.combineFn.getAccumulatorCoder(registry, inputCoder);
            if (coder instanceof NullableCoder) {
                return coder;
            }
            return NullableCoder.of((Coder)coder);
        }
    }
}

