/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.common;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class WriteOneFilePerWindow
extends PTransform<PCollection<String>, PDone> {
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter FORMATTER = ISODateTimeFormat.hourMinute();
    private @UnknownKeyFor @NonNull @Initialized String filenamePrefix;
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer numShards;

    public WriteOneFilePerWindow(@UnknownKeyFor @NonNull @Initialized String filenamePrefix, @UnknownKeyFor @NonNull @Initialized Integer numShards) {
        this.filenamePrefix = filenamePrefix;
        this.numShards = numShards;
    }

    public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
        ResourceId resource = FileBasedSink.convertToFileResourceIfPossible((String)this.filenamePrefix);
        TextIO.Write write = TextIO.write().to((FileBasedSink.FilenamePolicy)new PerWindowFiles(resource)).withTempDirectory(resource.getCurrentDirectory()).withWindowedWrites();
        if (this.numShards != null) {
            write = write.withNumShards(this.numShards.intValue());
        }
        return (PDone)input.apply((PTransform)write);
    }

    public static class PerWindowFiles
    extends FileBasedSink.FilenamePolicy {
        private final @UnknownKeyFor @NonNull @Initialized ResourceId baseFilename;

        public PerWindowFiles(@UnknownKeyFor @NonNull @Initialized ResourceId baseFilename) {
            this.baseFilename = baseFilename;
        }

        public @UnknownKeyFor @NonNull @Initialized String filenamePrefixForWindow(@UnknownKeyFor @NonNull @Initialized IntervalWindow window) {
            String prefix = this.baseFilename.isDirectory() ? "" : (String)MoreObjects.firstNonNull((Object)this.baseFilename.getFilename(), (Object)"");
            return String.format("%s-%s-%s", prefix, FORMATTER.print((ReadableInstant)window.start()), FORMATTER.print((ReadableInstant)window.end()));
        }

        public @UnknownKeyFor @NonNull @Initialized ResourceId windowedFilename(@UnknownKeyFor @NonNull @Initialized int shardNumber, @UnknownKeyFor @NonNull @Initialized int numShards, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileBasedSink.OutputFileHints outputFileHints) {
            IntervalWindow intervalWindow = (IntervalWindow)window;
            String filename = String.format("%s-%s-of-%s%s", this.filenamePrefixForWindow(intervalWindow), shardNumber, numShards, outputFileHints.getSuggestedFilenameSuffix());
            return this.baseFilename.getCurrentDirectory().resolve(filename, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        }

        public @UnknownKeyFor @NonNull @Initialized ResourceId unwindowedFilename(@UnknownKeyFor @NonNull @Initialized int shardNumber, @UnknownKeyFor @NonNull @Initialized int numShards, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileBasedSink.OutputFileHints outputFileHints) {
            throw new UnsupportedOperationException("Unsupported.");
        }
    }
}

