/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete;

import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableComparator;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.CalendarWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ComparisonChain;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class TopWikipediaSessions {
    private static final @UnknownKeyFor @NonNull @Initialized String EXPORTED_WIKI_TABLE = "gs://apache-beam-samples/wikipedia_edits/*.json";

    public static void run(@UnknownKeyFor @NonNull @Initialized Options options) {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        double samplingThreshold = 0.1;
        ((PCollection)((PCollection)((PCollection)p.apply((PTransform)TextIO.read().from(options.getWikiInput()))).apply((PTransform)MapElements.via((SimpleFunction)new ParseTableRowJson()))).apply((PTransform)new ComputeTopSessions(samplingThreshold))).apply("Write", (PTransform)TextIO.write().to(options.getOutput()));
        p.run().waitUntilFinish();
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        TopWikipediaSessions.run(options);
    }

    public static interface Options
    extends PipelineOptions {
        @Description(value="Input specified as a GCS path containing a BigQuery table exported as json")
        @Default.String(value="gs://apache-beam-samples/wikipedia_edits/*.json")
        public @UnknownKeyFor @NonNull @Initialized String getWikiInput();

        public void setWikiInput(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="File to output results to")
        @Validation.Required
        public @UnknownKeyFor @NonNull @Initialized String getOutput();

        public void setOutput(@UnknownKeyFor @NonNull @Initialized String var1);
    }

    static class ComputeTopSessions
    extends PTransform<PCollection<TableRow>, PCollection<String>> {
        private final @UnknownKeyFor @NonNull @Initialized double samplingThreshold;

        public ComputeTopSessions(@UnknownKeyFor @NonNull @Initialized double samplingThreshold) {
            this.samplingThreshold = samplingThreshold;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> input) {
            return (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new ExtractUserAndTimestamp()))).apply("SampleUsers", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    if ((double)Math.abs((long)((String)c.element()).hashCode()) <= 2.147483647E9 * samplingThreshold) {
                        c.output((Object)((String)c.element()));
                    }
                }
            }))).apply((PTransform)new ComputeSessions())).apply("SessionsToStrings", (PTransform)ParDo.of((DoFn)new SessionsToStringsDoFn()))).apply((PTransform)new TopPerMonth())).apply("FormatOutput", (PTransform)ParDo.of((DoFn)new FormatOutputDoFn()));
        }
    }

    static class ParseTableRowJson
    extends SimpleFunction<String, TableRow> {
        ParseTableRowJson() {
        }

        public @UnknownKeyFor @NonNull @Initialized TableRow apply(@UnknownKeyFor @NonNull @Initialized String input) {
            try {
                return (TableRow)Transport.getJsonFactory().fromString(input, TableRow.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed parsing table row json", e);
            }
        }
    }

    static class FormatOutputDoFn
    extends DoFn<List<KV<String, Long>>, String> {
        FormatOutputDoFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            for (KV item : (List)c.element()) {
                String session = (String)item.getKey();
                long count = (Long)item.getValue();
                c.output((Object)(session + " : " + count + " : " + ((IntervalWindow)window).start()));
            }
        }
    }

    static class SessionsToStringsDoFn
    extends DoFn<KV<String, Long>, KV<String, Long>> {
        SessionsToStringsDoFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            c.output((Object)KV.of((Object)((String)((KV)c.element()).getKey() + " : " + window), (Object)((Long)((KV)c.element()).getValue())));
        }
    }

    private static class TopPerMonth
    extends PTransform<PCollection<KV<String, Long>>, PCollection<List<KV<String, Long>>>> {
        private TopPerMonth() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long>> sessions) {
            SerializableComparator & Serializable comparator = (SerializableComparator & Serializable)(o1, o2) -> ComparisonChain.start().compare((Comparable)o1.getValue(), (Comparable)o2.getValue()).compare((Comparable)o1.getKey(), (Comparable)o2.getKey()).result();
            return (PCollection)((PCollection)sessions.apply((PTransform)Window.into((WindowFn)CalendarWindows.months((int)1)))).apply((PTransform)Top.of((int)1, (Comparator)comparator).withoutDefaults());
        }
    }

    static class ComputeSessions
    extends PTransform<PCollection<String>, PCollection<KV<String, Long>>> {
        ComputeSessions() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> actions) {
            return (PCollection)((PCollection)actions.apply((PTransform)Window.into((WindowFn)Sessions.withGapDuration((Duration)Duration.standardHours((long)1L))))).apply(Count.perElement());
        }
    }

    static class ExtractUserAndTimestamp
    extends DoFn<TableRow, String> {
        ExtractUserAndTimestamp() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            int timestamp;
            TableRow row = (TableRow)c.element();
            try {
                timestamp = ((BigDecimal)row.get((Object)"timestamp")).intValue();
            }
            catch (ClassCastException e) {
                timestamp = (Integer)row.get((Object)"timestamp");
            }
            String userName = (String)row.get((Object)"contributor_username");
            if (userName != null) {
                c.outputWithTimestamp((Object)userName, new Instant((long)timestamp * 1000L));
            }
        }
    }
}

