/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.utils;

import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.CharStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemasUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SchemasUtils.class);
    private @UnknownKeyFor @NonNull @Initialized TableSchema bigQuerySchema;
    private @UnknownKeyFor @NonNull @Initialized Schema beamSchema;
    private @UnknownKeyFor @NonNull @Initialized String jsonBeamSchema;
    public static final @UnknownKeyFor @NonNull @Initialized String DEADLETTER_SCHEMA = "{\n  \"fields\": [\n    {\n      \"name\": \"timestamp\",\n      \"type\": \"TIMESTAMP\",\n      \"mode\": \"REQUIRED\"\n    },\n    {\n      \"name\": \"payloadString\",\n      \"type\": \"STRING\",\n      \"mode\": \"REQUIRED\"\n    },\n    {\n      \"name\": \"payloadBytes\",\n      \"type\": \"BYTES\",\n      \"mode\": \"REQUIRED\"\n    },\n    {\n      \"name\": \"attributes\",\n      \"type\": \"RECORD\",\n      \"mode\": \"REPEATED\",\n      \"fields\": [\n        {\n          \"name\": \"key\",\n          \"type\": \"STRING\",\n          \"mode\": \"NULLABLE\"\n        },\n        {\n          \"name\": \"value\",\n          \"type\": \"STRING\",\n          \"mode\": \"NULLABLE\"\n        }\n      ]\n    },\n    {\n      \"name\": \"errorMessage\",\n      \"type\": \"STRING\",\n      \"mode\": \"NULLABLE\"\n    },\n    {\n      \"name\": \"stacktrace\",\n      \"type\": \"STRING\",\n      \"mode\": \"NULLABLE\"\n    }\n  ]\n}";

    public SchemasUtils(@UnknownKeyFor @NonNull @Initialized String schema) {
        this.parseJson(schema);
    }

    public SchemasUtils(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (path.startsWith("gs://")) {
            this.parseJson(new String(SchemasUtils.readGcsFile(path), encoding));
        } else {
            byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
            this.parseJson(new String(encoded, encoding));
        }
        LOG.info("Extracted schema: " + this.bigQuerySchema.toPrettyString());
    }

    public @UnknownKeyFor @NonNull @Initialized TableSchema getBigQuerySchema() {
        return this.bigQuerySchema;
    }

    private void parseJson(@UnknownKeyFor @NonNull @Initialized String jsonSchema) throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
        TableSchema schema = (TableSchema)BigQueryHelpers.fromJsonString((String)jsonSchema, TableSchema.class);
        this.validateSchemaTypes(schema);
        this.bigQuerySchema = schema;
        this.jsonBeamSchema = BigQueryHelpers.toJsonString((Object)schema.getFields());
    }

    private void validateSchemaTypes(@UnknownKeyFor @NonNull @Initialized TableSchema bigQuerySchema) {
        try {
            this.beamSchema = BigQueryUtils.fromTableSchema((TableSchema)bigQuerySchema);
        }
        catch (UnsupportedOperationException exception) {
            LOG.error("Check json schema, {}", (Object)exception.getMessage());
        }
        catch (NullPointerException npe) {
            LOG.error("Missing schema keywords, please check what all required fields presented");
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] readGcsFile(@UnknownKeyFor @NonNull @Initialized String gcsFilePath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        LOG.info("Reading contents from GCS file: {}", (Object)gcsFilePath);
        try (ReadableByteChannel readerChannel = FileSystems.open((ResourceId)FileSystems.matchSingleFileSpec((String)gcsFilePath).resourceId());){
            byte[] byArray;
            block12: {
                InputStream stream = Channels.newInputStream(readerChannel);
                try {
                    byArray = ByteStreams.toByteArray((InputStream)stream);
                    if (stream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return byArray;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Schema getBeamSchema() {
        return this.beamSchema;
    }

    public @UnknownKeyFor @NonNull @Initialized String getJsonBeamSchema() {
        return this.jsonBeamSchema;
    }

    public static @UnknownKeyFor @NonNull @Initialized String getGcsFileAsString(@UnknownKeyFor @NonNull @Initialized String filePath) {
        try {
            MatchResult result = FileSystems.match((String)filePath);
            Preconditions.checkArgument((result.status() == MatchResult.Status.OK && !result.metadata().isEmpty() ? 1 : 0) != 0, (Object)("Failed to match any files with the pattern: " + filePath));
            List rId = result.metadata().stream().map(MatchResult.Metadata::resourceId).collect(Collectors.toList());
            Preconditions.checkArgument((rId.size() == 1 ? 1 : 0) != 0, (Object)("Expected exactly 1 file, but got " + rId.size() + " files."));
            Reader reader = Channels.newReader(FileSystems.open((ResourceId)((ResourceId)rId.get(0))), StandardCharsets.UTF_8.name());
            return CharStreams.toString((Readable)reader);
        }
        catch (IOException ioe) {
            LOG.error("File system i/o error: " + ioe.getMessage());
            throw new RuntimeException(ioe);
        }
    }
}

