/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.reflect.Nullable;
import org.apache.beam.examples.complete.game.utils.WriteToText;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserScore {
    protected static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteToText.FieldFn<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer>>> configureOutput() {
        HashMap<String, WriteToText.FieldFn<KV<String, Integer>>> config = new HashMap<String, WriteToText.FieldFn<KV<String, Integer>>>();
        config.put("user", (c, w) -> ((KV)c.element()).getKey());
        config.put("total_score", (c, w) -> ((KV)c.element()).getValue());
        return config;
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)pipeline.apply((PTransform)TextIO.read().from(options.getInput()))).apply("ParseGameEvent", (PTransform)ParDo.of((DoFn)new ParseEventFn()))).apply("ExtractUserScore", (PTransform)new ExtractAndSumScore("user"))).apply("WriteUserScoreSums", new WriteToText(options.getOutput(), UserScore.configureOutput(), false));
        pipeline.run().waitUntilFinish();
    }

    public static interface Options
    extends PipelineOptions {
        @Description(value="Path to the data file(s) containing game data.")
        @Default.String(value="gs://apache-beam-samples/game/gaming_data*.csv")
        public @UnknownKeyFor @NonNull @Initialized String getInput();

        public void setInput(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Path of the file to write to.")
        @Validation.Required
        public @UnknownKeyFor @NonNull @Initialized String getOutput();

        public void setOutput(@UnknownKeyFor @NonNull @Initialized String var1);
    }

    public static class ExtractAndSumScore
    extends PTransform<PCollection<GameActionInfo>, PCollection<KV<String, Integer>>> {
        private final @UnknownKeyFor @NonNull @Initialized String field;

        ExtractAndSumScore(@UnknownKeyFor @NonNull @Initialized String field) {
            this.field = field;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized GameActionInfo> gameInfo) {
            return (PCollection)((PCollection)gameInfo.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.strings(), (TypeDescriptor)TypeDescriptors.integers())).via((SerializableFunction & Serializable)gInfo -> KV.of((Object)gInfo.getKey(this.field), (Object)gInfo.getScore())))).apply((PTransform)Sum.integersPerKey());
        }
    }

    static class ParseEventFn
    extends DoFn<String, GameActionInfo> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ParseEventFn.class);
        private final @UnknownKeyFor @NonNull @Initialized Counter numParseErrors = Metrics.counter((String)"main", (String)"ParseErrors");

        ParseEventFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            String[] components = ((String)c.element()).split(",", -1);
            try {
                String user = components[0].trim();
                String team = components[1].trim();
                Integer score = Integer.parseInt(components[2].trim());
                Long timestamp = Long.parseLong(components[3].trim());
                GameActionInfo gInfo = new GameActionInfo(user, team, score, timestamp);
                c.output((Object)gInfo);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                this.numParseErrors.inc();
                LOG.info("Parse error on " + (String)c.element() + ", " + e.getMessage());
            }
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    static class GameActionInfo {
        @Nullable
        @UnknownKeyFor @NonNull @Initialized String user;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized String team;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized Integer score;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized Long timestamp;

        public GameActionInfo() {
        }

        public GameActionInfo(@UnknownKeyFor @NonNull @Initialized String user, @UnknownKeyFor @NonNull @Initialized String team, @UnknownKeyFor @NonNull @Initialized Integer score, @UnknownKeyFor @NonNull @Initialized Long timestamp) {
            this.user = user;
            this.team = team;
            this.score = score;
            this.timestamp = timestamp;
        }

        public @UnknownKeyFor @NonNull @Initialized String getUser() {
            return this.user;
        }

        public @UnknownKeyFor @NonNull @Initialized String getTeam() {
            return this.team;
        }

        public @UnknownKeyFor @NonNull @Initialized Integer getScore() {
            return this.score;
        }

        public @UnknownKeyFor @NonNull @Initialized Long getTimestamp() {
            return this.timestamp;
        }

        public @UnknownKeyFor @NonNull @Initialized String getKey(@UnknownKeyFor @NonNull @Initialized String keyname) {
            if ("team".equals(keyname)) {
                return this.team;
            }
            return this.user;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            GameActionInfo gameActionInfo = (GameActionInfo)o;
            if (!this.getUser().equals(gameActionInfo.getUser())) {
                return false;
            }
            if (!this.getTeam().equals(gameActionInfo.getTeam())) {
                return false;
            }
            if (!this.getScore().equals(gameActionInfo.getScore())) {
                return false;
            }
            return this.getTimestamp().equals(gameActionInfo.getTimestamp());
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.user, this.team, this.score, this.timestamp);
        }
    }
}

