/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.kafkatopubsub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.examples.complete.kafkatopubsub.avro.AvroDataClass;
import org.apache.beam.examples.complete.kafkatopubsub.kafka.consumer.Utils;
import org.apache.beam.examples.complete.kafkatopubsub.options.KafkaToPubsubOptions;
import org.apache.beam.examples.complete.kafkatopubsub.transforms.FormatTransform;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaToPubsub {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KafkaToPubsub.class);

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        KafkaToPubsubOptions options = (KafkaToPubsubOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(KafkaToPubsubOptions.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        KafkaToPubsub.run(pipeline, options);
    }

    public static @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized KafkaToPubsubOptions options) {
        HashMap<String, Object> kafkaConfig = new HashMap<String, Object>();
        kafkaConfig.putAll(Utils.parseKafkaConsumerConfig(options.getKafkaConsumerConfig()));
        HashMap<String, String> sslConfig = new HashMap<String, String>();
        if (options.getSecretStoreUrl() != null && options.getVaultToken() != null) {
            Map<String, Map<String, String>> credentials = Utils.getKafkaCredentialsFromVault(options.getSecretStoreUrl(), options.getVaultToken());
            kafkaConfig = Utils.configureKafka(credentials.get("kafka"));
        } else {
            LOG.warn("No information to retrieve Kafka credentials was provided. Trying to initiate an unauthorized connection.");
        }
        if (Utils.isSslSpecified(options)) {
            sslConfig.putAll(Utils.configureSsl(options));
        } else {
            LOG.info("No information to retrieve SSL certificate was provided by parameters.Trying to initiate a plain text connection.");
        }
        ArrayList<String> topicsList = new ArrayList<String>(Arrays.asList(options.getInputTopics().split(",")));
        Preconditions.checkArgument((topicsList.size() > 0 && ((String)topicsList.get(0)).length() > 0 ? 1 : 0) != 0, (Object)"inputTopics cannot be an empty string.");
        ArrayList<String> bootstrapServersList = new ArrayList<String>(Arrays.asList(options.getBootstrapServers().split(",")));
        Preconditions.checkArgument((bootstrapServersList.size() > 0 && ((String)topicsList.get(0)).length() > 0 ? 1 : 0) != 0, (Object)"bootstrapServers cannot be an empty string.");
        LOG.info("Starting Kafka-To-PubSub pipeline with parameters bootstrap servers:" + options.getBootstrapServers() + " input topics: " + options.getInputTopics() + " output pubsub topic: " + options.getOutputTopic());
        if (options.getOutputFormat() == FormatTransform.FORMAT.AVRO) {
            ((PCollection)((PCollection)pipeline.apply("readAvrosFromKafka", FormatTransform.readAvrosFromKafka(options.getBootstrapServers(), topicsList, kafkaConfig, sslConfig))).apply("createValues", (PTransform)Values.create())).apply("writeAvrosToPubSub", (PTransform)PubsubIO.writeAvros(AvroDataClass.class));
        } else {
            ((PCollection)((PCollection)pipeline.apply("readFromKafka", FormatTransform.readFromKafka(options.getBootstrapServers(), topicsList, kafkaConfig, sslConfig))).apply("createValues", (PTransform)Values.create())).apply("writeToPubSub", (PTransform)new FormatTransform.FormatOutput(options));
        }
        return pipeline.run();
    }
}

