/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.kafkatopubsub.options;

import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.Validation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface KafkaToPubsubOptions
extends PipelineOptions {
    @Description(value="Comma Separated list of Kafka Bootstrap Servers (e.g: server1:[port],server2:[port]).")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized String getBootstrapServers();

    public void setBootstrapServers(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Comma Separated list of Kafka topic(s) to read the input from (e.g: topic1,topic2).")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized String getInputTopics();

    public void setInputTopics(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The Cloud Pub/Sub topic to publish to. The name should be in the format of projects/<project-id>/topics/<topic-name>.")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized String getOutputTopic();

    public void setOutputTopic(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Format which will be writen to output Pub/Sub topic. Supported formats: AVRO, PUBSUB")
    @Validation.Required
    public  @UnknownKeyFor @NonNull @Initialized FormatTransform.FORMAT getOutputFormat();

    public void setOutputFormat( @UnknownKeyFor @NonNull @Initialized FormatTransform.FORMAT var1);

    @Description(value="URL to credentials in Vault")
    public @UnknownKeyFor @NonNull @Initialized String getSecretStoreUrl();

    public void setSecretStoreUrl(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Vault token")
    public @UnknownKeyFor @NonNull @Initialized String getVaultToken();

    public void setVaultToken(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The path to the trust store file")
    public @UnknownKeyFor @NonNull @Initialized String getTruststorePath();

    public void setTruststorePath(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The path to the key store file")
    public @UnknownKeyFor @NonNull @Initialized String getKeystorePath();

    public void setKeystorePath(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The password for the trust store password")
    public @UnknownKeyFor @NonNull @Initialized String getTruststorePassword();

    public void setTruststorePassword(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The store password for the key store password")
    public @UnknownKeyFor @NonNull @Initialized String getKeystorePassword();

    public void setKeystorePassword(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The password of the private key in the key store file")
    public @UnknownKeyFor @NonNull @Initialized String getKeyPassword();

    public void setKeyPassword(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Additional kafka consumer configs to be applied to Kafka Consumer (e.g. key1=value1;key2=value2).")
    public @Nullable @UnknownKeyFor @Initialized String getKafkaConsumerConfig();

    public void setKafkaConsumerConfig(@UnknownKeyFor @NonNull @Initialized String var1);
}

