/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import java.util.Arrays;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.managed.Managed;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.Filter;
import org.apache.beam.sdk.transforms.JsonToRow;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class IcebergTaxiExamples {
    private static final @UnknownKeyFor @NonNull @Initialized String TAXI_RIDES_TOPIC = "projects/pubsub-public-data/topics/taxirides-realtime";
    private static final @UnknownKeyFor @NonNull @Initialized Schema TAXI_RIDE_INFO_SCHEMA = Schema.builder().addStringField("ride_id").addInt32Field("point_idx").addDoubleField("latitude").addDoubleField("longitude").addStringField("timestamp").addDoubleField("meter_reading").addDoubleField("meter_increment").addStringField("ride_status").addInt32Field("passenger_count").build();

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        IcebergPipelineOptions options = (IcebergPipelineOptions)PipelineOptionsFactory.fromArgs((String[])args).as(IcebergPipelineOptions.class);
        options.setProject("apache-beam-testing");
        String tableIdentifierTemplate = "iceberg_taxi.{passenger_count}_passengers";
        ImmutableMap catalogProps = ImmutableMap.builder().put((Object)"catalog-impl", (Object)options.getCatalogImpl()).put((Object)"warehouse", (Object)options.getWarehouse()).build();
        ImmutableMap icebergWriteConfig = ImmutableMap.builder().put((Object)"table", (Object)tableIdentifierTemplate).put((Object)"catalog_name", (Object)options.getCatalogName()).put((Object)"catalog_properties", (Object)catalogProps).put((Object)"triggering_frequency_seconds", (Object)10).put((Object)"keep", Arrays.asList("ride_id", "meter_reading")).build();
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)p.apply((PTransform)PubsubIO.readStrings().fromTopic(TAXI_RIDES_TOPIC))).apply(JsonToRow.withSchema((Schema)TAXI_RIDE_INFO_SCHEMA))).apply((PTransform)Filter.create().whereFieldName("ride_status", "dropoff"::equals))).apply((PTransform)Managed.write((String)"iceberg").withConfig((Map)icebergWriteConfig));
        p.run();
    }

    public static interface IcebergPipelineOptions
    extends GcpOptions {
        @Description(value="Warehouse location where the table's data will be written to.")
        @Default.String(value="gs://apache-beam-samples/iceberg-examples")
        public @UnknownKeyFor @NonNull @Initialized String getWarehouse();

        public void setWarehouse(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Fully-qualified name of the catalog class to use.")
        @Default.String(value="org.apache.iceberg.hadoop.HadoopCatalog")
        public @UnknownKeyFor @NonNull @Initialized String getCatalogImpl();

        public void setCatalogImpl(@UnknownKeyFor @NonNull @Initialized String var1);

        @Validation.Required
        @Default.String(value="example-catalog")
        public @UnknownKeyFor @NonNull @Initialized String getCatalogName();

        public void setCatalogName(@UnknownKeyFor @NonNull @Initialized String var1);
    }
}

