/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MaxPerKeyExamples {
    private static final @UnknownKeyFor @NonNull @Initialized String WEATHER_SAMPLES_TABLE = "apache-beam-testing.samples.weather_stations";

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        MaxPerKeyExamples.runMaxPerKeyExamples(options);
    }

    static void runMaxPerKeyExamples(@UnknownKeyFor @NonNull @Initialized Options options) {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>();
        fields.add(new TableFieldSchema().setName("month").setType("INTEGER"));
        fields.add(new TableFieldSchema().setName("max_mean_temp").setType("FLOAT"));
        TableSchema schema = new TableSchema().setFields(fields);
        ((PCollection)((PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(options.getInput()))).apply((PTransform)new MaxMeanTemp())).apply((PTransform)BigQueryIO.writeTableRows().to(options.getOutput()).withSchema(schema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        p.run().waitUntilFinish();
    }

    public static interface Options
    extends PipelineOptions {
        @Description(value="Table to read from, specified as <project_id>:<dataset_id>.<table_id>")
        @Default.String(value="apache-beam-testing.samples.weather_stations")
        public @UnknownKeyFor @NonNull @Initialized String getInput();

        public void setInput(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Table to write to, specified as <project_id>:<dataset_id>.<table_id>")
        @Validation.Required
        public @UnknownKeyFor @NonNull @Initialized String getOutput();

        public void setOutput(@UnknownKeyFor @NonNull @Initialized String var1);
    }

    static class MaxMeanTemp
    extends PTransform<PCollection<TableRow>, PCollection<TableRow>> {
        MaxMeanTemp() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> rows) {
            PCollection temps = (PCollection)rows.apply((PTransform)ParDo.of((DoFn)new ExtractTempFn()));
            PCollection tempMaxes = (PCollection)temps.apply((PTransform)Max.doublesPerKey());
            PCollection results = (PCollection)tempMaxes.apply((PTransform)ParDo.of((DoFn)new FormatMaxesFn()));
            return results;
        }
    }

    static class FormatMaxesFn
    extends DoFn<KV<Integer, Double>, TableRow> {
        FormatMaxesFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            TableRow row = new TableRow().set("month", ((KV)c.element()).getKey()).set("max_mean_temp", ((KV)c.element()).getValue());
            c.output((Object)row);
        }
    }

    static class ExtractTempFn
    extends DoFn<TableRow, KV<Integer, Double>> {
        ExtractTempFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            TableRow row = (TableRow)c.element();
            Integer month = Integer.parseInt((String)row.get((Object)"month"));
            Double meanTemp = Double.parseDouble(row.get((Object)"mean_temp").toString());
            c.output((Object)KV.of((Object)month, (Object)meanTemp));
        }
    }
}

