/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.subprocess.kernel;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.beam.examples.subprocess.configuration.SubProcessConfiguration;
import org.apache.beam.examples.subprocess.utils.FileUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubProcessIOFiles
implements Closeable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SubProcessIOFiles.class);
    @UnknownKeyFor @NonNull @Initialized Path errFile;
    @UnknownKeyFor @NonNull @Initialized Path outFile;
    @UnknownKeyFor @NonNull @Initialized Path resultFile;
    @UnknownKeyFor @NonNull @Initialized Path base;
    @UnknownKeyFor @NonNull @Initialized String errFileLocation = "";
    @UnknownKeyFor @NonNull @Initialized String outFileLocation = "";
    @UnknownKeyFor @NonNull @Initialized String uuid = UUID.randomUUID().toString();

    public @UnknownKeyFor @NonNull @Initialized String getErrFileLocation() {
        return this.errFileLocation;
    }

    public @UnknownKeyFor @NonNull @Initialized String getOutFileLocation() {
        return this.outFileLocation;
    }

    public SubProcessIOFiles(@UnknownKeyFor @NonNull @Initialized String workerWorkingDirectory) {
        this.base = Paths.get(workerWorkingDirectory, new String[0]);
        this.errFile = Paths.get(this.base.toString(), this.uuid + ".err");
        this.outFile = Paths.get(this.base.toString(), this.uuid + ".out");
        this.resultFile = Paths.get(this.base.toString(), this.uuid + ".res");
    }

    public @UnknownKeyFor @NonNull @Initialized Path getErrFile() {
        return this.errFile;
    }

    public @UnknownKeyFor @NonNull @Initialized Path getOutFile() {
        return this.outFile;
    }

    public @UnknownKeyFor @NonNull @Initialized Path getResultFile() {
        return this.resultFile;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (Files.exists(this.outFile, new LinkOption[0])) {
            Files.delete(this.outFile);
        }
        if (Files.exists(this.errFile, new LinkOption[0])) {
            Files.delete(this.errFile);
        }
        if (Files.exists(this.resultFile, new LinkOption[0])) {
            Files.delete(this.resultFile);
        }
    }

    public void copyOutPutFilesToBucket(@UnknownKeyFor @NonNull @Initialized SubProcessConfiguration configuration, @UnknownKeyFor @NonNull @Initialized String params) {
        if (Files.exists(this.outFile, new LinkOption[0]) || Files.exists(this.errFile, new LinkOption[0])) {
            try {
                this.outFileLocation = FileUtils.copyFileFromWorkerToGCS(configuration, this.outFile);
            }
            catch (Exception ex) {
                LOG.error("Error uploading log file to storage ", (Throwable)ex);
            }
            try {
                this.errFileLocation = FileUtils.copyFileFromWorkerToGCS(configuration, this.errFile);
            }
            catch (Exception ex) {
                LOG.error("Error uploading log file to storage ", (Throwable)ex);
            }
            LOG.info(String.format("Log Files for process: %s outFile was: %s errFile was: %s", params, this.outFileLocation, this.errFileLocation));
        } else {
            LOG.error(String.format("There was no output file or err file for process %s", params));
        }
    }
}

