/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.python.transforms;

import org.apache.beam.sdk.extensions.python.PythonExternalTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.PythonCallableSource;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;

public class DataframeTransform
extends PTransform<PCollection<Row>, PCollection<Row>> {
    private final String func;
    private final boolean includeIndexes;
    private final String expansionService;

    public static DataframeTransform of(String func) {
        return new DataframeTransform(func, false, "");
    }

    public DataframeTransform withIndexes() {
        return new DataframeTransform(this.func, true, this.expansionService);
    }

    public DataframeTransform withExpansionService(String expansionService) {
        return new DataframeTransform(this.func, this.includeIndexes, expansionService);
    }

    private DataframeTransform(String func, boolean includeIndexes, String expansionService) {
        this.func = func;
        this.includeIndexes = includeIndexes;
        this.expansionService = expansionService;
    }

    public PCollection<Row> expand(PCollection<Row> input) {
        return (PCollection)input.apply(PythonExternalTransform.from("apache_beam.dataframe.transforms.DataframeTransform", this.expansionService).withKwarg("func", PythonCallableSource.of((String)this.func)).withKwarg("include_indexes", this.includeIndexes));
    }
}

