/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.python.transforms;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.python.PythonExternalTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.PythonCallableSource;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PythonMap<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
extends PTransform<PCollection<? extends InputT>, PCollection<OutputT>> {
    private @UnknownKeyFor @NonNull @Initialized PythonCallableSource pythonFunction;
    private @Nullable @UnknownKeyFor @Initialized String expansionService;
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outputCoder;
    private static final @UnknownKeyFor @NonNull @Initialized String PYTHON_MAP_FN_TRANSFORM = "apache_beam.Map";
    private static final @UnknownKeyFor @NonNull @Initialized String PYTHON_FLATMAP_FN_TRANSFORM = "apache_beam.FlatMap";
    private @UnknownKeyFor @NonNull @Initialized String pythonTransform;

    private PythonMap(@UnknownKeyFor @NonNull @Initialized PythonCallableSource pythonFunction, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outputCoder, @UnknownKeyFor @NonNull @Initialized String pythonTransform) {
        this.pythonFunction = pythonFunction;
        this.outputCoder = outputCoder;
        this.pythonTransform = pythonTransform;
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized PythonMap<InputT, OutputT> viaMapFn(@UnknownKeyFor @NonNull @Initialized String pythonFunction, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outputCoder) {
        return new PythonMap<InputT, OutputT>(PythonCallableSource.of((String)pythonFunction), outputCoder, PYTHON_MAP_FN_TRANSFORM);
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized PythonMap<InputT, OutputT> viaFlatMapFn(@UnknownKeyFor @NonNull @Initialized String pythonFunction, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outputCoder) {
        return new PythonMap<InputT, OutputT>(PythonCallableSource.of((String)pythonFunction), outputCoder, PYTHON_FLATMAP_FN_TRANSFORM);
    }

    public @UnknownKeyFor @NonNull @Initialized PythonMap<InputT, OutputT> withExpansionService(@UnknownKeyFor @NonNull @Initialized String expansionService) {
        this.expansionService = expansionService;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends InputT> input) {
        this.expansionService = this.expansionService != null ? this.expansionService : "";
        PythonExternalTransform pythonMapElements = PythonExternalTransform.from(this.pythonTransform, this.expansionService);
        pythonMapElements.withArgs(this.pythonFunction);
        pythonMapElements.withOutputCoder(this.outputCoder);
        return (PCollection)input.apply(pythonMapElements);
    }
}

