/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.python.transforms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.extensions.python.PythonExternalTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.PythonCallableSource;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunInference<@UnknownKeyFor OutputT>
extends PTransform<PCollection<?>, PCollection<OutputT>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(RunInference.class);
    private final @UnknownKeyFor @NonNull @Initialized String modelLoader;
    private final @UnknownKeyFor @NonNull @Initialized Schema schema;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> kwargs;
    private final @UnknownKeyFor @NonNull @Initialized String expansionService;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyCoder;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> extraPackages;

    public static @UnknownKeyFor @NonNull @Initialized RunInference<@UnknownKeyFor @NonNull @Initialized Row> of(@UnknownKeyFor @NonNull @Initialized String modelLoader, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType exampleType, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType inferenceType) {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"example", (Schema.FieldType)exampleType), Schema.Field.of((String)"inference", (Schema.FieldType)inferenceType)});
        return new RunInference<Row>(modelLoader, schema, (Map<String, Object>)ImmutableMap.of(), null, "");
    }

    public static <KeyT> @UnknownKeyFor @NonNull @Initialized RunInference<@UnknownKeyFor @NonNull @Initialized KV<KeyT, @UnknownKeyFor @NonNull @Initialized Row>> ofKVs(@UnknownKeyFor @NonNull @Initialized String modelLoader, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType exampleType, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType inferenceType, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder) {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"example", (Schema.FieldType)exampleType), Schema.Field.of((String)"inference", (Schema.FieldType)inferenceType)});
        return new RunInference<KV<KeyT, Row>>(modelLoader, schema, (Map<String, Object>)ImmutableMap.of(), keyCoder, "");
    }

    public static @UnknownKeyFor @NonNull @Initialized RunInference<@UnknownKeyFor @NonNull @Initialized Row> of(@UnknownKeyFor @NonNull @Initialized String modelLoader, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new RunInference<Row>(modelLoader, schema, (Map<String, Object>)ImmutableMap.of(), null, "");
    }

    public static <KeyT> @UnknownKeyFor @NonNull @Initialized RunInference<@UnknownKeyFor @NonNull @Initialized KV<KeyT, @UnknownKeyFor @NonNull @Initialized Row>> ofKVs(@UnknownKeyFor @NonNull @Initialized String modelLoader, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder) {
        return new RunInference<KV<KeyT, Row>>(modelLoader, schema, (Map<String, Object>)ImmutableMap.of(), keyCoder, "");
    }

    public @UnknownKeyFor @NonNull @Initialized RunInference<OutputT> withKwarg(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized Object arg) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.kwargs).put((Object)key, arg);
        return new RunInference<OutputT>(this.modelLoader, this.schema, (Map<String, Object>)builder.build(), this.keyCoder, this.expansionService);
    }

    public void withExtraPackages(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> extraPackages) {
        if (!this.extraPackages.isEmpty()) {
            throw new IllegalArgumentException("Extra packages were already specified");
        }
        this.extraPackages.addAll(extraPackages);
    }

    public @UnknownKeyFor @NonNull @Initialized RunInference<OutputT> withExpansionService(@UnknownKeyFor @NonNull @Initialized String expansionService) {
        return new RunInference<OutputT>(this.modelLoader, this.schema, this.kwargs, this.keyCoder, expansionService);
    }

    private RunInference(@UnknownKeyFor @NonNull @Initialized String modelLoader, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> kwargs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyCoder, @UnknownKeyFor @NonNull @Initialized String expansionService) {
        this.modelLoader = modelLoader;
        this.schema = schema;
        this.kwargs = kwargs;
        this.keyCoder = keyCoder;
        this.expansionService = expansionService;
        this.extraPackages = new ArrayList<String>();
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inferExtraPackagesFromModelHandler() {
        ArrayList<String> extraPackages = new ArrayList<String>();
        if (this.modelLoader.toLowerCase().contains("sklearn")) {
            extraPackages.add("scikit-learn");
            extraPackages.add("pandas");
        } else if (this.modelLoader.toLowerCase().contains("pytorch")) {
            extraPackages.add("torch");
        }
        if (!extraPackages.isEmpty()) {
            LOG.info("Automatically inferred dependencies {} from the provided model handler.", extraPackages);
        }
        return extraPackages;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> input) {
        Object outputCoder = this.keyCoder == null ? RowCoder.of((Schema)this.schema) : KvCoder.of(this.keyCoder, (Coder)RowCoder.of((Schema)this.schema));
        if (this.expansionService.isEmpty() && this.extraPackages.isEmpty()) {
            this.extraPackages.addAll(this.inferExtraPackagesFromModelHandler());
        }
        return (PCollection)input.apply(PythonExternalTransform.from("apache_beam.ml.inference.base.RunInference.from_callable", this.expansionService).withKwarg("model_handler_provider", PythonCallableSource.of((String)this.modelLoader)).withOutputCoder((Coder<?>)outputCoder).withExtraPackages(this.extraPackages).withKwargs(this.kwargs));
    }
}

