/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FlatMapElementsJava8Test
implements Serializable {
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    public void testFlatMapBasic() throws Exception {
        TestPipeline pipeline = TestPipeline.create();
        PCollection output = (PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object[])new Integer[]{1, 2, 3}))).apply((PTransform)FlatMapElements.via((SerializableFunction & Serializable)i -> ImmutableList.of((Object)i, (Object)(-i.intValue()))).withOutputType((TypeDescriptor)new TypeDescriptor<Integer>(){}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{1, 3, -1, -3, 2, -2});
        pipeline.run();
    }

    @Test
    public void testFlatMapMethodReference() throws Exception {
        TestPipeline pipeline = TestPipeline.create();
        PCollection output = (PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object[])new Integer[]{1, 2, 3}))).apply((PTransform)FlatMapElements.via(new Negater()::numAndNegation).withOutputType((TypeDescriptor)new TypeDescriptor<Integer>(){}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{1, 3, -1, -3, 2, -2});
        pipeline.run();
    }

    private static class Negater
    implements Serializable {
        private Negater() {
        }

        public List<Integer> numAndNegation(int input) {
            return ImmutableList.of((Object)input, (Object)(-input));
        }
    }
}

