/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30SchemaDefinition;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.util.FileUtil;

public final class OpenApiHelper {
    private OpenApiHelper() {
    }

    public static String buildUrl(String path1, String path2) {
        String s1 = FileUtil.stripTrailingSeparator((String)path1);
        String s2 = FileUtil.stripLeadingSeparator((String)path2);
        if (s1 != null && s2 != null) {
            return s1 + "/" + s2;
        }
        if (path1 != null) {
            return path1;
        }
        return path2;
    }

    public static void clearVendorExtensions(OasDocument openApi) {
        block11: {
            block10: {
                if (!(openApi instanceof Oas20Document)) break block10;
                openApi.clearExtensions();
                if (((Oas20Document)openApi).definitions != null && ((Oas20Document)openApi).definitions.getDefinitions() != null) {
                    for (Oas20SchemaDefinition schemaDefinition : ((Oas20Document)openApi).definitions.getDefinitions()) {
                        schemaDefinition.clearExtensions();
                    }
                }
                if (openApi.paths == null) break block11;
                for (OasPathItem path : openApi.paths.getPathItems()) {
                    path.clearExtensions();
                    for (OasOperation op : OpenApiHelper.getOperationMap(path).values()) {
                        op.clearExtensions();
                    }
                }
                break block11;
            }
            if (openApi instanceof Oas30Document) {
                openApi.clearExtensions();
                if (((Oas30Document)openApi).components != null && ((Oas30Document)openApi).components.schemas != null) {
                    for (Oas30SchemaDefinition schemaDefinition : ((Oas30Document)openApi).components.schemas.values()) {
                        schemaDefinition.clearExtensions();
                    }
                }
                if (openApi.paths != null) {
                    for (OasPathItem path : openApi.paths.getPathItems()) {
                        path.clearExtensions();
                        for (OasOperation op : OpenApiHelper.getOperationMap(path).values()) {
                            op.clearExtensions();
                        }
                    }
                }
            }
        }
    }

    private static Map<HttpMethod, OasOperation> getOperationMap(OasPathItem path) {
        LinkedHashMap<HttpMethod, OasOperation> result = new LinkedHashMap<HttpMethod, OasOperation>();
        if (path.get != null) {
            result.put(HttpMethod.GET, path.get);
        }
        if (path.put != null) {
            result.put(HttpMethod.PUT, path.put);
        }
        if (path.post != null) {
            result.put(HttpMethod.POST, path.post);
        }
        if (path.delete != null) {
            result.put(HttpMethod.DELETE, path.delete);
        }
        if (path.patch != null) {
            result.put(HttpMethod.PATCH, path.patch);
        }
        if (path.head != null) {
            result.put(HttpMethod.HEAD, path.head);
        }
        if (path.options != null) {
            result.put(HttpMethod.OPTIONS, path.options);
        }
        return result;
    }

    static enum HttpMethod {
        POST,
        GET,
        PUT,
        PATCH,
        DELETE,
        HEAD,
        OPTIONS;

    }
}

