/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.AuthorizationCodeOAuthFlow;
import io.apicurio.datamodels.core.models.common.ClientCredentialsOAuthFlow;
import io.apicurio.datamodels.core.models.common.ImplicitOAuthFlow;
import io.apicurio.datamodels.core.models.common.PasswordOAuthFlow;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.models.common.Tag;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.models.OasSecurityRequirement;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Header;
import io.apicurio.datamodels.openapi.v2.models.Oas20Items;
import io.apicurio.datamodels.openapi.v2.models.Oas20Operation;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20Response;
import io.apicurio.datamodels.openapi.v2.models.Oas20Schema;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;
import io.apicurio.datamodels.openapi.v2.visitors.Oas20AllNodeVisitor;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Header;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;
import io.apicurio.datamodels.openapi.v3.models.Oas30Operation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import io.apicurio.datamodels.openapi.v3.models.Oas30SchemaDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityScheme;
import io.apicurio.datamodels.openapi.v3.visitors.Oas30AllNodeVisitor;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.PasswordSchema;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestOperationParamDefinition;
import org.apache.camel.model.rest.RestOperationResponseHeaderDefinition;
import org.apache.camel.model.rest.RestOperationResponseMsgDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.RestPropertyDefinition;
import org.apache.camel.model.rest.RestSecuritiesDefinition;
import org.apache.camel.model.rest.RestSecuritiesRequirement;
import org.apache.camel.model.rest.RestSecurityApiKey;
import org.apache.camel.model.rest.RestSecurityBasicAuth;
import org.apache.camel.model.rest.RestSecurityBearerToken;
import org.apache.camel.model.rest.RestSecurityDefinition;
import org.apache.camel.model.rest.RestSecurityMutualTLS;
import org.apache.camel.model.rest.RestSecurityOAuth2;
import org.apache.camel.model.rest.RestSecurityOpenIdConnect;
import org.apache.camel.model.rest.SecurityDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.openapi.BeanConfig;
import org.apache.camel.openapi.OpenApiHelper;
import org.apache.camel.openapi.RestModelConverters;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.FileUtil;

public class RestOpenApiReader {
    public static final String OAS20_SCHEMA_DEFINITION_PREFIX = "#/definitions/";
    public static final String OAS30_SCHEMA_DEFINITION_PREFIX = "#/components/schemas/";
    private static final Set<String> NO_REFERENCE_TYPE_NAMES = new HashSet<String>(Arrays.asList("byte", "char", "short", "int", "java.lang.Integer", "long", "java.lang.Long", "float", "java.lang.Float", "double", "java.lang.Double", "string", "java.lang.String", "boolean", "java.lang.Boolean", "file", "java.io.File"));

    private static String getValue(CamelContext camelContext, String text) {
        return camelContext.resolvePropertyPlaceholders(text);
    }

    private static List<String> getValue(CamelContext camelContext, List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> answer = new ArrayList<String>();
        for (String line : list) {
            answer.add(camelContext.resolvePropertyPlaceholders(line));
        }
        return answer;
    }

    public OasDocument read(CamelContext camelContext, List<RestDefinition> rests, BeanConfig config, String camelContextId, ClassResolver classResolver) throws ClassNotFoundException {
        Object openApi = config.isOpenApi3() ? new Oas30Document() : new Oas20Document();
        for (RestDefinition rest : rests) {
            this.parse(camelContext, (OasDocument)openApi, rest, camelContextId, classResolver);
        }
        this.shortenClassNames((OasDocument)openApi);
        if (openApi.paths == null) {
            openApi.paths = openApi.createPaths();
        }
        if (openApi.tags != null) {
            openApi.tags = new ArrayList(openApi.tags.stream().collect(Collectors.toMap(Tag::getName, Function.identity(), (prev, current) -> prev)).values());
        }
        openApi = config.configure((OasDocument)openApi);
        return openApi;
    }

    private void parse(CamelContext camelContext, OasDocument openApi, RestDefinition rest, String camelContextId, ClassResolver classResolver) throws ClassNotFoundException {
        ArrayList<VerbDefinition> verbs = new ArrayList<VerbDefinition>(rest.getVerbs());
        verbs.sort(new VerbOrdering(camelContext));
        String pathAsTag = RestOpenApiReader.getValue(camelContext, rest.getTag() != null ? rest.getTag() : rest.getPath());
        if (openApi instanceof Oas20Document) {
            this.parseOas20(camelContext, (Oas20Document)openApi, rest, pathAsTag);
        } else if (openApi instanceof Oas30Document) {
            this.parseOas30((Oas30Document)openApi, rest, pathAsTag);
        }
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (VerbDefinition verb : verbs) {
            String apiDocs = verb.getApiDocs() != null ? verb.getApiDocs() : rest.getApiDocs();
            if (apiDocs != null && !Boolean.parseBoolean(apiDocs)) continue;
            String type = verb.getType();
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)type)) {
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)(type = verb.getOutType()))) {
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
            if (verb.getResponseMsgs() == null) continue;
            for (RestOperationResponseMsgDefinition def : verb.getResponseMsgs()) {
                type = def.getResponseModel();
                if (!org.apache.camel.util.ObjectHelper.isNotEmpty((Object)type)) continue;
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
        }
        for (String type : types) {
            Class clazz = classResolver.resolveMandatoryClass(type);
            this.appendModels(clazz, openApi);
        }
        this.doParseVerbs(camelContext, openApi, rest, camelContextId, verbs, pathAsTag);
        RestSecuritiesRequirement securitiesRequirement = rest.getSecurityRequirements();
        if (securitiesRequirement != null) {
            Collection securityRequirements = securitiesRequirement.securityRequirements();
            securityRequirements.forEach(requirement -> {
                OasSecurityRequirement oasRequirement = openApi.createSecurityRequirement();
                List<Object> scopes = requirement.getScopes() == null || requirement.getScopes().trim().isEmpty() ? Collections.emptyList() : Arrays.asList(requirement.getScopes().trim().split("\\s*,\\s*"));
                oasRequirement.addSecurityRequirementItem(requirement.getKey(), scopes);
                openApi.addSecurityRequirement((SecurityRequirement)oasRequirement);
            });
        }
    }

    private void parseOas30(Oas30Document openApi, RestDefinition rest, String pathAsTag) {
        RestSecuritiesDefinition sd;
        String summary = rest.getDescriptionText();
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)pathAsTag)) {
            openApi.addTag(pathAsTag, summary);
        }
        if ((sd = rest.getSecurityDefinitions()) != null && !sd.getSecurityDefinitions().isEmpty() && openApi.components == null) {
            openApi.components = openApi.createComponents();
        }
        if (sd != null) {
            for (RestSecurityDefinition def : sd.getSecurityDefinitions()) {
                Oas30SecurityScheme auth;
                RestSecurityApiKey rs;
                Oas30SecurityScheme auth2;
                if (def instanceof RestSecurityBasicAuth) {
                    auth2 = openApi.components.createSecurityScheme(def.getKey());
                    auth2.type = "http";
                    auth2.scheme = "basic";
                    auth2.description = def.getDescription();
                    openApi.components.addSecurityScheme(def.getKey(), auth2);
                    continue;
                }
                if (def instanceof RestSecurityBearerToken) {
                    auth2 = openApi.components.createSecurityScheme(def.getKey());
                    auth2.type = "http";
                    auth2.scheme = "bearer";
                    auth2.description = def.getDescription();
                    auth2.bearerFormat = ((RestSecurityBearerToken)def).getFormat();
                    openApi.components.addSecurityScheme(def.getKey(), auth2);
                    continue;
                }
                if (def instanceof RestSecurityApiKey) {
                    rs = (RestSecurityApiKey)def;
                    auth = openApi.components.createSecurityScheme(def.getKey());
                    auth.type = "apiKey";
                    auth.description = rs.getDescription();
                    auth.name = rs.getName();
                    if (rs.getInHeader() != null && Boolean.parseBoolean(rs.getInHeader())) {
                        auth.in = "header";
                    } else if (rs.getInQuery() != null && Boolean.parseBoolean(rs.getInQuery())) {
                        auth.in = "query";
                    } else if (rs.getInCookie() != null && Boolean.parseBoolean(rs.getInCookie())) {
                        auth.in = "cookie";
                    } else {
                        throw new IllegalStateException("No API Key location specified.");
                    }
                    openApi.components.addSecurityScheme(def.getKey(), auth);
                    continue;
                }
                if (def instanceof RestSecurityOAuth2) {
                    AuthorizationCodeOAuthFlow oauthFlow;
                    rs = (RestSecurityOAuth2)def;
                    auth = openApi.components.createSecurityScheme(def.getKey());
                    auth.type = "oauth2";
                    auth.description = rs.getDescription();
                    String flow = rs.getFlow();
                    if (flow == null) {
                        flow = this.inferOauthFlow((RestSecurityOAuth2)rs);
                    }
                    if (auth.flows == null) {
                        auth.flows = auth.createOAuthFlows();
                    }
                    switch (flow) {
                        case "authorizationCode": 
                        case "accessCode": {
                            AuthorizationCodeOAuthFlow authorizationCodeOAuthFlow;
                            oauthFlow = authorizationCodeOAuthFlow = auth.flows.createAuthorizationCodeOAuthFlow();
                            auth.flows.authorizationCode = authorizationCodeOAuthFlow;
                            break;
                        }
                        case "implicit": {
                            ImplicitOAuthFlow implicitOAuthFlow = auth.flows.createImplicitOAuthFlow();
                            oauthFlow = implicitOAuthFlow;
                            auth.flows.implicit = implicitOAuthFlow;
                            break;
                        }
                        case "clientCredentials": 
                        case "application": {
                            ClientCredentialsOAuthFlow clientCredentialsOAuthFlow = auth.flows.createClientCredentialsOAuthFlow();
                            oauthFlow = clientCredentialsOAuthFlow;
                            auth.flows.clientCredentials = clientCredentialsOAuthFlow;
                            break;
                        }
                        case "password": {
                            PasswordOAuthFlow passwordOAuthFlow = auth.flows.createPasswordOAuthFlow();
                            oauthFlow = passwordOAuthFlow;
                            auth.flows.password = passwordOAuthFlow;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid OAuth flow '" + flow + "' specified");
                        }
                    }
                    oauthFlow.authorizationUrl = rs.getAuthorizationUrl();
                    oauthFlow.tokenUrl = rs.getTokenUrl();
                    oauthFlow.refreshUrl = rs.getRefreshUrl();
                    for (RestPropertyDefinition scope : rs.getScopes()) {
                        oauthFlow.addScope(scope.getKey(), scope.getValue());
                    }
                    openApi.components.addSecurityScheme(def.getKey(), auth);
                    continue;
                }
                if (def instanceof RestSecurityMutualTLS) {
                    auth2 = openApi.components.createSecurityScheme(def.getKey());
                    auth2.type = "mutualTLS";
                    openApi.components.addSecurityScheme(def.getKey(), auth2);
                    continue;
                }
                if (!(def instanceof RestSecurityOpenIdConnect)) continue;
                auth2 = openApi.components.createSecurityScheme(def.getKey());
                auth2.type = "openIdConnect";
                auth2.openIdConnectUrl = ((RestSecurityOpenIdConnect)def).getUrl();
                openApi.components.addSecurityScheme(def.getKey(), auth2);
            }
        }
    }

    private void parseOas20(CamelContext camelContext, Oas20Document openApi, RestDefinition rest, String pathAsTag) {
        RestSecuritiesDefinition sd;
        String summary = RestOpenApiReader.getValue(camelContext, rest.getDescriptionText());
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)pathAsTag)) {
            openApi.addTag(pathAsTag, summary);
        }
        if ((sd = rest.getSecurityDefinitions()) != null && !sd.getSecurityDefinitions().isEmpty() && openApi.securityDefinitions == null) {
            openApi.securityDefinitions = openApi.createSecurityDefinitions();
        }
        if (sd != null) {
            for (RestSecurityDefinition def : sd.getSecurityDefinitions()) {
                Oas20SecurityScheme auth;
                RestSecurityApiKey rs;
                if (def instanceof RestSecurityBasicAuth) {
                    Oas20SecurityScheme auth2 = openApi.securityDefinitions.createSecurityScheme(RestOpenApiReader.getValue(camelContext, def.getKey()));
                    auth2.type = "basicAuth";
                    auth2.description = RestOpenApiReader.getValue(camelContext, def.getDescription());
                    openApi.securityDefinitions.addSecurityScheme(RestOpenApiReader.getValue(camelContext, def.getKey()), auth2);
                    continue;
                }
                if (def instanceof RestSecurityBearerToken) {
                    throw new IllegalStateException("OpenAPI 2.0 does not support bearer token security schemes.");
                }
                if (def instanceof RestSecurityApiKey) {
                    rs = (RestSecurityApiKey)def;
                    auth = openApi.securityDefinitions.createSecurityScheme(RestOpenApiReader.getValue(camelContext, def.getKey()));
                    auth.type = "apiKey";
                    auth.description = RestOpenApiReader.getValue(camelContext, rs.getDescription());
                    auth.name = RestOpenApiReader.getValue(camelContext, rs.getName());
                    if (rs.getInHeader() != null && CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)rs.getInHeader()).booleanValue()) {
                        auth.in = "header";
                    } else if (rs.getInQuery() != null && CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)rs.getInQuery()).booleanValue()) {
                        auth.in = "query";
                    } else {
                        throw new IllegalStateException("Invalid 'in' value for API Key security scheme");
                    }
                    openApi.securityDefinitions.addSecurityScheme(RestOpenApiReader.getValue(camelContext, def.getKey()), auth);
                    continue;
                }
                if (def instanceof RestSecurityOAuth2) {
                    rs = (RestSecurityOAuth2)def;
                    auth = openApi.securityDefinitions.createSecurityScheme(RestOpenApiReader.getValue(camelContext, def.getKey()));
                    auth.type = "oauth2";
                    auth.description = RestOpenApiReader.getValue(camelContext, rs.getDescription());
                    String flow = rs.getFlow();
                    if (flow == null) {
                        flow = this.inferOauthFlow((RestSecurityOAuth2)rs);
                    }
                    switch (flow) {
                        case "accessCode": 
                        case "authorizationCode": {
                            auth.flow = "accessCode";
                            break;
                        }
                        case "application": 
                        case "clientCredentials": {
                            auth.flow = "application";
                            break;
                        }
                        case "password": 
                        case "implicit": {
                            auth.flow = flow;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid OAuth flow `" + flow + "'");
                        }
                    }
                    auth.authorizationUrl = RestOpenApiReader.getValue(camelContext, rs.getAuthorizationUrl());
                    auth.tokenUrl = RestOpenApiReader.getValue(camelContext, rs.getTokenUrl());
                    if (!rs.getScopes().isEmpty() && auth.scopes == null) {
                        auth.scopes = auth.createScopes();
                    }
                    for (RestPropertyDefinition scope : rs.getScopes()) {
                        auth.scopes.addScope(RestOpenApiReader.getValue(camelContext, scope.getKey()), RestOpenApiReader.getValue(camelContext, scope.getValue()));
                    }
                    if (openApi.securityDefinitions == null) {
                        openApi.securityDefinitions = openApi.createSecurityDefinitions();
                    }
                    openApi.securityDefinitions.addSecurityScheme(RestOpenApiReader.getValue(camelContext, def.getKey()), auth);
                    continue;
                }
                if (def instanceof RestSecurityMutualTLS) {
                    throw new IllegalStateException("Mutual TLS security scheme is not supported");
                }
                if (!(def instanceof RestSecurityOpenIdConnect)) continue;
                throw new IllegalStateException("OpenId Connect security scheme is not supported");
            }
        }
    }

    private String buildBasePath(CamelContext camelContext, RestDefinition rest) {
        String cp;
        String basePath = FileUtil.stripLeadingSeparator((String)RestOpenApiReader.getValue(camelContext, rest.getPath()));
        String string = cp = camelContext.getRestConfiguration() != null ? camelContext.getRestConfiguration().getContextPath() : null;
        if (cp != null) {
            cp = FileUtil.stripLeadingSeparator((String)cp);
            basePath = basePath != null ? cp + "/" + basePath : cp;
        }
        if (basePath != null && !basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        return basePath;
    }

    private void doParseVerbs(CamelContext camelContext, OasDocument openApi, RestDefinition rest, String camelContextId, List<VerbDefinition> verbs, String pathAsTag) {
        String basePath = this.buildBasePath(camelContext, rest);
        for (VerbDefinition verb : verbs) {
            OasPathItem path;
            String apiDocs = verb.getApiDocs() != null ? RestOpenApiReader.getValue(camelContext, verb.getApiDocs()) : RestOpenApiReader.getValue(camelContext, rest.getApiDocs());
            if (apiDocs != null && !Boolean.parseBoolean(apiDocs)) continue;
            String method = verb.asVerb().toLowerCase(Locale.US);
            String opPath = OpenApiHelper.buildUrl(basePath, RestOpenApiReader.getValue(camelContext, verb.getUri()));
            if (openApi.paths == null) {
                openApi.paths = openApi.createPaths();
            }
            if ((path = openApi.paths.getPathItem(opPath)) == null) {
                path = openApi.paths.createPathItem(opPath);
            }
            OasOperation op = path.createOperation(method);
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)pathAsTag)) {
                if (op.tags == null) {
                    op.tags = new ArrayList();
                }
                op.tags.add(pathAsTag);
            }
            String routeId = RestOpenApiReader.getValue(camelContext, verb.getRouteId());
            String operationId = verb.getId() != null ? RestOpenApiReader.getValue(camelContext, verb.getId()) : (rest.getId() != null ? RestOpenApiReader.getValue(camelContext, rest.getId()) : routeId);
            op.operationId = operationId;
            Extension extension = op.createExtension();
            extension.name = "x-camelContextId";
            extension.value = camelContextId;
            op.addExtension(extension.name, extension);
            extension = op.createExtension();
            extension.name = "x-routeId";
            extension.value = routeId;
            op.addExtension(extension.name, extension);
            path = this.setPathOperation(path, op, method);
            String consumes = RestOpenApiReader.getValue(camelContext, verb.getConsumes() != null ? verb.getConsumes() : rest.getConsumes());
            String produces = RestOpenApiReader.getValue(camelContext, verb.getProduces() != null ? verb.getProduces() : rest.getProduces());
            if (openApi instanceof Oas20Document) {
                this.doParseVerbOas20(camelContext, (Oas20Document)openApi, verb, (Oas20Operation)op, consumes, produces);
            } else if (openApi instanceof Oas30Document) {
                this.doParseVerbOas30(camelContext, (Oas30Document)openApi, verb, (Oas30Operation)op, consumes, produces);
            }
            this.doParseResponseMessages(camelContext, openApi, verb, op, produces);
            openApi.paths.addPathItem(opPath, path);
        }
    }

    private void doParseVerbOas30(CamelContext camelContext, Oas30Document openApi, VerbDefinition verb, Oas30Operation op, String consumes, String produces) {
        if (verb.getDescriptionText() != null) {
            op.summary = RestOpenApiReader.getValue(camelContext, verb.getDescriptionText());
        }
        if (Boolean.TRUE.equals(verb.getDeprecated())) {
            op.deprecated = verb.getDeprecated();
        }
        for (SecurityDefinition sd : verb.getSecurity()) {
            ArrayList<String> scopes = new ArrayList<String>();
            if (sd.getScopes() != null) {
                for (String scope : ObjectHelper.createIterable((String)RestOpenApiReader.getValue(camelContext, sd.getScopes()))) {
                    scopes.add(scope);
                }
            }
            OasSecurityRequirement securityRequirement = op.createSecurityRequirement();
            securityRequirement.addSecurityRequirementItem(RestOpenApiReader.getValue(camelContext, sd.getKey()), scopes);
            op.addSecurityRequirement((SecurityRequirement)securityRequirement);
        }
        for (RestOperationParamDefinition param : verb.getParams()) {
            int hasAllowableValues;
            OasParameter parameter = null;
            if (param.getType().equals((Object)RestParamType.body)) {
                parameter = op.createParameter();
                parameter.in = "body";
            } else if (param.getType().equals((Object)RestParamType.formData)) {
                parameter = op.createParameter();
                parameter.in = "formData";
            } else if (param.getType().equals((Object)RestParamType.header)) {
                parameter = op.createParameter();
                parameter.in = "header";
            } else if (param.getType().equals((Object)RestParamType.path)) {
                parameter = op.createParameter();
                parameter.in = "path";
            } else if (param.getType().equals((Object)RestParamType.query)) {
                parameter = op.createParameter();
                parameter.in = "query";
            }
            if (parameter == null) continue;
            parameter.name = RestOpenApiReader.getValue(camelContext, param.getName());
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)param.getDescription())) {
                parameter.description = RestOpenApiReader.getValue(camelContext, param.getDescription());
            }
            parameter.required = param.getRequired();
            if (!parameter.in.equals("body")) {
                Oas30Parameter parameter30 = (Oas30Parameter)parameter;
                Oas30Schema oas30Schema = null;
                boolean isArray = RestOpenApiReader.getValue(camelContext, param.getDataType()).equalsIgnoreCase("array");
                List<String> allowableValues = RestOpenApiReader.getValue(camelContext, param.getAllowableValues());
                int n = hasAllowableValues = allowableValues != null && !allowableValues.isEmpty() ? 1 : 0;
                if (param.getDataType() != null) {
                    String arrayType;
                    parameter30.schema = parameter30.createSchema();
                    oas30Schema = (Oas30Schema)parameter30.schema;
                    oas30Schema.type = RestOpenApiReader.getValue(camelContext, param.getDataType());
                    if (param.getDataFormat() != null) {
                        oas30Schema.format = RestOpenApiReader.getValue(camelContext, param.getDataFormat());
                    }
                    if (isArray && (arrayType = RestOpenApiReader.getValue(camelContext, param.getArrayType())) != null) {
                        if (arrayType.equalsIgnoreCase("string")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, String.class);
                        }
                        if (arrayType.equalsIgnoreCase("int") || arrayType.equalsIgnoreCase("integer")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, Integer.class);
                        }
                        if (arrayType.equalsIgnoreCase("long")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, Long.class);
                        }
                        if (arrayType.equalsIgnoreCase("float")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, Float.class);
                        }
                        if (arrayType.equalsIgnoreCase("double")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, Double.class);
                        }
                        if (arrayType.equalsIgnoreCase("boolean")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, Boolean.class);
                        }
                        if (arrayType.equalsIgnoreCase("byte")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, ByteArraySchema.class);
                        }
                        if (arrayType.equalsIgnoreCase("binary")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, BinarySchema.class);
                        }
                        if (arrayType.equalsIgnoreCase("date")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, DateSchema.class);
                        }
                        if (arrayType.equalsIgnoreCase("date-time")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, DateTimeSchema.class);
                        }
                        if (arrayType.equalsIgnoreCase("password")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, PasswordSchema.class);
                        }
                    }
                }
                if (param.getCollectionFormat() != null) {
                    parameter30.style = RestOpenApiReader.getValue(camelContext, param.getCollectionFormat().name());
                }
                if (hasAllowableValues != 0 && !isArray) {
                    oas30Schema.enum_ = allowableValues;
                }
                if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)param.getDefaultValue())) {
                    oas30Schema.default_ = RestOpenApiReader.getValue(camelContext, param.getDefaultValue());
                }
                if (param.getExamples() != null && !param.getExamples().isEmpty()) {
                    boolean emptyKey;
                    Extension exampleExtension = parameter30.createExtension();
                    boolean bl = emptyKey = ((RestPropertyDefinition)param.getExamples().get(0)).getKey().length() == 0;
                    if (emptyKey) {
                        exampleExtension.name = "x-example";
                        exampleExtension.value = RestOpenApiReader.getValue(camelContext, ((RestPropertyDefinition)param.getExamples().get(0)).getValue());
                        parameter30.addExtension("x-example", exampleExtension);
                    } else {
                        LinkedHashMap<String, String> exampleValue = new LinkedHashMap<String, String>();
                        exampleValue.put(RestOpenApiReader.getValue(camelContext, ((RestPropertyDefinition)param.getExamples().get(0)).getKey()), RestOpenApiReader.getValue(camelContext, ((RestPropertyDefinition)param.getExamples().get(0)).getValue()));
                        exampleExtension.name = "x-examples";
                        exampleExtension.value = exampleValue;
                        parameter30.addExtension("x-examples", exampleExtension);
                    }
                }
            }
            if (parameter.in.equals("body")) {
                Oas30Schema model;
                Oas30Parameter bp = (Oas30Parameter)parameter;
                String type = RestOpenApiReader.getValue(camelContext, param.getDataType() != null ? param.getDataType() : verb.getType());
                if (type != null) {
                    if (type.endsWith("[]")) {
                        type = type.substring(0, type.length() - 2);
                        Oas30Schema arrayModel = (Oas30Schema)bp.createSchema();
                        arrayModel = this.modelTypeAsProperty(type, (OasDocument)openApi, (OasSchema)arrayModel);
                        bp.schema = arrayModel;
                    } else {
                        String ref = this.modelTypeAsRef(type, (OasDocument)openApi);
                        if (ref != null) {
                            Oas30Schema refModel = (Oas30Schema)bp.createSchema();
                            refModel.$ref = OAS30_SCHEMA_DEFINITION_PREFIX + ref;
                            bp.schema = refModel;
                        } else {
                            model = (Oas30Schema)bp.createSchema();
                            model = this.modelTypeAsProperty(type, (OasDocument)openApi, (OasSchema)model);
                            bp.schema = model;
                        }
                    }
                }
                if (consumes != null) {
                    Oas30Schema parts = consumes.split(",");
                    if (op.requestBody == null) {
                        op.requestBody = op.createRequestBody();
                        op.requestBody.required = param.getRequired();
                        op.requestBody.description = RestOpenApiReader.getValue(camelContext, param.getDescription());
                    }
                    model = parts;
                    hasAllowableValues = ((String[])model).length;
                    for (int i = 0; i < hasAllowableValues; ++i) {
                        Oas30Schema part = model[i];
                        Oas30MediaType mediaType = op.requestBody.createMediaType((String)part);
                        mediaType.schema = mediaType.createSchema();
                        mediaType.schema.$ref = bp.schema.$ref;
                        op.requestBody.addMediaType((String)part, mediaType);
                    }
                }
                if (param.getExamples() != null) {
                    boolean emptyKey;
                    Extension exampleExtension = op.requestBody.createExtension();
                    boolean bl = emptyKey = ((RestPropertyDefinition)param.getExamples().get(0)).getKey().length() == 0;
                    if (emptyKey) {
                        exampleExtension.name = "x-example";
                        exampleExtension.value = RestOpenApiReader.getValue(camelContext, ((RestPropertyDefinition)param.getExamples().get(0)).getValue());
                        op.requestBody.addExtension("x-example", exampleExtension);
                    } else {
                        LinkedHashMap<String, String> exampleValue = new LinkedHashMap<String, String>();
                        exampleValue.put(RestOpenApiReader.getValue(camelContext, ((RestPropertyDefinition)param.getExamples().get(0)).getKey()), RestOpenApiReader.getValue(camelContext, ((RestPropertyDefinition)param.getExamples().get(0)).getValue()));
                        exampleExtension.name = "x-examples";
                        exampleExtension.value = exampleValue;
                        op.requestBody.addExtension("x-examples", exampleExtension);
                    }
                }
                parameter = null;
            }
            op.addParameter(parameter);
        }
        if (op.getParameters() != null && op.getParameters().isEmpty()) {
            op.parameters.clear();
        }
        if (verb.getOutType() != null) {
            if (op.responses == null) {
                op.responses = op.createResponses();
            }
            Oas30Response response = (Oas30Response)op.responses.createResponse("200");
            if (produces != null) {
                String[] parts;
                for (String produce : parts = produces.split(",")) {
                    Oas30MediaType contentType = response.createMediaType(produce);
                    response.addMediaType(produce, contentType);
                    Oas30Schema model = contentType.createSchema();
                    contentType.schema = model = this.modelTypeAsProperty(RestOpenApiReader.getValue(camelContext, verb.getOutType()), (OasDocument)openApi, (OasSchema)model);
                    response.description = "Output type";
                    op.responses.addResponse("200", (OasResponse)response);
                }
            }
        }
    }

    private void doParseVerbOas20(CamelContext camelContext, Oas20Document openApi, VerbDefinition verb, Oas20Operation op, String consumes, String produces) {
        Object parts;
        if (consumes != null) {
            parts = consumes.split(",");
            if (op.consumes == null) {
                op.consumes = new ArrayList();
            }
            op.consumes.addAll(Arrays.asList(parts));
        }
        if (Boolean.TRUE.equals(verb.getDeprecated())) {
            op.deprecated = verb.getDeprecated();
        }
        if (produces != null) {
            parts = produces.split(",");
            if (op.produces == null) {
                op.produces = new ArrayList();
            }
            op.produces.addAll(Arrays.asList(parts));
        }
        if (verb.getDescriptionText() != null) {
            op.summary = RestOpenApiReader.getValue(camelContext, verb.getDescriptionText());
        }
        for (SecurityDefinition sd : verb.getSecurity()) {
            ArrayList<String> scopes = new ArrayList<String>();
            if (sd.getScopes() != null) {
                for (String scope : ObjectHelper.createIterable((String)RestOpenApiReader.getValue(camelContext, sd.getScopes()))) {
                    scopes.add(scope);
                }
            }
            OasSecurityRequirement securityRequirement = op.createSecurityRequirement();
            securityRequirement.addSecurityRequirementItem(RestOpenApiReader.getValue(camelContext, sd.getKey()), scopes);
            op.addSecurityRequirement((SecurityRequirement)securityRequirement);
        }
        for (RestOperationParamDefinition param : verb.getParams()) {
            OasParameter parameter = null;
            if (param.getType().equals((Object)RestParamType.body)) {
                parameter = op.createParameter();
                parameter.in = "body";
            } else if (param.getType().equals((Object)RestParamType.formData)) {
                parameter = op.createParameter();
                parameter.in = "formData";
            } else if (param.getType().equals((Object)RestParamType.header)) {
                parameter = op.createParameter();
                parameter.in = "header";
            } else if (param.getType().equals((Object)RestParamType.path)) {
                parameter = op.createParameter();
                parameter.in = "path";
            } else if (param.getType().equals((Object)RestParamType.query)) {
                parameter = op.createParameter();
                parameter.in = "query";
            }
            if (parameter == null) continue;
            parameter.name = RestOpenApiReader.getValue(camelContext, param.getName());
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)param.getDescription())) {
                parameter.description = RestOpenApiReader.getValue(camelContext, param.getDescription());
            }
            parameter.required = param.getRequired();
            if (!parameter.in.equals("body")) {
                boolean hasAllowableValues;
                Oas20Parameter serializableParameter = (Oas20Parameter)parameter;
                boolean isArray = RestOpenApiReader.getValue(camelContext, param.getDataType()).equalsIgnoreCase("array");
                List<String> allowableValues = RestOpenApiReader.getValue(camelContext, param.getAllowableValues());
                boolean bl = hasAllowableValues = allowableValues != null && !allowableValues.isEmpty();
                if (param.getDataType() != null) {
                    serializableParameter.type = param.getDataType();
                    if (param.getDataFormat() != null) {
                        serializableParameter.format = RestOpenApiReader.getValue(camelContext, param.getDataFormat());
                    }
                    if (isArray && param.getArrayType() != null) {
                        String arrayType = RestOpenApiReader.getValue(camelContext, param.getArrayType());
                        if (arrayType.equalsIgnoreCase("string")) {
                            RestOpenApiReader.defineItems(serializableParameter, allowableValues, new Oas20Items(), String.class);
                        }
                        if (arrayType.equalsIgnoreCase("int") || arrayType.equalsIgnoreCase("integer")) {
                            RestOpenApiReader.defineItems(serializableParameter, allowableValues, new Oas20Items(), Integer.class);
                        }
                        if (arrayType.equalsIgnoreCase("long")) {
                            RestOpenApiReader.defineItems(serializableParameter, allowableValues, new Oas20Items(), Long.class);
                        }
                        if (arrayType.equalsIgnoreCase("float")) {
                            RestOpenApiReader.defineItems(serializableParameter, allowableValues, new Oas20Items(), Float.class);
                        }
                        if (arrayType.equalsIgnoreCase("double")) {
                            RestOpenApiReader.defineItems(serializableParameter, allowableValues, new Oas20Items(), Double.class);
                        }
                        if (arrayType.equalsIgnoreCase("boolean")) {
                            RestOpenApiReader.defineItems(serializableParameter, allowableValues, new Oas20Items(), Boolean.class);
                        }
                    }
                }
                if (param.getCollectionFormat() != null) {
                    serializableParameter.collectionFormat = param.getCollectionFormat().name();
                }
                if (hasAllowableValues && !isArray) {
                    serializableParameter.enum_ = allowableValues;
                }
                if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)param.getDefaultValue())) {
                    serializableParameter.default_ = RestOpenApiReader.getValue(camelContext, param.getDefaultValue());
                }
                if (param.getExamples() != null && !param.getExamples().isEmpty()) {
                    boolean emptyKey;
                    Extension exampleExtension = serializableParameter.createExtension();
                    boolean bl2 = emptyKey = ((RestPropertyDefinition)param.getExamples().get(0)).getKey().length() == 0;
                    if (emptyKey) {
                        exampleExtension.name = "x-example";
                        exampleExtension.value = RestOpenApiReader.getValue(camelContext, ((RestPropertyDefinition)param.getExamples().get(0)).getValue());
                        serializableParameter.addExtension("x-example", exampleExtension);
                    } else {
                        LinkedHashMap<String, String> exampleValue = new LinkedHashMap<String, String>();
                        exampleValue.put(RestOpenApiReader.getValue(camelContext, ((RestPropertyDefinition)param.getExamples().get(0)).getKey()), RestOpenApiReader.getValue(camelContext, ((RestPropertyDefinition)param.getExamples().get(0)).getValue()));
                        exampleExtension.name = "x-examples";
                        exampleExtension.value = exampleValue;
                        serializableParameter.addExtension("x-examples", exampleExtension);
                    }
                }
            }
            if (parameter.in.equals("body")) {
                Oas20Parameter bp = (Oas20Parameter)parameter;
                String type = RestOpenApiReader.getValue(camelContext, param.getDataType() != null ? param.getDataType() : verb.getType());
                if (type != null) {
                    if (type.endsWith("[]")) {
                        type = type.substring(0, type.length() - 2);
                        Oas20Schema arrayModel = (Oas20Schema)bp.createSchema();
                        arrayModel = this.modelTypeAsProperty(type, (OasDocument)openApi, (OasSchema)arrayModel);
                        bp.schema = arrayModel;
                    } else {
                        String ref = this.modelTypeAsRef(type, (OasDocument)openApi);
                        if (ref != null) {
                            Oas20Schema refModel = (Oas20Schema)bp.createSchema();
                            refModel.$ref = OAS20_SCHEMA_DEFINITION_PREFIX + ref;
                            bp.schema = refModel;
                        } else {
                            Oas20Schema model = (Oas20Schema)bp.createSchema();
                            model = this.modelTypeAsProperty(type, (OasDocument)openApi, (OasSchema)model);
                            bp.schema = model;
                        }
                    }
                }
                if (param.getExamples() != null) {
                    boolean emptyKey;
                    Extension exampleExtension = bp.createExtension();
                    boolean bl = emptyKey = ((RestPropertyDefinition)param.getExamples().get(0)).getKey().length() == 0;
                    if (emptyKey) {
                        exampleExtension.name = "x-example";
                        exampleExtension.value = RestOpenApiReader.getValue(camelContext, ((RestPropertyDefinition)param.getExamples().get(0)).getValue());
                        bp.addExtension("x-example", exampleExtension);
                    } else {
                        LinkedHashMap<String, String> exampleValue = new LinkedHashMap<String, String>();
                        exampleValue.put(RestOpenApiReader.getValue(camelContext, ((RestPropertyDefinition)param.getExamples().get(0)).getKey()), RestOpenApiReader.getValue(camelContext, ((RestPropertyDefinition)param.getExamples().get(0)).getValue()));
                        exampleExtension.name = "x-examples";
                        exampleExtension.value = exampleValue;
                        bp.addExtension("x-examples", exampleExtension);
                    }
                }
            }
            op.addParameter(parameter);
        }
        if (op.getParameters() != null && op.getParameters().isEmpty()) {
            op.parameters.clear();
        }
        if (verb.getOutType() != null) {
            if (op.responses == null) {
                op.responses = op.createResponses();
            }
            Oas20Response response = (Oas20Response)op.responses.createResponse("200");
            Oas20Schema model = response.createSchema();
            response.schema = model = this.modelTypeAsProperty(RestOpenApiReader.getValue(camelContext, verb.getOutType()), (OasDocument)openApi, (OasSchema)model);
            response.description = "Output type";
            op.responses.addResponse("200", (OasResponse)response);
        }
    }

    private OasPathItem setPathOperation(OasPathItem path, OasOperation operation, String method) {
        if (method.equals("post")) {
            path.post = operation;
        } else if (method.equals("get")) {
            path.get = operation;
        } else if (method.equals("put")) {
            path.put = operation;
        } else if (method.equals("patch")) {
            path.patch = operation;
        } else if (method.equals("delete")) {
            path.delete = operation;
        } else if (method.equals("head")) {
            path.head = operation;
        } else if (method.equals("options")) {
            path.options = operation;
        }
        return path;
    }

    private static void defineItems(Oas20Parameter serializableParameter, List<String> allowableValues, Oas20Items items, Class<?> type) {
        serializableParameter.items = items;
        if (allowableValues != null && !allowableValues.isEmpty()) {
            if (String.class.equals(type)) {
                items.enum_ = allowableValues;
            } else {
                RestOpenApiReader.convertAndSetItemsEnum((ExtensibleNode)items, allowableValues, type);
            }
        } else if (Objects.equals(serializableParameter.type, "array")) {
            Oas20Items oas20Items = serializableParameter.createItems();
            oas20Items.type = type.getSimpleName().toLowerCase();
            serializableParameter.items = oas20Items;
        }
    }

    private static void defineSchemas(Oas30Parameter serializableParameter, List<String> allowableValues, Class<?> type) {
        if (allowableValues != null && !allowableValues.isEmpty()) {
            if (String.class.equals(type)) {
                ((Oas30Schema)serializableParameter.schema).enum_ = allowableValues;
            } else {
                RestOpenApiReader.convertAndSetItemsEnum((ExtensibleNode)serializableParameter.schema, allowableValues, type);
            }
        } else if (Objects.equals(((Oas30Schema)serializableParameter.schema).type, "array")) {
            Oas30Schema parameterSchema = (Oas30Schema)serializableParameter.schema;
            OasSchema itemsSchema = parameterSchema.createItemsSchema();
            if (Integer.class.equals(type)) {
                itemsSchema.type = "number";
                itemsSchema.format = "int32";
            } else if (Long.class.equals(type)) {
                itemsSchema.type = "number";
                itemsSchema.format = "int64";
            } else if (Float.class.equals(type)) {
                itemsSchema.type = "number";
                itemsSchema.format = "float";
            } else if (Double.class.equals(type)) {
                itemsSchema.type = "number";
                itemsSchema.format = "double";
            } else if (ByteArraySchema.class.equals(type)) {
                itemsSchema.type = "string";
                itemsSchema.format = "byte";
            } else if (BinarySchema.class.equals(type)) {
                itemsSchema.type = "string";
                itemsSchema.format = "binary";
            } else if (Date.class.equals(type)) {
                itemsSchema.type = "string";
                itemsSchema.format = "date";
            } else if (DateTimeSchema.class.equals(type)) {
                itemsSchema.type = "string";
                itemsSchema.format = "date-time";
            } else if (PasswordSchema.class.equals(type)) {
                itemsSchema.type = "string";
                itemsSchema.format = "password";
            } else {
                itemsSchema.type = "string";
            }
            parameterSchema.items = itemsSchema;
        }
    }

    private static void convertAndSetItemsEnum(ExtensibleNode items, List<String> allowableValues, Class<?> type) {
        try {
            MethodHandle valueOf = MethodHandles.publicLookup().findStatic(type, "valueOf", MethodType.methodType(type, String.class));
            MethodHandle setEnum = MethodHandles.publicLookup().bind(items, "setEnum", MethodType.methodType(Void.TYPE, List.class));
            List values = allowableValues.stream().map(v -> {
                try {
                    return valueOf.invoke((String)v);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IllegalStateException(e);
                }
            }).collect(Collectors.toList());
            setEnum.invoke(values);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    private void doParseResponseMessages(CamelContext camelContext, OasDocument openApi, VerbDefinition verb, OasOperation op, String produces) {
        if (op.responses == null) {
            op.responses = op.createResponses();
        }
        for (RestOperationResponseMsgDefinition msg : verb.getResponseMsgs()) {
            if (openApi instanceof Oas20Document) {
                this.doParseResponseOas20(camelContext, (Oas20Document)openApi, (Oas20Operation)op, msg);
                continue;
            }
            if (!(openApi instanceof Oas30Document)) continue;
            this.doParseResponseOas30(camelContext, (Oas30Document)openApi, (Oas30Operation)op, produces, msg);
        }
        if (op.responses == null || op.responses.getResponses().isEmpty()) {
            op.responses.addResponse("200", op.responses.createResponse("200"));
        }
    }

    private void doParseResponseOas30(CamelContext camelContext, Oas30Document openApi, Oas30Operation op, String produces, RestOperationResponseMsgDefinition msg) {
        Oas30Response response = null;
        String code = RestOpenApiReader.getValue(camelContext, msg.getCode());
        if (op.responses != null && op.responses.getResponses() != null) {
            response = (Oas30Response)op.responses.getResponse(code);
        }
        if (response == null) {
            response = (Oas30Response)op.responses.createResponse(code);
            op.responses.addResponse(code, (OasResponse)response);
        }
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)msg.getResponseModel()) && produces != null) {
            String[] parts = produces.split(",");
            for (String produce : parts) {
                Oas30MediaType contentType = response.createMediaType(produce);
                response.addMediaType(produce, contentType);
                Oas30Schema model = contentType.createSchema();
                contentType.schema = model = this.modelTypeAsProperty(RestOpenApiReader.getValue(camelContext, msg.getResponseModel()), (OasDocument)openApi, (OasSchema)model);
            }
        }
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)msg.getMessage())) {
            response.description = RestOpenApiReader.getValue(camelContext, msg.getMessage());
        }
        if (msg.getHeaders() != null) {
            for (RestOperationResponseHeaderDefinition header : msg.getHeaders()) {
                String name = RestOpenApiReader.getValue(camelContext, header.getName());
                String type = RestOpenApiReader.getValue(camelContext, header.getDataType());
                String format = RestOpenApiReader.getValue(camelContext, header.getDataFormat());
                if ("string".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type) || "boolean".equals(type)) {
                    this.setResponseHeaderOas30(camelContext, response, header, name, format, type);
                    continue;
                }
                if ("int".equals(type) || "integer".equals(type)) {
                    this.setResponseHeaderOas30(camelContext, response, header, name, format, "integer");
                    continue;
                }
                if (!"array".equals(type)) continue;
                Oas30Header ap = response.createHeader(name);
                if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)header.getDescription())) {
                    ap.description = RestOpenApiReader.getValue(camelContext, header.getDescription());
                }
                if (header.getArrayType() != null) {
                    String arrayType = RestOpenApiReader.getValue(camelContext, header.getArrayType());
                    if (arrayType.equalsIgnoreCase("string") || arrayType.equalsIgnoreCase("long") || arrayType.equalsIgnoreCase("float") || arrayType.equalsIgnoreCase("double") || arrayType.equalsIgnoreCase("boolean")) {
                        this.setHeaderSchemaOas30(ap, arrayType);
                    } else if (arrayType.equalsIgnoreCase("int") || arrayType.equalsIgnoreCase("integer")) {
                        this.setHeaderSchemaOas30(ap, "integer");
                    }
                }
                if (header.getExample() != null) {
                    Extension exampleExtension = ap.createExtension();
                    exampleExtension.name = "x-example";
                    exampleExtension.value = RestOpenApiReader.getValue(camelContext, header.getExample());
                    ap.getExtensions().add(exampleExtension);
                }
                response.addHeader(name, (OasHeader)ap);
            }
        }
        if (msg.getExamples() != null) {
            Extension exampleExtension = response.createExtension();
            exampleExtension.name = "x-examples";
            LinkedHashMap<String, String> examplesValue = new LinkedHashMap<String, String>();
            for (RestPropertyDefinition prop : msg.getExamples()) {
                examplesValue.put(RestOpenApiReader.getValue(camelContext, prop.getKey()), RestOpenApiReader.getValue(camelContext, prop.getValue()));
            }
            exampleExtension.value = examplesValue;
            response.addExtension(exampleExtension.name, exampleExtension);
        }
    }

    private void setHeaderSchemaOas30(Oas30Header ap, String arrayType) {
        Oas30Schema items = ap.createSchema();
        items.type = arrayType;
        ap.schema = items;
    }

    private void setResponseHeaderOas30(CamelContext camelContext, Oas30Response response, RestOperationResponseHeaderDefinition header, String name, String format, String type) {
        Oas30Schema schema;
        Oas30Header ip = response.createHeader(name);
        response.addHeader(name, (OasHeader)ip);
        ip.schema = schema = ip.createSchema();
        schema.type = type;
        if (format != null) {
            schema.format = format;
        }
        ip.description = RestOpenApiReader.getValue(camelContext, header.getDescription());
        if (!header.getAllowableValues().isEmpty()) {
            ArrayList<String> values = new ArrayList<String>();
            for (String text : header.getAllowableValues()) {
                values.add(RestOpenApiReader.getValue(camelContext, text));
            }
            schema.enum_ = values;
        }
        if (header.getExample() != null) {
            Extension exampleExtension = ip.createExtension();
            exampleExtension.name = "x-example";
            exampleExtension.value = RestOpenApiReader.getValue(camelContext, header.getExample());
            ip.getExtensions().add(exampleExtension);
        }
    }

    private void doParseResponseOas20(CamelContext camelContext, Oas20Document openApi, Oas20Operation op, RestOperationResponseMsgDefinition msg) {
        Oas20Response response = null;
        String code = RestOpenApiReader.getValue(camelContext, msg.getCode());
        if (op.responses != null && op.responses.getResponses() != null) {
            response = (Oas20Response)op.responses.getResponse(code);
        }
        if (response == null) {
            response = (Oas20Response)op.responses.createResponse(code);
            op.responses.addResponse(code, (OasResponse)response);
        }
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)msg.getResponseModel())) {
            Object model = response.createSchema();
            model = this.modelTypeAsProperty(RestOpenApiReader.getValue(camelContext, msg.getResponseModel()), (OasDocument)openApi, (OasSchema)model);
            response.schema = (Oas20Schema)model;
        }
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)msg.getMessage())) {
            response.description = RestOpenApiReader.getValue(camelContext, msg.getMessage());
        }
        if (msg.getHeaders() != null) {
            for (RestOperationResponseHeaderDefinition header : msg.getHeaders()) {
                String name = RestOpenApiReader.getValue(camelContext, header.getName());
                String type = RestOpenApiReader.getValue(camelContext, header.getDataType());
                String format = RestOpenApiReader.getValue(camelContext, header.getDataFormat());
                if (response.headers == null) {
                    response.headers = response.createHeaders();
                }
                if ("string".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type) || "boolean".equals(type)) {
                    this.setResponseHeaderOas20(camelContext, response, header, name, format, type);
                    continue;
                }
                if ("int".equals(type) || "integer".equals(type)) {
                    this.setResponseHeaderOas20(camelContext, response, header, name, format, "integer");
                    continue;
                }
                if (!"array".equals(type)) continue;
                Oas20Header ap = response.headers.createHeader(name);
                if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)header.getDescription())) {
                    ap.description = RestOpenApiReader.getValue(camelContext, header.getDescription());
                }
                if (header.getArrayType() != null) {
                    String arrayType = header.getArrayType();
                    if (arrayType.equalsIgnoreCase("string") || arrayType.equalsIgnoreCase("long") || arrayType.equalsIgnoreCase("float") || arrayType.equalsIgnoreCase("double") || arrayType.equalsIgnoreCase("boolean")) {
                        this.setHeaderSchemaOas20(ap, arrayType);
                    } else if (header.getArrayType().equalsIgnoreCase("int") || header.getArrayType().equalsIgnoreCase("integer")) {
                        this.setHeaderSchemaOas20(ap, "integer");
                    }
                }
                if (header.getExample() != null) {
                    Extension exampleExtension = ap.createExtension();
                    exampleExtension.name = "x-example";
                    exampleExtension.value = RestOpenApiReader.getValue(camelContext, header.getExample());
                    ap.getExtensions().add(exampleExtension);
                }
                response.headers.addHeader(name, ap);
            }
        }
        if (msg.getExamples() != null) {
            Extension exampleExtension = response.createExtension();
            exampleExtension.name = "examples";
            LinkedHashMap<String, String> examplesValue = new LinkedHashMap<String, String>();
            for (RestPropertyDefinition prop : msg.getExamples()) {
                examplesValue.put(RestOpenApiReader.getValue(camelContext, prop.getKey()), RestOpenApiReader.getValue(camelContext, prop.getValue()));
            }
            exampleExtension.value = examplesValue;
            response.addExtension(exampleExtension.name, exampleExtension);
        }
    }

    private void setHeaderSchemaOas20(Oas20Header ap, String arrayType) {
        Oas20Items items = ap.createItems();
        items.type = arrayType;
        ap.items = items;
    }

    private void setResponseHeaderOas20(CamelContext camelContext, Oas20Response response, RestOperationResponseHeaderDefinition header, String name, String format, String type) {
        Oas20Header ip = response.headers.createHeader(name);
        ip.type = type;
        if (format != null) {
            ip.format = format;
        }
        ip.description = RestOpenApiReader.getValue(camelContext, header.getDescription());
        if (!header.getAllowableValues().isEmpty()) {
            ArrayList<String> values = new ArrayList<String>();
            for (String text : header.getAllowableValues()) {
                values.add(RestOpenApiReader.getValue(camelContext, text));
            }
            ip.enum_ = values;
        }
        if (header.getExample() != null) {
            Extension exampleExtension = ip.createExtension();
            exampleExtension.name = "x-example";
            exampleExtension.value = RestOpenApiReader.getValue(camelContext, header.getExample());
            ip.getExtensions().add(exampleExtension);
        }
        response.headers.addHeader(name, ip);
    }

    private String modelTypeAsRef(String typeName, OasDocument openApi) {
        boolean array = typeName.endsWith("[]");
        if (array) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if (NO_REFERENCE_TYPE_NAMES.contains(typeName)) {
            return null;
        }
        return typeName;
    }

    private OasSchema modelTypeAsProperty(String typeName, OasDocument openApi, OasSchema prop) {
        String ref;
        boolean array = typeName.endsWith("[]");
        if (array) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if ((ref = this.modelTypeAsRef(typeName, openApi)) != null) {
            if (openApi instanceof Oas20Document) {
                prop.$ref = OAS20_SCHEMA_DEFINITION_PREFIX + ref;
            } else if (openApi instanceof Oas30Document) {
                prop.$ref = OAS30_SCHEMA_DEFINITION_PREFIX + ref;
            }
        } else if (array && ("byte".equals(typeName) || "java.lang.Byte".equals(typeName))) {
            prop.format = "byte";
            prop.type = "number";
            array = false;
        } else if ("string".equalsIgnoreCase(typeName) || "java.lang.String".equals(typeName)) {
            prop.format = "string";
            prop.type = "string";
        } else if ("int".equals(typeName) || "java.lang.Integer".equals(typeName)) {
            prop.format = "integer";
            prop.type = "number";
        } else if ("long".equals(typeName) || "java.lang.Long".equals(typeName)) {
            prop.format = "long";
            prop.type = "number";
        } else if ("float".equals(typeName) || "java.lang.Float".equals(typeName)) {
            prop.format = "float";
            prop.type = "number";
        } else if ("double".equals(typeName) || "java.lang.Double".equals(typeName)) {
            prop.format = "double";
            prop.type = "number";
        } else if ("boolean".equals(typeName) || "java.lang.Boolean".equals(typeName)) {
            prop.format = "boolean";
            prop.type = "number";
        } else if ("file".equals(typeName) || "java.io.File".equals(typeName)) {
            if (openApi instanceof Oas20Document) {
                prop.type = "file";
            } else if (openApi instanceof Oas30Document) {
                prop.type = "string";
                prop.format = "binary";
            }
        } else {
            prop.type = "string";
        }
        if (array) {
            OasSchema ret = prop.createItemsSchema();
            ret.$ref = prop.$ref;
            prop.$ref = null;
            prop.items = ret;
            prop.type = "array";
            return prop;
        }
        return prop;
    }

    private void appendModels(Class<?> clazz, OasDocument openApi) {
        RestModelConverters converters = new RestModelConverters();
        List<? extends OasSchema> models = converters.readClass(openApi, clazz);
        if (models == null) {
            return;
        }
        for (OasSchema oasSchema : models) {
            Oas20SchemaDefinition oldModel;
            boolean oldExt;
            if (openApi instanceof Oas20Document) {
                oldExt = false;
                if (((Oas20Document)openApi).definitions != null && ((Oas20Document)openApi).definitions.getDefinition(((Oas20SchemaDefinition)oasSchema).getName()) != null && (oldModel = ((Oas20Document)openApi).definitions.getDefinition(((Oas20SchemaDefinition)oasSchema).getName())).getExtensions() != null && !oldModel.getExtensions().isEmpty()) {
                    boolean bl = oldExt = oldModel.getExtension("x-className") != null;
                }
                if (oldExt) continue;
                ((Oas20Document)openApi).definitions.addDefinition(((Oas20SchemaDefinition)oasSchema).getName(), (Oas20SchemaDefinition)oasSchema);
                continue;
            }
            if (!(openApi instanceof Oas30Document)) continue;
            oldExt = false;
            if (((Oas30Document)openApi).components != null && ((Oas30Document)openApi).components.getSchemaDefinition(((Oas30SchemaDefinition)oasSchema).getName()) != null && (oldModel = ((Oas30Document)openApi).components.getSchemaDefinition(((Oas30SchemaDefinition)oasSchema).getName())).getExtensions() != null && !oldModel.getExtensions().isEmpty()) {
                boolean bl = oldExt = oldModel.getExtension("x-className") != null;
            }
            if (oldExt) continue;
            ((Oas30Document)openApi).components.addSchemaDefinition(((Oas30SchemaDefinition)oasSchema).getName(), (Oas30SchemaDefinition)oasSchema);
        }
    }

    private void shortenClassNames(OasDocument document) {
        if (document instanceof Oas30Document) {
            Oas30Document oas30Document = (Oas30Document)document;
            if (oas30Document.components == null || oas30Document.components.schemas == null) {
                return;
            }
        } else {
            Oas20Document oas20Document = (Oas20Document)document;
            if (oas20Document.definitions == null || oas20Document.definitions.getDefinitions() == null) {
                return;
            }
        }
        final HashMap names = new HashMap();
        Stream<Object> schemaStream = document instanceof Oas30Document ? ((Oas30Document)document).components.schemas.keySet().stream() : ((Oas20Document)document).definitions.getDefinitions().stream().map(Oas20SchemaDefinition::getName);
        schemaStream.forEach(key -> {
            String s = key.replaceAll("[^a-zA-Z0-9.-_]", "_");
            String shortName = s.substring(s.lastIndexOf(46) + 1);
            names.put(key, names.containsValue(shortName) ? s : shortName);
        });
        if (document instanceof Oas30Document) {
            Library.visitTree((Node)document, (IVisitor)new Oas30AllNodeVisitor(){

                protected void visitNode(Node node) {
                    if (node instanceof Oas30SchemaDefinition) {
                        Oas30SchemaDefinition definition = (Oas30SchemaDefinition)node;
                        definition.rename(RestOpenApiReader.this.fixSchemaReference(definition.getName(), names, RestOpenApiReader.OAS30_SCHEMA_DEFINITION_PREFIX));
                    } else if (node instanceof Oas30Schema) {
                        Oas30Schema schema = (Oas30Schema)node;
                        String ref = schema.$ref;
                        if (ref != null) {
                            schema.$ref = RestOpenApiReader.OAS30_SCHEMA_DEFINITION_PREFIX + RestOpenApiReader.this.fixSchemaReference(ref, names, RestOpenApiReader.OAS30_SCHEMA_DEFINITION_PREFIX);
                        }
                    }
                }
            }, (TraverserDirection)TraverserDirection.down);
        } else {
            Library.visitTree((Node)document, (IVisitor)new Oas20AllNodeVisitor(){

                protected void visitNode(Node node) {
                    if (node instanceof Oas20SchemaDefinition) {
                        Oas20SchemaDefinition definition = (Oas20SchemaDefinition)node;
                        definition.rename(RestOpenApiReader.this.fixSchemaReference(definition.getName(), names, RestOpenApiReader.OAS20_SCHEMA_DEFINITION_PREFIX));
                    } else if (node instanceof Oas20Schema) {
                        Oas20Schema schema = (Oas20Schema)node;
                        String ref = schema.$ref;
                        if (ref != null) {
                            schema.$ref = RestOpenApiReader.OAS20_SCHEMA_DEFINITION_PREFIX + RestOpenApiReader.this.fixSchemaReference(ref, names, RestOpenApiReader.OAS20_SCHEMA_DEFINITION_PREFIX);
                        }
                    }
                }
            }, (TraverserDirection)TraverserDirection.down);
        }
    }

    private String fixSchemaReference(String ref, Map<String, String> names, String prefix) {
        String name;
        if (ref.startsWith(prefix)) {
            ref = ref.substring(prefix.length());
        }
        return (name = names.get(ref)) == null ? ref : name;
    }

    private String inferOauthFlow(RestSecurityOAuth2 rs) {
        String flow;
        if (rs.getAuthorizationUrl() != null && rs.getTokenUrl() != null) {
            flow = "authorizationCode";
        } else if (rs.getTokenUrl() == null && rs.getAuthorizationUrl() != null) {
            flow = "implicit";
        } else {
            throw new IllegalStateException("Error inferring OAuth flow");
        }
        return flow;
    }

    private static class VerbOrdering
    implements Comparator<VerbDefinition> {
        private final CamelContext camelContext;

        public VerbOrdering(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        @Override
        public int compare(VerbDefinition a, VerbDefinition b) {
            int num;
            String u1 = "";
            if (a.getUri() != null) {
                u1 = RestOpenApiReader.getValue(this.camelContext, a.getUri()).replace("{", "_");
            }
            String u2 = "";
            if (b.getUri() != null) {
                u2 = RestOpenApiReader.getValue(this.camelContext, b.getUri()).replace("{", "_");
            }
            if ((num = u1.compareTo(u2)) == 0) {
                num = a.asVerb().compareTo(b.asVerb());
            }
            return num;
        }
    }
}

