/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.common.AuthorizationCodeOAuthFlow;
import io.apicurio.datamodels.core.models.common.ImplicitOAuthFlow;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.models.OasSecurityRequirement;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Header;
import io.apicurio.datamodels.openapi.v2.models.Oas20Items;
import io.apicurio.datamodels.openapi.v2.models.Oas20Operation;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20Response;
import io.apicurio.datamodels.openapi.v2.models.Oas20Schema;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Header;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;
import io.apicurio.datamodels.openapi.v3.models.Oas30Operation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import io.apicurio.datamodels.openapi.v3.models.Oas30SchemaDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityScheme;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestOperationParamDefinition;
import org.apache.camel.model.rest.RestOperationResponseHeaderDefinition;
import org.apache.camel.model.rest.RestOperationResponseMsgDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.RestPropertyDefinition;
import org.apache.camel.model.rest.RestSecuritiesDefinition;
import org.apache.camel.model.rest.RestSecurityApiKey;
import org.apache.camel.model.rest.RestSecurityBasicAuth;
import org.apache.camel.model.rest.RestSecurityDefinition;
import org.apache.camel.model.rest.RestSecurityOAuth2;
import org.apache.camel.model.rest.SecurityDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.openapi.BeanConfig;
import org.apache.camel.openapi.OpenApiHelper;
import org.apache.camel.openapi.RestModelConverters;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.FileUtil;

public class RestOpenApiReader {
    public OasDocument read(List<RestDefinition> rests, String route, BeanConfig config, String camelContextId, ClassResolver classResolver) throws ClassNotFoundException {
        Object openApi = null;
        openApi = config.isOpenApi3() ? new Oas30Document() : new Oas20Document();
        for (RestDefinition rest : rests) {
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)route) && !route.equals("/") && !rest.getPath().equals(route)) continue;
            this.parse((OasDocument)openApi, rest, camelContextId, classResolver);
        }
        openApi = config.configure((OasDocument)openApi);
        return openApi;
    }

    private void parse(OasDocument openApi, RestDefinition rest, String camelContextId, ClassResolver classResolver) throws ClassNotFoundException {
        String pathAsTag;
        ArrayList<VerbDefinition> verbs = new ArrayList<VerbDefinition>(rest.getVerbs());
        Collections.sort(verbs, new VerbOrdering());
        String string = pathAsTag = rest.getTag() != null ? rest.getTag() : FileUtil.stripLeadingSeparator((String)rest.getPath());
        if (openApi instanceof Oas20Document) {
            this.parseOas20((Oas20Document)openApi, rest, pathAsTag);
        } else if (openApi instanceof Oas30Document) {
            this.parseOas30((Oas30Document)openApi, rest, pathAsTag);
        }
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (VerbDefinition verb : verbs) {
            String apiDocs = verb.getApiDocs() != null ? verb.getApiDocs() : rest.getApiDocs();
            if (apiDocs != null && !Boolean.parseBoolean(apiDocs)) continue;
            String type = verb.getType();
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)type)) {
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)(type = verb.getOutType()))) {
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
            if (verb.getResponseMsgs() == null) continue;
            for (RestOperationResponseMsgDefinition def : verb.getResponseMsgs()) {
                type = def.getResponseModel();
                if (!org.apache.camel.util.ObjectHelper.isNotEmpty((Object)type)) continue;
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
        }
        for (String type : types) {
            Class clazz = classResolver.resolveMandatoryClass(type);
            this.appendModels(clazz, openApi);
        }
        this.doParseVerbs(openApi, rest, camelContextId, verbs, pathAsTag);
    }

    private void parseOas30(Oas30Document openApi, RestDefinition rest, String pathAsTag) {
        RestSecuritiesDefinition sd;
        String summary = rest.getDescriptionText();
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)pathAsTag)) {
            openApi.addTag(pathAsTag, summary);
        }
        if ((sd = rest.getSecurityDefinitions()) != null && sd.getSecurityDefinitions().size() != 0 && openApi.components == null) {
            openApi.components = openApi.createComponents();
        }
        if (sd != null) {
            for (RestSecurityDefinition def : sd.getSecurityDefinitions()) {
                Oas30SecurityScheme auth;
                RestSecurityApiKey rs;
                if (def instanceof RestSecurityBasicAuth) {
                    Oas30SecurityScheme auth2 = openApi.components.createSecurityScheme(def.getKey());
                    auth2.type = "http";
                    auth2.scheme = "basic";
                    auth2.description = def.getDescription();
                    openApi.components.addSecurityScheme("BasicAuth", auth2);
                    continue;
                }
                if (def instanceof RestSecurityApiKey) {
                    rs = (RestSecurityApiKey)def;
                    auth = openApi.components.createSecurityScheme(def.getKey());
                    auth.type = "apiKey";
                    auth.description = rs.getDescription();
                    auth.name = rs.getName();
                    auth.in = rs.getInHeader() != null && Boolean.parseBoolean(rs.getInHeader()) ? "header" : "query";
                    openApi.components.addSecurityScheme(def.getKey(), auth);
                    continue;
                }
                if (!(def instanceof RestSecurityOAuth2)) continue;
                rs = (RestSecurityOAuth2)def;
                auth = openApi.components.createSecurityScheme(def.getKey());
                auth.type = "oauth2";
                auth.description = rs.getDescription();
                String flow = rs.getFlow();
                if (flow == null) {
                    if (rs.getAuthorizationUrl() != null && rs.getTokenUrl() != null) {
                        flow = "accessCode";
                    } else if (rs.getTokenUrl() == null && rs.getAuthorizationUrl() != null) {
                        flow = "implicit";
                    }
                }
                AuthorizationCodeOAuthFlow oauthFlow = null;
                if (auth.flows == null) {
                    auth.flows = auth.createOAuthFlows();
                }
                if (flow.equals("accessCode")) {
                    auth.flows.authorizationCode = oauthFlow = auth.flows.createAuthorizationCodeOAuthFlow();
                } else if (flow.equals("implicit")) {
                    oauthFlow = auth.flows.createImplicitOAuthFlow();
                    auth.flows.implicit = (ImplicitOAuthFlow)oauthFlow;
                }
                oauthFlow.authorizationUrl = rs.getAuthorizationUrl();
                oauthFlow.tokenUrl = rs.getTokenUrl();
                for (RestPropertyDefinition scope : rs.getScopes()) {
                    oauthFlow.addScope(scope.getKey(), scope.getValue());
                }
                openApi.components.addSecurityScheme(def.getKey(), auth);
            }
        }
    }

    private void parseOas20(Oas20Document openApi, RestDefinition rest, String pathAsTag) {
        RestSecuritiesDefinition sd;
        String summary = rest.getDescriptionText();
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)pathAsTag)) {
            openApi.addTag(pathAsTag, summary);
        }
        if ((sd = rest.getSecurityDefinitions()) != null && sd.getSecurityDefinitions().size() != 0 && openApi.securityDefinitions == null) {
            openApi.securityDefinitions = openApi.createSecurityDefinitions();
        }
        if (sd != null) {
            for (RestSecurityDefinition def : sd.getSecurityDefinitions()) {
                Oas20SecurityScheme auth;
                RestSecurityApiKey rs;
                if (def instanceof RestSecurityBasicAuth) {
                    Oas20SecurityScheme auth2 = openApi.securityDefinitions.createSecurityScheme(def.getKey());
                    auth2.type = "basicAuth";
                    auth2.description = def.getDescription();
                    openApi.securityDefinitions.addSecurityScheme("BasicAuth", auth2);
                    continue;
                }
                if (def instanceof RestSecurityApiKey) {
                    rs = (RestSecurityApiKey)def;
                    auth = openApi.securityDefinitions.createSecurityScheme(def.getKey());
                    auth.type = "apiKey";
                    auth.description = rs.getDescription();
                    auth.name = rs.getName();
                    auth.in = rs.getInHeader() != null && Boolean.parseBoolean(rs.getInHeader()) ? "header" : "query";
                    openApi.securityDefinitions.addSecurityScheme(def.getKey(), auth);
                    continue;
                }
                if (!(def instanceof RestSecurityOAuth2)) continue;
                rs = (RestSecurityOAuth2)def;
                auth = openApi.securityDefinitions.createSecurityScheme(def.getKey());
                auth.type = "oauth2";
                auth.description = rs.getDescription();
                String flow = rs.getFlow();
                if (flow == null) {
                    if (rs.getAuthorizationUrl() != null && rs.getTokenUrl() != null) {
                        flow = "accessCode";
                    } else if (rs.getTokenUrl() == null && rs.getAuthorizationUrl() != null) {
                        flow = "implicit";
                    }
                }
                auth.flow = flow;
                auth.authorizationUrl = rs.getAuthorizationUrl();
                auth.tokenUrl = rs.getTokenUrl();
                if (rs.getScopes().size() != 0 && auth.scopes == null) {
                    auth.scopes = auth.createScopes();
                }
                for (RestPropertyDefinition scope : rs.getScopes()) {
                    auth.scopes.addScope(scope.getKey(), scope.getValue());
                }
                if (openApi.securityDefinitions == null) {
                    openApi.securityDefinitions = openApi.createSecurityDefinitions();
                }
                openApi.securityDefinitions.addSecurityScheme(def.getKey(), auth);
            }
        }
    }

    private void doParseVerbs(OasDocument openApi, RestDefinition rest, String camelContextId, List<VerbDefinition> verbs, String pathAsTag) {
        String basePath = rest.getPath();
        for (VerbDefinition verb : verbs) {
            String produces;
            OasPathItem path;
            String apiDocs = verb.getApiDocs() != null ? verb.getApiDocs() : rest.getApiDocs();
            if (apiDocs != null && !Boolean.parseBoolean(apiDocs)) continue;
            String method = verb.asVerb().toLowerCase(Locale.US);
            String opPath = OpenApiHelper.buildUrl(basePath, verb.getUri());
            if (openApi.paths == null) {
                openApi.paths = openApi.createPaths();
            }
            if ((path = openApi.paths.getPathItem(opPath)) == null) {
                path = openApi.paths.createPathItem(opPath);
            }
            OasOperation op = path.createOperation(method);
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)pathAsTag)) {
                if (op.tags == null) {
                    op.tags = new ArrayList();
                }
                op.tags.add(pathAsTag);
            }
            String routeId = verb.getRouteId();
            String operationId = verb.getId() != null ? verb.getId() : (rest.getId() != null ? rest.getId() : routeId);
            op.operationId = operationId;
            Extension extension = op.createExtension();
            extension.name = "x-camelContextId";
            extension.value = camelContextId;
            op.addExtension(extension.name, extension);
            extension = op.createExtension();
            extension.name = "x-routeId";
            extension.value = routeId;
            op.addExtension(extension.name, extension);
            path = this.setPathOperation(path, op, method);
            String consumes = verb.getConsumes() != null ? verb.getConsumes() : rest.getConsumes();
            String string = produces = verb.getProduces() != null ? verb.getProduces() : rest.getProduces();
            if (openApi instanceof Oas20Document) {
                this.doParseVerbOas20((Oas20Document)openApi, verb, (Oas20Operation)op, consumes, produces);
            } else if (openApi instanceof Oas30Document) {
                this.doParseVerbOas30((Oas30Document)openApi, verb, (Oas30Operation)op, consumes, produces);
            }
            this.doParseResponseMessages(openApi, verb, op, produces);
            openApi.paths.addPathItem(opPath, path);
        }
    }

    private void doParseVerbOas30(Oas30Document openApi, VerbDefinition verb, Oas30Operation op, String consumes, String produces) {
        if (verb.getDescriptionText() != null) {
            op.summary = verb.getDescriptionText();
        }
        for (SecurityDefinition sd : verb.getSecurity()) {
            ArrayList<String> scopes = new ArrayList<String>();
            if (sd.getScopes() != null) {
                for (String scope : ObjectHelper.createIterable((String)sd.getScopes())) {
                    scopes.add(scope);
                }
            }
            OasSecurityRequirement securityRequirement = op.createSecurityRequirement();
            securityRequirement.addSecurityRequirementItem(sd.getKey(), scopes);
            op.addSecurityRequirement((SecurityRequirement)securityRequirement);
        }
        for (RestOperationParamDefinition param : verb.getParams()) {
            int hasAllowableValues;
            OasParameter parameter = null;
            if (param.getType().equals((Object)RestParamType.body)) {
                parameter = op.createParameter();
                parameter.in = "body";
            } else if (param.getType().equals((Object)RestParamType.formData)) {
                parameter = op.createParameter();
                parameter.in = "formData";
            } else if (param.getType().equals((Object)RestParamType.header)) {
                parameter = op.createParameter();
                parameter.in = "header";
            } else if (param.getType().equals((Object)RestParamType.path)) {
                parameter = op.createParameter();
                parameter.in = "path";
            } else if (param.getType().equals((Object)RestParamType.query)) {
                parameter = op.createParameter();
                parameter.in = "query";
            }
            if (parameter == null) continue;
            parameter.name = param.getName();
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)param.getDescription())) {
                parameter.description = param.getDescription();
            }
            parameter.required = param.getRequired();
            if (!parameter.in.equals("body")) {
                Oas30Parameter parameter30 = (Oas30Parameter)parameter;
                Oas30Schema oas30Schema = null;
                boolean isArray = param.getDataType().equalsIgnoreCase("array");
                List allowableValues = param.getAllowableValues();
                int n = hasAllowableValues = allowableValues != null && !allowableValues.isEmpty() ? 1 : 0;
                if (param.getDataType() != null) {
                    parameter30.schema = parameter30.createSchema();
                    oas30Schema = (Oas30Schema)parameter30.schema;
                    oas30Schema.type = param.getDataType();
                    if (param.getDataFormat() != null) {
                        oas30Schema.format = param.getDataFormat();
                    }
                    if (isArray && param.getArrayType() != null) {
                        if (param.getArrayType().equalsIgnoreCase("string")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, String.class);
                        }
                        if (param.getArrayType().equalsIgnoreCase("int") || param.getArrayType().equalsIgnoreCase("integer")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, Integer.class);
                        }
                        if (param.getArrayType().equalsIgnoreCase("long")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, Long.class);
                        }
                        if (param.getArrayType().equalsIgnoreCase("float")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, Float.class);
                        }
                        if (param.getArrayType().equalsIgnoreCase("double")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, Double.class);
                        }
                        if (param.getArrayType().equalsIgnoreCase("boolean")) {
                            RestOpenApiReader.defineSchemas(parameter30, allowableValues, Boolean.class);
                        }
                    }
                }
                if (param.getCollectionFormat() != null) {
                    parameter30.style = param.getCollectionFormat().name();
                }
                if (hasAllowableValues != 0 && !isArray) {
                    oas30Schema.enum_ = allowableValues;
                }
                if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)param.getDefaultValue())) {
                    oas30Schema.default_ = param.getDefaultValue();
                }
                if (param.getExamples() != null && param.getExamples().size() >= 1) {
                    boolean emptyKey;
                    Extension exampleExtension = parameter30.createExtension();
                    boolean bl = emptyKey = ((RestPropertyDefinition)param.getExamples().get(0)).getKey().length() == 0;
                    if (emptyKey) {
                        exampleExtension.name = "x-example";
                        exampleExtension.value = ((RestPropertyDefinition)param.getExamples().get(0)).getValue();
                        parameter30.addExtension("x-example", exampleExtension);
                    } else {
                        HashMap<String, String> exampleValue = new HashMap<String, String>();
                        exampleValue.put(((RestPropertyDefinition)param.getExamples().get(0)).getKey(), ((RestPropertyDefinition)param.getExamples().get(0)).getValue());
                        exampleExtension.name = "x-examples";
                        exampleExtension.value = exampleValue;
                        parameter30.addExtension("x-examples", exampleExtension);
                    }
                }
            }
            if (parameter.in.equals("body")) {
                Oas30Schema model;
                String type;
                Oas30Parameter bp = (Oas30Parameter)parameter;
                String string = type = param.getDataType() != null ? param.getDataType() : verb.getType();
                if (type != null) {
                    if (type.endsWith("[]")) {
                        type = type.substring(0, type.length() - 2);
                        Oas30Schema arrayModel = (Oas30Schema)bp.createSchema();
                        arrayModel = this.modelTypeAsProperty(type, (OasDocument)openApi, (OasSchema)arrayModel);
                        bp.schema = arrayModel;
                    } else {
                        String ref = this.modelTypeAsRef(type, (OasDocument)openApi);
                        if (ref != null) {
                            Oas30Schema refModel = (Oas30Schema)bp.createSchema();
                            refModel.$ref = "#/components/schemas/" + ref;
                            bp.schema = refModel;
                        } else {
                            model = (Oas30Schema)bp.createSchema();
                            model = this.modelTypeAsProperty(type, (OasDocument)openApi, (OasSchema)model);
                            bp.schema = model;
                        }
                    }
                }
                if (consumes != null) {
                    Oas30Schema parts = consumes.split(",");
                    if (op.requestBody == null) {
                        op.requestBody = op.createRequestBody();
                        op.requestBody.required = param.getRequired();
                        op.requestBody.description = param.getDescription();
                    }
                    model = parts;
                    hasAllowableValues = ((String[])model).length;
                    for (int i = 0; i < hasAllowableValues; ++i) {
                        Oas30Schema part = model[i];
                        Oas30MediaType mediaType = op.requestBody.createMediaType((String)part);
                        mediaType.schema = mediaType.createSchema();
                        mediaType.schema.$ref = bp.schema.$ref;
                        op.requestBody.addMediaType((String)part, mediaType);
                    }
                }
                if (param.getExamples() != null) {
                    boolean emptyKey;
                    Extension exampleExtension = op.requestBody.createExtension();
                    boolean bl = emptyKey = ((RestPropertyDefinition)param.getExamples().get(0)).getKey().length() == 0;
                    if (emptyKey) {
                        exampleExtension.name = "x-example";
                        exampleExtension.value = ((RestPropertyDefinition)param.getExamples().get(0)).getValue();
                        op.requestBody.addExtension("x-example", exampleExtension);
                    } else {
                        HashMap<String, String> exampleValue = new HashMap<String, String>();
                        exampleValue.put(((RestPropertyDefinition)param.getExamples().get(0)).getKey(), ((RestPropertyDefinition)param.getExamples().get(0)).getValue());
                        exampleExtension.name = "x-examples";
                        exampleExtension.value = exampleValue;
                        op.requestBody.addExtension("x-examples", exampleExtension);
                    }
                }
                parameter = null;
            }
            op.addParameter(parameter);
        }
        if (op.getParameters() != null && op.getParameters().isEmpty()) {
            op.parameters.clear();
        }
        if (verb.getOutType() != null) {
            if (op.responses == null) {
                op.responses = op.createResponses();
            }
            Oas30Response response = (Oas30Response)op.responses.createResponse("200");
            String[] parts = null;
            if (produces != null) {
                for (String produce : parts = produces.split(",")) {
                    Oas30MediaType contentType = response.createMediaType(produce);
                    response.addMediaType(produce, contentType);
                    Oas30Schema model = contentType.createSchema();
                    contentType.schema = model = this.modelTypeAsProperty(verb.getOutType(), (OasDocument)openApi, (OasSchema)model);
                    response.description = "Output type";
                    op.responses.addResponse("200", (OasResponse)response);
                }
            }
        }
    }

    private void doParseVerbOas20(Oas20Document openApi, VerbDefinition verb, Oas20Operation op, String consumes, String produces) {
        Object parts;
        if (consumes != null) {
            parts = consumes.split(",");
            if (op.consumes == null) {
                op.consumes = new ArrayList();
            }
            for (String part : parts) {
                op.consumes.add(part);
            }
        }
        if (produces != null) {
            parts = produces.split(",");
            if (op.produces == null) {
                op.produces = new ArrayList();
            }
            for (String part : parts) {
                op.produces.add(part);
            }
        }
        if (verb.getDescriptionText() != null) {
            op.summary = verb.getDescriptionText();
        }
        for (SecurityDefinition sd : verb.getSecurity()) {
            ArrayList<String> scopes = new ArrayList<String>();
            if (sd.getScopes() != null) {
                for (String scope : ObjectHelper.createIterable((String)sd.getScopes())) {
                    scopes.add(scope);
                }
            }
            OasSecurityRequirement securityRequirement = op.createSecurityRequirement();
            securityRequirement.addSecurityRequirementItem(sd.getKey(), scopes);
            op.addSecurityRequirement((SecurityRequirement)securityRequirement);
        }
        for (RestOperationParamDefinition param : verb.getParams()) {
            OasParameter parameter = null;
            if (param.getType().equals((Object)RestParamType.body)) {
                parameter = op.createParameter();
                parameter.in = "body";
            } else if (param.getType().equals((Object)RestParamType.formData)) {
                parameter = op.createParameter();
                parameter.in = "formData";
            } else if (param.getType().equals((Object)RestParamType.header)) {
                parameter = op.createParameter();
                parameter.in = "header";
            } else if (param.getType().equals((Object)RestParamType.path)) {
                parameter = op.createParameter();
                parameter.in = "path";
            } else if (param.getType().equals((Object)RestParamType.query)) {
                parameter = op.createParameter();
                parameter.in = "query";
            }
            if (parameter == null) continue;
            parameter.name = param.getName();
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)param.getDescription())) {
                parameter.description = param.getDescription();
            }
            parameter.required = param.getRequired();
            if (!parameter.in.equals("body")) {
                boolean hasAllowableValues;
                Oas20Parameter serializableParameter = (Oas20Parameter)parameter;
                boolean isArray = param.getDataType().equalsIgnoreCase("array");
                List allowableValues = param.getAllowableValues();
                boolean bl = hasAllowableValues = allowableValues != null && !allowableValues.isEmpty();
                if (param.getDataType() != null) {
                    serializableParameter.type = param.getDataType();
                    if (param.getDataFormat() != null) {
                        serializableParameter.format = param.getDataFormat();
                    }
                    if (isArray && param.getArrayType() != null) {
                        if (param.getArrayType().equalsIgnoreCase("string")) {
                            RestOpenApiReader.defineItems(serializableParameter, allowableValues, new Oas20Items(), String.class);
                        }
                        if (param.getArrayType().equalsIgnoreCase("int") || param.getArrayType().equalsIgnoreCase("integer")) {
                            RestOpenApiReader.defineItems(serializableParameter, allowableValues, new Oas20Items(), Integer.class);
                        }
                        if (param.getArrayType().equalsIgnoreCase("long")) {
                            RestOpenApiReader.defineItems(serializableParameter, allowableValues, new Oas20Items(), Long.class);
                        }
                        if (param.getArrayType().equalsIgnoreCase("float")) {
                            RestOpenApiReader.defineItems(serializableParameter, allowableValues, new Oas20Items(), Float.class);
                        }
                        if (param.getArrayType().equalsIgnoreCase("double")) {
                            RestOpenApiReader.defineItems(serializableParameter, allowableValues, new Oas20Items(), Double.class);
                        }
                        if (param.getArrayType().equalsIgnoreCase("boolean")) {
                            RestOpenApiReader.defineItems(serializableParameter, allowableValues, new Oas20Items(), Boolean.class);
                        }
                    }
                }
                if (param.getCollectionFormat() != null) {
                    serializableParameter.collectionFormat = param.getCollectionFormat().name();
                }
                if (hasAllowableValues && !isArray) {
                    serializableParameter.enum_ = allowableValues;
                }
                if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)param.getDefaultValue())) {
                    serializableParameter.default_ = param.getDefaultValue();
                }
                if (param.getExamples() != null && param.getExamples().size() >= 1) {
                    boolean emptyKey;
                    Extension exampleExtension = serializableParameter.createExtension();
                    boolean bl2 = emptyKey = ((RestPropertyDefinition)param.getExamples().get(0)).getKey().length() == 0;
                    if (emptyKey) {
                        exampleExtension.name = "x-example";
                        exampleExtension.value = ((RestPropertyDefinition)param.getExamples().get(0)).getValue();
                        serializableParameter.addExtension("x-example", exampleExtension);
                    } else {
                        HashMap<String, String> exampleValue = new HashMap<String, String>();
                        exampleValue.put(((RestPropertyDefinition)param.getExamples().get(0)).getKey(), ((RestPropertyDefinition)param.getExamples().get(0)).getValue());
                        exampleExtension.name = "x-examples";
                        exampleExtension.value = exampleValue;
                        serializableParameter.addExtension("x-examples", exampleExtension);
                    }
                }
            }
            if (parameter.in.equals("body")) {
                String type;
                Oas20Parameter bp = (Oas20Parameter)parameter;
                String string = type = param.getDataType() != null ? param.getDataType() : verb.getType();
                if (type != null) {
                    if (type.endsWith("[]")) {
                        type = type.substring(0, type.length() - 2);
                        Oas20Schema arrayModel = (Oas20Schema)bp.createSchema();
                        arrayModel = this.modelTypeAsProperty(type, (OasDocument)openApi, (OasSchema)arrayModel);
                        bp.schema = arrayModel;
                    } else {
                        String ref = this.modelTypeAsRef(type, (OasDocument)openApi);
                        if (ref != null) {
                            Oas20Schema refModel = (Oas20Schema)bp.createSchema();
                            refModel.$ref = "#/definitions/" + ref;
                            bp.schema = refModel;
                        } else {
                            Oas20Schema model = (Oas20Schema)bp.createSchema();
                            model = this.modelTypeAsProperty(type, (OasDocument)openApi, (OasSchema)model);
                            bp.schema = model;
                        }
                    }
                }
                if (param.getExamples() != null) {
                    boolean emptyKey;
                    Extension exampleExtension = bp.createExtension();
                    boolean bl = emptyKey = ((RestPropertyDefinition)param.getExamples().get(0)).getKey().length() == 0;
                    if (emptyKey) {
                        exampleExtension.name = "x-example";
                        exampleExtension.value = ((RestPropertyDefinition)param.getExamples().get(0)).getValue();
                        bp.addExtension("x-example", exampleExtension);
                    } else {
                        HashMap<String, String> exampleValue = new HashMap<String, String>();
                        exampleValue.put(((RestPropertyDefinition)param.getExamples().get(0)).getKey(), ((RestPropertyDefinition)param.getExamples().get(0)).getValue());
                        exampleExtension.name = "x-examples";
                        exampleExtension.value = exampleValue;
                        bp.addExtension("x-examples", exampleExtension);
                    }
                }
            }
            op.addParameter(parameter);
        }
        if (op.getParameters() != null && op.getParameters().isEmpty()) {
            op.parameters.clear();
        }
        if (verb.getOutType() != null) {
            if (op.responses == null) {
                op.responses = op.createResponses();
            }
            Oas20Response response = (Oas20Response)op.responses.createResponse("200");
            Oas20Schema model = response.createSchema();
            response.schema = model = this.modelTypeAsProperty(verb.getOutType(), (OasDocument)openApi, (OasSchema)model);
            response.description = "Output type";
            op.responses.addResponse("200", (OasResponse)response);
        }
    }

    private OasPathItem setPathOperation(OasPathItem path, OasOperation operation, String method) {
        if (method.equals("post")) {
            path.post = operation;
        } else if (method.equals("get")) {
            path.get = operation;
        } else if (method.equals("put")) {
            path.put = operation;
        } else if (method.equals("patch")) {
            path.patch = operation;
        } else if (method.equals("delete")) {
            path.delete = operation;
        } else if (method.equals("head")) {
            path.head = operation;
        } else if (method.equals("options")) {
            path.options = operation;
        }
        return path;
    }

    private static void defineItems(Oas20Parameter serializableParameter, List<String> allowableValues, Oas20Items items, Class<?> type) {
        serializableParameter.items = items;
        if (allowableValues != null && !allowableValues.isEmpty()) {
            if (String.class.equals(type)) {
                items.enum_ = allowableValues;
            } else {
                RestOpenApiReader.convertAndSetItemsEnum((ExtensibleNode)items, allowableValues, type);
            }
        }
    }

    private static void defineSchemas(Oas30Parameter serializableParameter, List<String> allowableValues, Class<?> type) {
        if (allowableValues != null && !allowableValues.isEmpty()) {
            if (String.class.equals(type)) {
                ((Oas30Schema)serializableParameter.schema).enum_ = allowableValues;
            } else {
                RestOpenApiReader.convertAndSetItemsEnum((ExtensibleNode)serializableParameter.schema, allowableValues, type);
            }
        }
    }

    private static void convertAndSetItemsEnum(ExtensibleNode items, List<String> allowableValues, Class<?> type) {
        try {
            MethodHandle valueOf = MethodHandles.publicLookup().findStatic(type, "valueOf", MethodType.methodType(type, String.class));
            MethodHandle setEnum = MethodHandles.publicLookup().bind(items, "setEnum", MethodType.methodType(Void.TYPE, List.class));
            List values = allowableValues.stream().map(v -> {
                try {
                    return valueOf.invoke((String)v);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IllegalStateException(e);
                }
            }).collect(Collectors.toList());
            setEnum.invoke(values);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    private void doParseResponseMessages(OasDocument openApi, VerbDefinition verb, OasOperation op, String produces) {
        if (op.responses == null) {
            op.responses = op.createResponses();
        }
        for (RestOperationResponseMsgDefinition msg : verb.getResponseMsgs()) {
            if (openApi instanceof Oas20Document) {
                this.doParseResponseOas20((Oas20Document)openApi, (Oas20Operation)op, msg);
                continue;
            }
            if (!(openApi instanceof Oas30Document)) continue;
            this.doParseResponseOas30((Oas30Document)openApi, (Oas30Operation)op, produces, msg);
        }
        if (op.responses == null || op.responses.getResponses().isEmpty()) {
            op.responses.addResponse("200", op.responses.createResponse("200"));
        }
    }

    private void doParseResponseOas30(Oas30Document openApi, Oas30Operation op, String produces, RestOperationResponseMsgDefinition msg) {
        Oas30Response response = null;
        if (op.responses != null && op.responses.getResponses() != null) {
            response = (Oas30Response)op.responses.getResponse(msg.getCode());
        }
        if (response == null) {
            response = (Oas30Response)op.responses.createResponse(msg.getCode());
            op.responses.addResponse(msg.getCode(), (OasResponse)response);
        }
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)msg.getResponseModel())) {
            Object parts = null;
            if (produces != null) {
                parts = produces.split(",");
                for (String produce : parts) {
                    Oas30MediaType contentType = response.createMediaType(produce);
                    response.addMediaType(produce, contentType);
                    Oas30Schema model = contentType.createSchema();
                    contentType.schema = model = this.modelTypeAsProperty(msg.getResponseModel(), (OasDocument)openApi, (OasSchema)model);
                }
            }
        }
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)msg.getMessage())) {
            response.description = msg.getMessage();
        }
        if (msg.getHeaders() != null) {
            for (RestOperationResponseHeaderDefinition header : msg.getHeaders()) {
                String name = header.getName();
                String type = header.getDataType();
                String format = header.getDataFormat();
                if ("string".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type) || "boolean".equals(type)) {
                    this.setResponseHeaderOas30(response, header, name, format, type);
                    continue;
                }
                if ("int".equals(type) || "integer".equals(type)) {
                    this.setResponseHeaderOas30(response, header, name, format, "integer");
                    continue;
                }
                if (!"array".equals(type)) continue;
                Oas30Header ap = response.createHeader(name);
                if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)header.getDescription())) {
                    ap.description = header.getDescription();
                }
                if (header.getArrayType() != null) {
                    String arrayType = header.getArrayType();
                    if (arrayType.equalsIgnoreCase("string") || arrayType.equalsIgnoreCase("long") || arrayType.equalsIgnoreCase("float") || arrayType.equalsIgnoreCase("double") || arrayType.equalsIgnoreCase("boolean")) {
                        this.setHeaderSchemaOas30(ap, arrayType);
                    } else if (header.getArrayType().equalsIgnoreCase("int") || header.getArrayType().equalsIgnoreCase("integer")) {
                        this.setHeaderSchemaOas30(ap, "integer");
                    }
                }
                if (header.getExample() != null) {
                    Extension exampleExtension = ap.createExtension();
                    exampleExtension.name = "x-example";
                    exampleExtension.value = header.getExample();
                    ap.getExtensions().add(exampleExtension);
                }
                response.addHeader(name, ap);
            }
        }
        if (msg.getExamples() != null) {
            Extension exampleExtension = response.createExtension();
            exampleExtension.name = "x-examples";
            HashMap<String, String> examplesValue = new HashMap<String, String>();
            for (RestPropertyDefinition prop : msg.getExamples()) {
                examplesValue.put(prop.getKey(), prop.getValue());
            }
            exampleExtension.value = examplesValue;
            response.addExtension(exampleExtension.name, exampleExtension);
        }
    }

    private void setHeaderSchemaOas30(Oas30Header ap, String arrayType) {
        Oas30Schema items = ap.createSchema();
        items.type = arrayType;
        ap.schema = items;
    }

    private void setResponseHeaderOas30(Oas30Response response, RestOperationResponseHeaderDefinition header, String name, String format, String type) {
        Oas30Schema schema;
        Oas30Header ip = response.createHeader(name);
        response.addHeader(name, ip);
        ip.schema = schema = ip.createSchema();
        schema.type = type;
        if (format != null) {
            schema.format = format;
        }
        ip.description = header.getDescription();
        if (!header.getAllowableValues().isEmpty()) {
            ArrayList<String> values = new ArrayList<String>();
            for (String text : header.getAllowableValues()) {
                values.add(text);
            }
            schema.enum_ = values;
        }
        if (header.getExample() != null) {
            Extension exampleExtension = ip.createExtension();
            exampleExtension.name = "x-example";
            exampleExtension.value = header.getExample();
            ip.getExtensions().add(exampleExtension);
        }
    }

    private void doParseResponseOas20(Oas20Document openApi, Oas20Operation op, RestOperationResponseMsgDefinition msg) {
        Oas20Response response = null;
        if (op.responses != null && op.responses.getResponses() != null) {
            response = (Oas20Response)op.responses.getResponse(msg.getCode());
        }
        if (response == null) {
            response = (Oas20Response)op.responses.createResponse(msg.getCode());
            op.responses.addResponse(msg.getCode(), (OasResponse)response);
        }
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)msg.getResponseModel())) {
            Object model = response.createSchema();
            model = this.modelTypeAsProperty(msg.getResponseModel(), (OasDocument)openApi, (OasSchema)model);
            response.schema = model;
        }
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)msg.getMessage())) {
            response.description = msg.getMessage();
        }
        if (msg.getHeaders() != null) {
            for (RestOperationResponseHeaderDefinition header : msg.getHeaders()) {
                String name = header.getName();
                String type = header.getDataType();
                String format = header.getDataFormat();
                if (response.headers == null) {
                    response.headers = response.createHeaders();
                }
                if ("string".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type) || "boolean".equals(type)) {
                    this.setResponseHeaderOas20(response, header, name, format, type);
                    continue;
                }
                if ("int".equals(type) || "integer".equals(type)) {
                    this.setResponseHeaderOas20(response, header, name, format, "integer");
                    continue;
                }
                if (!"array".equals(type)) continue;
                Oas20Header ap = response.headers.createHeader(name);
                if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)header.getDescription())) {
                    ap.description = header.getDescription();
                }
                if (header.getArrayType() != null) {
                    String arrayType = header.getArrayType();
                    if (arrayType.equalsIgnoreCase("string") || arrayType.equalsIgnoreCase("long") || arrayType.equalsIgnoreCase("float") || arrayType.equalsIgnoreCase("double") || arrayType.equalsIgnoreCase("boolean")) {
                        this.setHeaderSchemaOas20(ap, arrayType);
                    } else if (header.getArrayType().equalsIgnoreCase("int") || header.getArrayType().equalsIgnoreCase("integer")) {
                        this.setHeaderSchemaOas20(ap, "integer");
                    }
                }
                if (header.getExample() != null) {
                    Extension exampleExtension = ap.createExtension();
                    exampleExtension.name = "x-example";
                    exampleExtension.value = header.getExample();
                    ap.getExtensions().add(exampleExtension);
                }
                response.headers.addHeader(name, ap);
            }
        }
        if (msg.getExamples() != null) {
            Extension exampleExtension = response.createExtension();
            exampleExtension.name = "examples";
            HashMap<String, String> examplesValue = new HashMap<String, String>();
            for (RestPropertyDefinition prop : msg.getExamples()) {
                examplesValue.put(prop.getKey(), prop.getValue());
            }
            exampleExtension.value = examplesValue;
            response.addExtension(exampleExtension.name, exampleExtension);
        }
    }

    private void setHeaderSchemaOas20(Oas20Header ap, String arrayType) {
        Oas20Items items = ap.createItems();
        items.type = arrayType;
        ap.items = items;
    }

    private void setResponseHeaderOas20(Oas20Response response, RestOperationResponseHeaderDefinition header, String name, String format, String type) {
        Oas20Header ip = response.headers.createHeader(name);
        ip.type = type;
        if (format != null) {
            ip.format = format;
        }
        ip.description = header.getDescription();
        if (!header.getAllowableValues().isEmpty()) {
            ArrayList<String> values = new ArrayList<String>();
            for (String text : header.getAllowableValues()) {
                values.add(text);
            }
            ip.enum_ = values;
        }
        if (header.getExample() != null) {
            Extension exampleExtension = ip.createExtension();
            exampleExtension.name = "x-example";
            exampleExtension.value = header.getExample();
            ip.getExtensions().add(exampleExtension);
        }
        response.headers.addHeader(name, ip);
    }

    private OasSchema asModel(String typeName, OasDocument openApi) {
        block7: {
            block6: {
                if (!(openApi instanceof Oas20Document)) break block6;
                boolean array = typeName.endsWith("[]");
                if (array) {
                    typeName = typeName.substring(0, typeName.length() - 2);
                }
                if (((Oas20Document)openApi).definitions == null) break block7;
                for (Oas20SchemaDefinition model : ((Oas20Document)openApi).definitions.getDefinitions()) {
                    Map modelType = (Map)model.getExtension((String)"x-className").value;
                    if (modelType == null || !typeName.equals(modelType.get("format"))) continue;
                    return model;
                }
                break block7;
            }
            if (openApi instanceof Oas30Document) {
                boolean array = typeName.endsWith("[]");
                if (array) {
                    typeName = typeName.substring(0, typeName.length() - 2);
                }
                if (((Oas30Document)openApi).components != null && ((Oas30Document)openApi).components.schemas != null) {
                    for (Oas30SchemaDefinition model : ((Oas30Document)openApi).components.schemas.values()) {
                        Map modelType = (Map)model.getExtension((String)"x-className").value;
                        if (modelType == null || !typeName.equals(modelType.get("format"))) continue;
                        return model;
                    }
                }
            }
        }
        return null;
    }

    private String modelTypeAsRef(String typeName, OasDocument openApi) {
        OasSchema model;
        boolean array = typeName.endsWith("[]");
        if (array) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if ((model = this.asModel(typeName, openApi)) != null) {
            typeName = model.type;
            return typeName;
        }
        return null;
    }

    private OasSchema modelTypeAsProperty(String typeName, OasDocument openApi, OasSchema prop) {
        String ref;
        boolean array = typeName.endsWith("[]");
        if (array) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if ((ref = this.modelTypeAsRef(typeName, openApi)) != null) {
            if (openApi instanceof Oas20Document) {
                prop.$ref = "#/definitions/" + ref;
            } else if (openApi instanceof Oas30Document) {
                prop.$ref = "#/components/schemas/" + ref;
            }
        } else if (array && ("byte".equals(typeName) || "java.lang.Byte".equals(typeName))) {
            prop.format = "byte";
            prop.type = "number";
            array = false;
        } else if ("string".equalsIgnoreCase(typeName) || "java.lang.String".equals(typeName)) {
            prop.format = "string";
            prop.type = "sting";
        } else if ("int".equals(typeName) || "java.lang.Integer".equals(typeName)) {
            prop.format = "integer";
            prop.type = "number";
        } else if ("long".equals(typeName) || "java.lang.Long".equals(typeName)) {
            prop.format = "long";
            prop.type = "number";
        } else if ("float".equals(typeName) || "java.lang.Float".equals(typeName)) {
            prop.format = "float";
            prop.type = "number";
        } else if ("double".equals(typeName) || "java.lang.Double".equals(typeName)) {
            prop.format = "double";
            prop.type = "number";
        } else if ("boolean".equals(typeName) || "java.lang.Boolean".equals(typeName)) {
            prop.format = "boolean";
            prop.type = "number";
        } else {
            prop.type = "string";
        }
        if (array) {
            OasSchema ret = prop.createItemsSchema();
            ret.$ref = prop.$ref;
            prop.$ref = null;
            prop.items = ret;
            prop.type = "array";
            return prop;
        }
        return prop;
    }

    private void appendModels(Class<?> clazz, OasDocument openApi) {
        RestModelConverters converters = new RestModelConverters();
        List<? extends OasSchema> models = converters.readClass(openApi, clazz);
        if (models == null) {
            return;
        }
        for (OasSchema oasSchema : models) {
            Oas20SchemaDefinition oldModel;
            boolean oldExt;
            if (openApi instanceof Oas20Document) {
                oldExt = false;
                if (((Oas20Document)openApi).definitions != null && ((Oas20Document)openApi).definitions.getDefinition(((Oas20SchemaDefinition)oasSchema).getName()) != null && (oldModel = ((Oas20Document)openApi).definitions.getDefinition(((Oas20SchemaDefinition)oasSchema).getName())).getExtensions() != null && !oldModel.getExtensions().isEmpty()) {
                    boolean bl = oldExt = oldModel.getExtension("x-className") != null;
                }
                if (oldExt) continue;
                ((Oas20Document)openApi).definitions.addDefinition(((Oas20SchemaDefinition)oasSchema).getName(), (Oas20SchemaDefinition)oasSchema);
                continue;
            }
            if (!(openApi instanceof Oas30Document)) continue;
            oldExt = false;
            if (((Oas30Document)openApi).components != null && ((Oas30Document)openApi).components.getSchemaDefinition(((Oas30SchemaDefinition)oasSchema).getName()) != null && (oldModel = ((Oas30Document)openApi).components.getSchemaDefinition(((Oas30SchemaDefinition)oasSchema).getName())).getExtensions() != null && !oldModel.getExtensions().isEmpty()) {
                boolean bl = oldExt = oldModel.getExtension("x-className") != null;
            }
            if (oldExt) continue;
            ((Oas30Document)openApi).components.addSchemaDefinition(((Oas30SchemaDefinition)oasSchema).getName(), (Oas30SchemaDefinition)oasSchema);
        }
    }

    private static class VerbOrdering
    implements Comparator<VerbDefinition> {
        private VerbOrdering() {
        }

        @Override
        public int compare(VerbDefinition a, VerbDefinition b) {
            int num;
            String u1 = "";
            if (a.getUri() != null) {
                u1 = a.getUri().replace("{", "_");
            }
            String u2 = "";
            if (b.getUri() != null) {
                u2 = b.getUri().replace("{", "_");
            }
            if ((num = u1.compareTo(u2)) == 0) {
                num = a.asVerb().compareTo(b.asVerb());
            }
            return num;
        }
    }
}

