/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.openapi.BeanConfig;
import org.apache.camel.openapi.ExchangeRestApiResponseAdapter;
import org.apache.camel.openapi.RestOpenApiSupport;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestOpenApiProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(RestOpenApiProcessor.class);
    private final BeanConfig openApiConfig;
    private final RestOpenApiSupport support;
    private final String contextIdPattern;
    private final boolean contextIdListing;
    private final RestConfiguration configuration;

    public RestOpenApiProcessor(String contextIdPattern, boolean contextIdListing, Map<String, Object> parameters, RestConfiguration configuration) {
        this.contextIdPattern = contextIdPattern;
        this.contextIdListing = contextIdListing;
        this.configuration = configuration;
        this.support = new RestOpenApiSupport();
        this.openApiConfig = new BeanConfig();
        if (parameters == null) {
            parameters = Collections.EMPTY_MAP;
        }
        this.support.initOpenApi(this.openApiConfig, parameters);
    }

    public void process(Exchange exchange) throws Exception {
        String contextId = exchange.getContext().getName();
        String route = (String)exchange.getIn().getHeader("CamelHttpPath", String.class);
        String accept = (String)exchange.getIn().getHeader("Accept", String.class);
        ExchangeRestApiResponseAdapter adapter = new ExchangeRestApiResponseAdapter(exchange);
        boolean json = false;
        boolean yaml = false;
        if (route != null && route.endsWith("/openapi.json")) {
            json = true;
            route = route.substring(0, route.length() - 13);
        } else if (route != null && route.endsWith("/openapi.yaml")) {
            yaml = true;
            route = route.substring(0, route.length() - 13);
        }
        if (accept != null && !json && !yaml) {
            json = accept.toLowerCase(Locale.US).contains("json");
            yaml = accept.toLowerCase(Locale.US).contains("yaml");
        }
        if (!json && !yaml) {
            json = true;
        }
        try {
            if (this.contextIdListing && (ObjectHelper.isEmpty((Object)route) || route.equals("/"))) {
                this.support.renderCamelContexts(adapter, contextId, this.contextIdPattern, json, yaml, this.configuration);
            } else {
                String name;
                if (ObjectHelper.isNotEmpty((Object)route)) {
                    if (route.startsWith("/")) {
                        route = route.substring(1);
                    }
                    name = route.split("/")[0];
                    if (route.startsWith(contextId)) {
                        route = route.substring(name.length());
                    }
                } else {
                    name = exchange.getContext().getName();
                }
                boolean match = true;
                if (this.contextIdPattern != null) {
                    match = "#name#".equals(this.contextIdPattern) ? name.equals(contextId) : PatternHelper.matchPattern((String)name, (String)this.contextIdPattern);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Match contextId: {} with pattern: {} -> {}", new Object[]{name, this.contextIdPattern, match});
                    }
                }
                if (!match) {
                    adapter.noContent();
                } else {
                    this.support.renderResourceListing(exchange.getContext(), adapter, this.openApiConfig, name, route, json, yaml, exchange.getIn().getHeaders(), exchange.getContext().getClassResolver(), this.configuration);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error rendering OpenApi API due " + e.getMessage(), (Throwable)e);
        }
    }
}

