/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Operation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Operation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Producer;
import org.apache.camel.openapi.RestOpenApiSupport;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiRestProducerFactory
implements RestProducerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiRestProducerFactory.class);

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        OasDocument openApi;
        OasOperation operation;
        String path;
        String apiDoc = (String)parameters.get("apiDoc");
        if (apiDoc == null) {
            throw new IllegalArgumentException("OpenApi api-doc must be configured using the apiDoc option");
        }
        String string = path = uriTemplate != null ? uriTemplate : basePath;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((operation = this.getOpenApiOperation(openApi = this.loadOpenApiModel(camelContext, apiDoc), verb, path)) == null) {
            throw new IllegalArgumentException("OpenApi api-doc does not contain operation for " + verb + ":" + path);
        }
        if (queryParameters != null) {
            for (OasParameter param : operation.parameters) {
                String key;
                String token;
                boolean hasQuery;
                if (!"query".equals(param.in) || !param.required.booleanValue() || (hasQuery = queryParameters.contains(token = (key = param.getName()) + "="))) continue;
                throw new IllegalArgumentException("OpenApi api-doc does not contain query parameter " + key + " for " + verb + ":" + path);
            }
        }
        String componentName = (String)parameters.get("componentName");
        Producer producer = this.createHttpProducer(camelContext, openApi, operation, host, verb, path, queryParameters, produces, consumes, componentName, parameters);
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OasDocument loadOpenApiModel(CamelContext camelContext, String apiDoc) throws Exception {
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)apiDoc);
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(is);
            LOG.debug("Loaded openApi api-doc:\n{}", (Object)node.toPrettyString());
            OasDocument oasDocument = (OasDocument)Library.readDocument((Object)node);
            return oasDocument;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    private OasOperation getOpenApiOperation(OasDocument openApi, String verb, String path) {
        OasPathItem modelPath;
        String basePath = RestOpenApiSupport.getBasePathFromOasDocument(openApi);
        if (basePath != null && path.startsWith(basePath)) {
            path = path.substring(basePath.length());
        }
        if ((modelPath = openApi.paths.getItem(path)) == null) {
            return null;
        }
        OasOperation op = null;
        if ("get".equals(verb)) {
            op = modelPath.get;
        } else if ("put".equals(verb)) {
            op = modelPath.put;
        } else if ("post".equals(verb)) {
            op = modelPath.post;
        } else if ("head".equals(verb)) {
            op = modelPath.head;
        } else if ("delete".equals(verb)) {
            op = modelPath.delete;
        } else if ("patch".equals(verb)) {
            op = modelPath.patch;
        } else if ("options".equals(verb)) {
            op = modelPath.options;
        }
        return op;
    }

    private Producer createHttpProducer(CamelContext camelContext, OasDocument openApi, OasOperation operation, String host, String verb, String path, String queryParameters, String consumes, String produces, String componentName, Map<String, Object> parameters) throws Exception {
        LOG.debug("Using OpenApi operation: {} with {} {}", new Object[]{operation, verb, path});
        RestProducerFactory factory = (RestProducerFactory)parameters.remove("restProducerFactory");
        if (factory != null) {
            Object oas30Operation;
            List<String> list;
            CollectionStringBuffer csb;
            LOG.debug("Using RestProducerFactory: {}", (Object)factory);
            if (produces == null) {
                csb = new CollectionStringBuffer(",");
                list = new ArrayList();
                if (operation instanceof Oas20Operation) {
                    list = ((Oas20Operation)operation).produces;
                } else if (operation instanceof Oas30Operation) {
                    oas30Operation = (Oas30Operation)operation;
                    for (OasResponse response : ((Oas30Operation)oas30Operation).responses.getResponses()) {
                        Oas30Response oas30Response = (Oas30Response)response;
                        for (String ct : oas30Response.content.keySet()) {
                            list.add(ct);
                        }
                    }
                }
                if ((list == null || list.isEmpty()) && openApi instanceof Oas20Document) {
                    list = ((Oas20Document)openApi).produces;
                }
                if (list != null) {
                    for (String string : list) {
                        csb.append((Object)string);
                    }
                }
                String string = produces = csb.isEmpty() ? null : csb.toString();
            }
            if (consumes == null) {
                csb = new CollectionStringBuffer(",");
                list = new ArrayList();
                if (operation instanceof Oas20Operation) {
                    list = ((Oas20Operation)operation).consumes;
                } else if (operation instanceof Oas30Operation) {
                    oas30Operation = (Oas30Operation)operation;
                    if (((Oas30Operation)oas30Operation).requestBody != null && ((Oas30Operation)oas30Operation).requestBody.content != null) {
                        for (String ct : ((Oas30Operation)oas30Operation).requestBody.content.keySet()) {
                            list.add(ct);
                        }
                    }
                }
                if ((list == null || list.isEmpty()) && openApi instanceof Oas20Document) {
                    list = ((Oas20Document)openApi).consumes;
                }
                if (list != null) {
                    for (String string : list) {
                        csb.append((Object)string);
                    }
                }
                consumes = csb.isEmpty() ? null : csb.toString();
            }
            String basePath = null;
            String uriTemplate = null;
            if (host == null) {
                host = RestOpenApiSupport.getHostFromOasDocument(openApi);
                basePath = RestOpenApiSupport.getBasePathFromOasDocument(openApi);
                uriTemplate = path;
            } else {
                basePath = path;
                uriTemplate = null;
            }
            RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)camelContext, null, (String)componentName);
            return factory.createProducer(camelContext, host, verb, basePath, uriTemplate, queryParameters, consumes, produces, config, parameters);
        }
        throw new IllegalStateException("Cannot find RestProducerFactory in Registry or as a Component to use");
    }
}

