/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Definitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30SchemaDefinition;
import java.util.HashMap;
import java.util.List;

public class RestModelConverters {
    public List<? extends OasSchema> readClass(OasDocument oasDocument, Class<?> clazz) {
        if (oasDocument instanceof Oas20Document) {
            return this.readClassOas20((Oas20Document)oasDocument, clazz);
        }
        if (oasDocument instanceof Oas30Document) {
            return this.readClassOas30((Oas30Document)oasDocument, clazz);
        }
        return null;
    }

    private List<? extends OasSchema> readClassOas30(Oas30Document oasDocument, Class<?> clazz) {
        String name = clazz.getName();
        if (!name.contains(".")) {
            return null;
        }
        if (oasDocument.components == null) {
            oasDocument.components = oasDocument.createComponents();
        }
        Oas30SchemaDefinition model = oasDocument.components.createSchemaDefinition(clazz.getSimpleName());
        oasDocument.components.addSchemaDefinition(clazz.getSimpleName(), model);
        model.type = clazz.getSimpleName();
        Extension extension = model.createExtension();
        extension.name = "x-className";
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("type", "string");
        value.put("format", name);
        extension.value = value;
        model.addExtension("x-className", extension);
        return oasDocument.components.getSchemaDefinitions();
    }

    private List<? extends OasSchema> readClassOas20(Oas20Document oasDocument, Class<?> clazz) {
        String name = clazz.getName();
        if (!name.contains(".")) {
            return null;
        }
        if (oasDocument.definitions == null) {
            oasDocument.definitions = oasDocument.createDefinitions();
        }
        Oas20Definitions resolved = oasDocument.definitions;
        Oas20SchemaDefinition model = resolved.createSchemaDefinition(clazz.getSimpleName());
        resolved.addDefinition(clazz.getSimpleName(), model);
        model.type = clazz.getSimpleName();
        Extension extension = model.createExtension();
        extension.name = "x-className";
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("type", "string");
        value.put("format", name);
        extension.value = value;
        model.addExtension("x-className", extension);
        return resolved.getDefinitions();
    }
}

