/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.language.markup.xsp.XSPGenerator;
import org.apache.cocoon.environment.SourceResolver;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PythonGenerator
extends XSPGenerator
implements Configurable,
Initializable {
    private File file;
    private PythonInterpreter python;
    private PyCode code;
    private Exception compileError;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.file = new File(configuration.getChild("file").getValue());
        Configuration[] dependencies = configuration.getChildren("dependency");
        this.dependencies = new File[dependencies.length];
        for (int i = 0; i < dependencies.length; ++i) {
            this.dependencies[i] = new File(dependencies[i].getValue());
        }
    }

    public boolean modifiedSince(long date) {
        if (this.file.lastModified() < date) {
            return true;
        }
        for (int i = 0; i < this.dependencies.length; ++i) {
            if (this.file.lastModified() >= this.dependencies[i].lastModified()) continue;
            return true;
        }
        return false;
    }

    public void initialize() throws Exception {
        try {
            Properties properties = new Properties();
            File workDir = (File)this.avalonContext.get((Object)"work-directory");
            properties.setProperty("python.home", workDir.toString());
            properties.setProperty("python.packages.fakepath", "");
            PythonInterpreter.initialize((Properties)System.getProperties(), (Properties)properties, (String[])new String[0]);
            this.python = new PythonInterpreter();
            this.python.set("page", (Object)this);
            this.python.set("logger", (Object)this.getLogger());
            this.python.set("xspAttr", (Object)new AttributesImpl());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Compiling script " + this.file));
            }
            this.code = Py.compile((InputStream)new FileInputStream(this.file), (String)this.file.toString(), (String)"exec");
        }
        catch (Exception e) {
            this.compileError = e;
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        if (this.compileError != null) {
            throw new ProcessingException("Failed to compile script", (Throwable)this.compileError);
        }
        this.python.set("objectModel", (Object)this.objectModel);
        this.python.set("request", (Object)this.request);
        this.python.set("response", (Object)this.response);
        this.python.set("context", (Object)this.context);
        this.python.set("resolver", (Object)this.resolver);
        this.python.set("parameters", (Object)this.parameters);
    }

    public void generate() throws IOException, ProcessingException {
        try {
            this.python.set("contentHandler", (Object)this.contentHandler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Executing script " + this.file));
            }
            this.python.exec((PyObject)this.code);
        }
        catch (Exception e) {
            throw new ProcessingException("generate: Got Python exception", (Throwable)e);
        }
    }

    public void recycle() {
        this.python.set("contentHandler", null);
        this.python.set("objectModel", null);
        this.python.set("request", null);
        this.python.set("response", null);
        this.python.set("context", null);
        this.python.set("resolver", null);
        this.python.set("parameters", null);
        super.recycle();
    }

    public void dispose() {
        this.python.set("page", null);
        this.python.set("logger", null);
        this.python.set("xspAttr", null);
        this.python = null;
        this.compileError = null;
        this.code = null;
        super.dispose();
    }
}

