
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
/*
 * This class is generated using freemarker and the ConvertToNullableHolder.java template.
 */

@FunctionTemplate(name = "convertToNullableVARDECIMAL",
    scope = FunctionTemplate.FunctionScope.SIMPLE,
    returnType = FunctionTemplate.ReturnType.SAME_IN_OUT_LENGTH,
    nulls = FunctionTemplate.NullHandling.INTERNAL,
    isInternal = true)
public class GConvertToNullableVarDecimalHolder implements DrillSimpleFunc {

  @Param VarDecimalHolder input;
  @Output NullableVarDecimalHolder output;

  public void setup() { }

  public void eval() {
    output.isSet = 1;
    output.start = input.start;
    output.end = input.end;
    output.buffer = input.buffer;
  }
}


