/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.community.lpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.ComputationContext;

public class Lpa
implements Computation<Id> {
    private final Random random = new Random();

    public String name() {
        return "lpa";
    }

    public String category() {
        return "community";
    }

    public void compute0(ComputationContext context, Vertex vertex) {
        Id value = vertex.id();
        vertex.value((Value)value);
        vertex.inactivate();
        context.sendMessageToAllEdges(vertex, (Value)value);
    }

    public void compute(ComputationContext context, Vertex vertex, Iterator<Id> messages) {
        Id label = this.voteLabel(messages);
        Id value = (Id)vertex.value();
        if (!value.equals(label)) {
            vertex.value((Value)label);
            context.sendMessageToAllEdges(vertex, (Value)label);
        }
        vertex.inactivate();
    }

    private Id voteLabel(Iterator<Id> messages) {
        HashMap<Id, MutableInt> labels = new HashMap<Id, MutableInt>();
        assert (messages.hasNext());
        while (messages.hasNext()) {
            Id label = messages.next();
            MutableInt labelCount = (MutableInt)labels.get(label);
            if (labelCount != null) {
                labelCount.increment();
                continue;
            }
            labels.put(label, new MutableInt(1));
        }
        ArrayList<Id> maxLabels = new ArrayList<Id>();
        int maxFreq = 1;
        for (Map.Entry e : labels.entrySet()) {
            int value = ((MutableInt)e.getValue()).intValue();
            if (value > maxFreq) {
                maxFreq = value;
                maxLabels.clear();
            }
            if (value != maxFreq) continue;
            maxLabels.add((Id)e.getKey());
        }
        int selected = this.random.nextInt(maxLabels.size());
        return (Id)maxLabels.get(selected);
    }
}

