/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.community.trianglecount;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.hugegraph.computer.algorithm.community.trianglecount.TriangleCountValue;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.edge.Edges;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.IdList;
import org.apache.hugegraph.computer.core.graph.value.IdSet;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.ComputationContext;

public class TriangleCount
implements Computation<IdList> {
    public String name() {
        return "triangle_count";
    }

    public String category() {
        return "community";
    }

    public void compute0(ComputationContext context, Vertex vertex) {
        IdSet selfId = new IdSet();
        selfId.add(vertex.id());
        context.sendMessageToAllEdgesIf(vertex, (Value)selfId, (ids, targetId) -> !vertex.id().equals(targetId));
        vertex.value((Value)new TriangleCountValue());
    }

    public void compute(ComputationContext context, Vertex vertex, Iterator<IdList> messages) {
        IdSet neighbors = ((TriangleCountValue)vertex.value()).idSet();
        Integer count = this.triangleCount(context, vertex, messages, neighbors);
        if (count != null) {
            ((TriangleCountValue)vertex.value()).count(count);
            vertex.inactivate();
        }
    }

    protected Integer triangleCount(ComputationContext context, Vertex vertex, Iterator<IdList> messages, IdSet neighbors) {
        if (context.superstep() == 1) {
            Set<Id> outNeighbors = TriangleCount.getOutNeighbors(vertex);
            neighbors.addAll(outNeighbors);
            while (messages.hasNext()) {
                IdList idList = messages.next();
                assert (idList.size() == 1);
                Id inId = (Id)idList.getFirst();
                if (outNeighbors.contains(inId)) continue;
                neighbors.add(inId);
            }
            for (Id targetId : neighbors.value()) {
                context.sendMessage(targetId, (Value)neighbors);
            }
        } else if (context.superstep() == 2) {
            int count = 0;
            while (messages.hasNext()) {
                IdList twoDegreeNeighbors = messages.next();
                for (Id twoDegreeNeighbor : twoDegreeNeighbors.values()) {
                    if (!neighbors.contains(twoDegreeNeighbor)) continue;
                    ++count;
                }
            }
            return count >> 1;
        }
        return null;
    }

    private static Set<Id> getOutNeighbors(Vertex vertex) {
        HashSet<Id> outNeighbors = new HashSet<Id>();
        Edges edges = vertex.edges();
        for (Edge edge : edges) {
            Id targetId = edge.targetId();
            if (vertex.id().equals(targetId)) continue;
            outNeighbors.add(targetId);
        }
        return outNeighbors;
    }
}

