/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.path.rings.filter;

import java.util.Iterator;
import org.apache.hugegraph.computer.algorithm.path.rings.filter.RingsDetectionMessage;
import org.apache.hugegraph.computer.algorithm.path.rings.filter.SpreadFilter;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.IdList;
import org.apache.hugegraph.computer.core.graph.value.IdListList;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.ComputationContext;

public class RingsDetectionWithFilter
implements Computation<RingsDetectionMessage> {
    public static final String OPTION_FILTER = "rings.property_filter";
    private SpreadFilter filter;

    public String name() {
        return "rings_with_filter";
    }

    public String category() {
        return "path";
    }

    public void init(Config config) {
        this.filter = new SpreadFilter(config.getString(OPTION_FILTER, "{}"));
    }

    public void compute0(ComputationContext context, Vertex vertex) {
        vertex.value((Value)new IdListList());
        if (vertex.edges().size() == 0 || !this.filter.filter(vertex)) {
            return;
        }
        RingsDetectionMessage message = new RingsDetectionMessage();
        message.addPath(vertex);
        for (Edge edge : vertex.edges()) {
            if (!this.filter.filter(edge)) continue;
            message.walkEdgeProp(edge.properties());
            context.sendMessage(edge.targetId(), (Value)message);
        }
    }

    public void compute(ComputationContext context, Vertex vertex, Iterator<RingsDetectionMessage> messages) {
        boolean halt = true;
        if (this.filter.filter(vertex)) {
            Id vertexId = vertex.id();
            while (messages.hasNext()) {
                Id pathVertexValue;
                halt = false;
                RingsDetectionMessage message = messages.next();
                IdList path = message.path();
                if (vertexId.equals(path.getFirst())) {
                    boolean isMin = true;
                    for (int i = 0; i < path.size(); ++i) {
                        pathVertexValue = (Id)path.get(i);
                        if (vertexId.compareTo((Object)pathVertexValue) <= 0) continue;
                        isMin = false;
                        break;
                    }
                    if (!isMin) continue;
                    path.add((Value.Tvalue)vertexId);
                    IdListList value = (IdListList)vertex.value();
                    value.add((Value.Tvalue)path.copy());
                    continue;
                }
                boolean contains = false;
                for (int i = 0; i < path.size(); ++i) {
                    pathVertexValue = (Id)path.get(i);
                    if (!pathVertexValue.equals(vertex.id())) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                path.add((Value.Tvalue)vertex.id());
                for (Edge edge : vertex.edges()) {
                    if (!this.filter.filter(edge, message)) continue;
                    message.walkEdgeProp(edge.properties());
                    context.sendMessage(edge.targetId(), (Value)message);
                }
            }
        }
        if (halt) {
            vertex.inactivate();
        }
    }
}

