/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.path.shortest;

import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.computer.algorithm.path.shortest.QuantityType;
import org.apache.hugegraph.computer.algorithm.path.shortest.SingleSourceShortestPathValue;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.DoubleValue;
import org.apache.hugegraph.computer.core.graph.value.IdSet;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.util.IdUtil;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.ComputationContext;
import org.apache.hugegraph.computer.core.worker.WorkerContext;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class SingleSourceShortestPath
implements Computation<SingleSourceShortestPathValue> {
    private static final Logger LOG = Log.logger(SingleSourceShortestPath.class);
    public static final String OPTION_SOURCE_ID = "single_source_shortest_path.source_id";
    public static final String OPTION_TARGET_ID = "single_source_shortest_path.target_id";
    public static final String OPTION_WEIGHT_PROPERTY = "single_source_shortest_path.weight_property";
    public static final String OPTION_DEFAULT_WEIGHT = "single_source_shortest_path.default_weight";
    private Id sourceId;
    private IdSet targetIdSet;
    private QuantityType targetQuantityType;
    private String weightProperty;
    private Double defaultWeight;
    private IdSet reachedTargets;

    public String category() {
        return "path";
    }

    public String name() {
        return "single_source_shortest_path";
    }

    public void init(Config config) {
        String sourceIdStr = config.getString(OPTION_SOURCE_ID, "");
        if (StringUtils.isBlank((CharSequence)sourceIdStr)) {
            throw new ComputerException("The param '%s' must not be blank", new Object[]{OPTION_SOURCE_ID});
        }
        this.sourceId = IdUtil.parseId((String)sourceIdStr);
        String targetIdStr = config.getString(OPTION_TARGET_ID, "");
        if (StringUtils.isBlank((CharSequence)targetIdStr)) {
            throw new ComputerException("The param '%s' must not be blank", new Object[]{OPTION_TARGET_ID});
        }
        targetIdStr = Arrays.stream(targetIdStr.split(",")).map(e -> e.trim()).collect(Collectors.joining(","));
        this.targetQuantityType = this.getQuantityType(targetIdStr);
        if (this.targetQuantityType != QuantityType.ALL) {
            this.targetIdSet = new IdSet();
            for (String targetId : targetIdStr.split(",")) {
                this.targetIdSet.add(IdUtil.parseId((String)targetId));
            }
        }
        this.weightProperty = config.getString(OPTION_WEIGHT_PROPERTY, "");
        this.defaultWeight = config.getDouble(OPTION_DEFAULT_WEIGHT, 1.0);
        if (this.defaultWeight <= 0.0) {
            throw new ComputerException("The param '%s' must be greater than 0, actual got '%s'", new Object[]{OPTION_DEFAULT_WEIGHT, this.defaultWeight});
        }
    }

    public void compute0(ComputationContext context, Vertex vertex) {
        SingleSourceShortestPathValue value = new SingleSourceShortestPathValue();
        value.unreachable();
        vertex.value((Value)value);
        if (!this.sourceId.equals(vertex.id())) {
            vertex.inactivate();
            return;
        }
        value.zeroDistance();
        if (this.targetQuantityType == QuantityType.SINGLE && this.targetIdSet.contains(this.sourceId)) {
            LOG.debug("source vertex equals target vertex: {}", (Object)this.sourceId);
            vertex.inactivate();
            return;
        }
        if (vertex.numEdges() <= 0) {
            LOG.debug("The source vertex is isolated: {}", (Object)this.sourceId);
            vertex.inactivate();
            return;
        }
        vertex.edges().forEach(edge -> {
            SingleSourceShortestPathValue message = new SingleSourceShortestPathValue();
            message.addToPath(vertex, this.getEdgeWeight((Edge)edge));
            context.sendMessage(edge.targetId(), (Value)message);
        });
        vertex.inactivate();
    }

    public void compute(ComputationContext context, Vertex vertex, Iterator<SingleSourceShortestPathValue> messages) {
        if (this.isTarget(vertex) && !this.reachedTargets.contains(vertex.id())) {
            this.reachedTargets.add(vertex.id());
        }
        while (messages.hasNext()) {
            SingleSourceShortestPathValue message = messages.next();
            SingleSourceShortestPathValue value = (SingleSourceShortestPathValue)vertex.value();
            if (!(message.totalWeight() < value.totalWeight())) continue;
            value.shorterPath(vertex, message.path(), message.totalWeight());
            if (this.isTarget(vertex) && this.isAllTargetsReached(vertex) || vertex.numEdges() <= 0) continue;
            vertex.edges().forEach(edge -> {
                SingleSourceShortestPathValue forwardMessage = new SingleSourceShortestPathValue();
                forwardMessage.addToPath(value.path(), value.totalWeight() + this.getEdgeWeight((Edge)edge));
                context.sendMessage(edge.targetId(), (Value)forwardMessage);
            });
        }
        vertex.inactivate();
    }

    public void beforeSuperstep(WorkerContext context) {
        this.reachedTargets = (IdSet)context.aggregatedValue("single_source_shortest_path.reached_targets");
    }

    public void afterSuperstep(WorkerContext context) {
        context.aggregateValue("single_source_shortest_path.reached_targets", (Value)this.reachedTargets);
    }

    private QuantityType getQuantityType(String targetIdStr) {
        if (targetIdStr.equals("*")) {
            return QuantityType.ALL;
        }
        if (targetIdStr.contains(",")) {
            return QuantityType.MULTIPLE;
        }
        return QuantityType.SINGLE;
    }

    private double getEdgeWeight(Edge edge) {
        double weight = this.defaultWeight;
        Value property = edge.property(this.weightProperty);
        if (property != null) {
            if (!property.isNumber()) {
                throw new ComputerException("The value of %s must be a numeric value, actual got '%s'", new Object[]{this.weightProperty, property.string()});
            }
            weight = ((DoubleValue)property).doubleValue();
            if (weight <= 0.0) {
                throw new ComputerException("The value of %s must be greater than 0, actual got '%s'", new Object[]{this.weightProperty, property.string()});
            }
        }
        return weight;
    }

    private boolean isTarget(Vertex vertex) {
        return this.targetQuantityType != QuantityType.ALL && this.targetIdSet.contains(vertex.id());
    }

    private boolean isAllTargetsReached(Vertex vertex) {
        if (this.targetQuantityType == QuantityType.ALL) {
            return false;
        }
        if (this.targetIdSet.size() == this.reachedTargets.size()) {
            for (Id targetId : this.targetIdSet.value()) {
                if (this.reachedTargets.contains(targetId)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public IdSet getTargetIdSet() {
        return this.targetIdSet;
    }
}

