/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.Multimap;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.binders.BindAccountSecurityGroupPairsToIndexedQueryParams;
import org.jclouds.cloudstack.binders.BindCIDRsToCommaDelimitedQueryParam;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.ListSecurityGroupsOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface SecurityGroupApi {
    @Named(value="listSecurityGroups")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listSecurityGroups", "true"})
    @SelectJson(value={"securitygroup"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<SecurityGroup> listSecurityGroups(ListSecurityGroupsOptions ... var1);

    @Named(value="listSecurityGroups")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listSecurityGroups", "true"})
    @SelectJson(value={"securitygroup"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public SecurityGroup getSecurityGroup(@QueryParam(value="id") String var1);

    @Named(value="listSecurityGroups")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listSecurityGroups", "true"})
    @SelectJson(value={"securitygroup"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public SecurityGroup getSecurityGroupByName(@QueryParam(value="securitygroupname") String var1);

    @Named(value="createSecurityGroup")
    @GET
    @QueryParams(keys={"command"}, values={"createSecurityGroup"})
    @SelectJson(value={"securitygroup"})
    @Consumes(value={"application/json"})
    public SecurityGroup createSecurityGroup(@QueryParam(value="name") String var1);

    @Named(value="authorizeSecurityGroupIngress")
    @GET
    @QueryParams(keys={"command"}, values={"authorizeSecurityGroupIngress"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String authorizeIngressPortsToCIDRs(@QueryParam(value="securitygroupid") String var1, @QueryParam(value="protocol") String var2, @QueryParam(value="startport") int var3, @QueryParam(value="endport") int var4, @BinderParam(value=BindCIDRsToCommaDelimitedQueryParam.class) Iterable<String> var5, AccountInDomainOptions ... var6);

    @Named(value="authorizeSecurityGroupIngress")
    @GET
    @QueryParams(keys={"command"}, values={"authorizeSecurityGroupIngress"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String authorizeIngressPortsToSecurityGroups(@QueryParam(value="securitygroupid") String var1, @QueryParam(value="protocol") String var2, @QueryParam(value="startport") int var3, @QueryParam(value="endport") int var4, @BinderParam(value=BindAccountSecurityGroupPairsToIndexedQueryParams.class) Multimap<String, String> var5, AccountInDomainOptions ... var6);

    @Named(value="authorizeSecurityGroupIngress")
    @GET
    @QueryParams(keys={"command", "protocol"}, values={"authorizeSecurityGroupIngress", "ICMP"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String authorizeIngressICMPToCIDRs(@QueryParam(value="securitygroupid") String var1, @QueryParam(value="icmpcode") int var2, @QueryParam(value="icmptype") int var3, @BinderParam(value=BindCIDRsToCommaDelimitedQueryParam.class) Iterable<String> var4, AccountInDomainOptions ... var5);

    @Named(value="authorizeSecurityGroupIngress")
    @GET
    @QueryParams(keys={"command", "protocol"}, values={"authorizeSecurityGroupIngress", "ICMP"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String authorizeIngressICMPToSecurityGroups(@QueryParam(value="securitygroupid") String var1, @QueryParam(value="icmpcode") int var2, @QueryParam(value="icmptype") int var3, @BinderParam(value=BindAccountSecurityGroupPairsToIndexedQueryParams.class) Multimap<String, String> var4, AccountInDomainOptions ... var5);

    @Named(value="revokeSecurityGroupIngress")
    @GET
    @QueryParams(keys={"command"}, values={"revokeSecurityGroupIngress"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String revokeIngressRule(@QueryParam(value="id") String var1, AccountInDomainOptions ... var2);

    @Named(value="deleteSecurityGroup")
    @GET
    @QueryParams(keys={"command"}, values={"deleteSecurityGroup"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteSecurityGroup(@QueryParam(value="id") String var1);
}

