/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jclouds.cloudstack.domain.ZoneAndName;

public class ZoneSecurityGroupNamePortsCidrs
extends ZoneAndName {
    private final Set<Integer> ports;
    private final Set<String> cidrs;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromZoneSecurityGroupNamePortsCidrs(this);
    }

    protected ZoneSecurityGroupNamePortsCidrs(String zoneId, String name, Set<Integer> ports, Set<String> cidrs) {
        super(zoneId, name);
        this.ports = ports == null ? ImmutableSet.of() : ImmutableSet.copyOf(ports);
        this.cidrs = cidrs == null ? ImmutableSet.of() : ImmutableSet.copyOf(cidrs);
    }

    public Set<Integer> getPorts() {
        return this.ports;
    }

    public Set<String> getCidrs() {
        return this.cidrs;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zoneId, this.name, this.ports, this.cidrs});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ZoneSecurityGroupNamePortsCidrs that = (ZoneSecurityGroupNamePortsCidrs)ZoneSecurityGroupNamePortsCidrs.class.cast(obj);
        return Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.ports, that.ports) && Objects.equal(this.cidrs, that.cidrs);
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("zoneId", (Object)this.zoneId).add("name", (Object)this.name).add("ports", this.ports).add("cidrs", this.cidrs);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String zoneId;
        protected String name;
        protected Set<Integer> ports = ImmutableSet.of();
        protected Set<String> cidrs = ImmutableSet.of();

        protected abstract T self();

        public T zone(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T ports(Set<Integer> ports) {
            this.ports = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(ports, (Object)"ports")));
            return this.self();
        }

        public T ports(Integer ... in) {
            return this.ports((Set<Integer>)ImmutableSet.copyOf((Object[])in));
        }

        public T cidrs(Set<String> cidrs) {
            this.cidrs = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(cidrs, (Object)"cidrs")));
            return this.self();
        }

        public T cidrs(String ... in) {
            return this.cidrs((Set<String>)ImmutableSet.copyOf((Object[])in));
        }

        public ZoneSecurityGroupNamePortsCidrs build() {
            return new ZoneSecurityGroupNamePortsCidrs(this.zoneId, this.name, this.ports, this.cidrs);
        }

        public T fromZoneSecurityGroupNamePortsCidrs(ZoneSecurityGroupNamePortsCidrs in) {
            return ((Builder)((Builder)((Builder)this.zone(in.getZone())).name(in.getName())).ports(in.getPorts())).cidrs(in.getCidrs());
        }
    }
}

