/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

@Singleton
public class ParseIdToNameFromHttpResponse
implements Function<HttpResponse, Map<String, String>> {
    private final ParseFirstJsonValueNamed<Set<IdName>> parser;

    @Inject
    public ParseIdToNameFromHttpResponse(GsonWrapper gsonView) {
        this.parser = new ParseFirstJsonValueNamed((GsonWrapper)Preconditions.checkNotNull((Object)gsonView, (Object)"gsonView"), (TypeLiteral)new TypeLiteral<Set<IdName>>(){}, new String[]{"oscategory"});
    }

    public Map<String, String> apply(HttpResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        Set toParse = (Set)this.parser.apply(response);
        Preconditions.checkNotNull((Object)toParse, (String)"parsed result from %s", (Object[])new Object[]{response});
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (IdName entry : toParse) {
            builder.put((Object)entry.id, (Object)entry.name);
        }
        return builder.build();
    }

    private static class IdName {
        private String id;
        private String name;

        private IdName() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdName that = (IdName)o;
            if (!Objects.equal((Object)this.id, (Object)that.id)) {
                return false;
            }
            return Objects.equal((Object)this.name, (Object)that.name);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.name});
        }
    }
}

