/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.compute.strategy.CloudStackComputeServiceAdapter;
import org.jclouds.cloudstack.internal.BaseCloudStackComputeServiceContextExpectTest;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CloudStackComputeServiceAdapterExpectTest
extends BaseCloudStackComputeServiceContextExpectTest<Injector> {
    HttpResponse deployVMResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deployvirtualmachineresponse.json"))).build();
    HttpRequest queryAsyncJobResult = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"queryAsyncJobResult"}).addQueryParam("jobid", new String[]{"50006"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"v8BWKMxd+IzHIuTaZ9sNSzCWqFI="}).addHeader("Accept", new String[]{"application/json"})).build();
    HttpResponse queryAsyncJobResultResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/queryasyncjobresultresponse-virtualmachine.json"))).build();
    HttpResponse queryAsyncJobResultSecurityGroupResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/queryasyncjobresultresponse-virtualmachine-securitygroup.json"))).build();
    HttpRequest queryAsyncJobResultAuthorizeIngress = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"queryAsyncJobResult"}).addQueryParam("jobid", new String[]{"13330fc9-8b3e-4582-aa3e-90883c041010"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"y4gk3ckWAMPDNZM26LUK0gAhfiE="}).addHeader("Accept", new String[]{"application/json"})).build();
    HttpResponse queryAsyncJobResultAuthorizeIngressResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/queryasyncjobresultresponse-authorizeingress.json"))).build();
    HttpRequest listCapabilitiesNotListAll = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listCapabilities"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"l3PVoJnKK2G2gHk3HPHtpwWjlW4="}).addHeader("Accept", new String[]{"application/json"})).build();

    public void testCreateNodeWithGroupEncodedIntoName() {
        HttpRequest deployVM = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deployVirtualMachine"}).addQueryParam("zoneid", new String[]{"1"}).addQueryParam("serviceofferingid", new String[]{"1"}).addQueryParam("templateid", new String[]{"4"}).addQueryParam("displayname", new String[]{"test-e92"}).addQueryParam("name", new String[]{"test-e92"}).addQueryParam("networkids", new String[]{"204"}).addQueryParam("group", new String[]{"test"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"M2Wx0CgOeH9vYHhbcbblwziqpwI="}).addHeader("Accept", new String[]{"application/json"})).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listProjects, (Object)this.listProjectsResponse).put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)this.getZone, (Object)this.getZoneResponse).put((Object)deployVM, (Object)this.deployVMResponse).put((Object)this.queryAsyncJobResult, (Object)this.queryAsyncJobResultResponse).build();
        Injector forNode = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        Template template = ((TemplateBuilder)forNode.getInstance(TemplateBuilder.class)).osFamily(OsFamily.CENTOS).build();
        ((CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class)).setupStaticNat(false);
        CloudStackComputeServiceAdapter adapter = (CloudStackComputeServiceAdapter)forNode.getInstance(CloudStackComputeServiceAdapter.class);
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((Object)server.getCredentials(), (Object)LoginCredentials.builder().password("dD7jwajkh").build());
    }

    public void testCreateNodeWithGroupEncodedIntoNameWithKeyPair() throws IOException {
        HttpRequest deployVM = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deployVirtualMachine"}).addQueryParam("zoneid", new String[]{"1"}).addQueryParam("serviceofferingid", new String[]{"1"}).addQueryParam("templateid", new String[]{"4"}).addQueryParam("displayname", new String[]{"test-e92"}).addQueryParam("name", new String[]{"test-e92"}).addQueryParam("networkids", new String[]{"204"}).addQueryParam("group", new String[]{"test"}).addQueryParam("keypair", new String[]{"mykeypair"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"D3qQlTNjxrBXeG82C7YPrwU1jMc="}).addHeader("Accept", new String[]{"application/json"})).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listProjects, (Object)this.listProjectsResponse).put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)this.getZone, (Object)this.getZoneResponse).put((Object)deployVM, (Object)this.deployVMResponse).put((Object)this.queryAsyncJobResult, (Object)this.queryAsyncJobResultResponse).build();
        Injector forKeyPair = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        String privKey = Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/test"));
        Template template = ((TemplateBuilder)forKeyPair.getInstance(TemplateBuilder.class)).osFamily(OsFamily.CENTOS).build();
        ((CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class)).keyPair("mykeypair").setupStaticNat(false).overrideLoginPrivateKey(privKey);
        CloudStackComputeServiceAdapter adapter = (CloudStackComputeServiceAdapter)forKeyPair.getInstance(CloudStackComputeServiceAdapter.class);
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((String)((String)server.getCredentials().getOptionalPrivateKey().get()), (String)privKey);
    }

    public void testCreateNodeWithGroupEncodedIntoNameWithGenerateKeyPair() throws IOException {
        HttpRequest deployVM = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deployVirtualMachine"}).addQueryParam("zoneid", new String[]{"1"}).addQueryParam("serviceofferingid", new String[]{"1"}).addQueryParam("templateid", new String[]{"4"}).addQueryParam("displayname", new String[]{"test-e92"}).addQueryParam("name", new String[]{"test-e92"}).addQueryParam("networkids", new String[]{"204"}).addQueryParam("group", new String[]{"test"}).addQueryParam("keypair", new String[]{"jclouds-test"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"kfU/J/REa4DdYj0b/pSjuB3h3Qc="}).addHeader("Accept", new String[]{"application/json"})).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listProjects, (Object)this.listProjectsResponse).put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)this.getZone, (Object)this.getZoneResponse).put((Object)deployVM, (Object)this.deployVMResponse).put((Object)this.createSSHKeyPair, (Object)this.createSSHKeyPairResponse).put((Object)this.queryAsyncJobResult, (Object)this.queryAsyncJobResultResponse).build();
        Injector forKeyPair = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        Template template = ((TemplateBuilder)forKeyPair.getInstance(TemplateBuilder.class)).osFamily(OsFamily.CENTOS).build();
        ((CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class)).generateKeyPair(true).setupStaticNat(false);
        CloudStackComputeServiceAdapter adapter = (CloudStackComputeServiceAdapter)forKeyPair.getInstance(CloudStackComputeServiceAdapter.class);
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertTrue((boolean)server.getCredentials().getOptionalPrivateKey().isPresent());
    }

    public void testCreateNodeWithGroupEncodedIntoNameWithKeyPairDefaultSecurityGroup() throws IOException {
        HttpRequest deployVM = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deployVirtualMachine"}).addQueryParam("zoneid", new String[]{"2"}).addQueryParam("serviceofferingid", new String[]{"1"}).addQueryParam("templateid", new String[]{"241"}).addQueryParam("displayname", new String[]{"test-e92"}).addQueryParam("name", new String[]{"test-e92"}).addQueryParam("networkids", new String[]{"204"}).addQueryParam("group", new String[]{"test"}).addQueryParam("keypair", new String[]{"mykeypair"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"5qkUSGh0y+P/t04/j3+EN9PAeFI="}).addHeader("Accept", new String[]{"application/json"})).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listProjects, (Object)this.listProjectsResponse).put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksWithSecurityGroupsResponse).put((Object)this.getZoneWithSecurityGroups, (Object)this.getZoneWithSecurityGroupsResponse).put((Object)deployVM, (Object)this.deployVMResponse).put((Object)this.queryAsyncJobResult, (Object)this.queryAsyncJobResultResponse).build();
        Injector forKeyPair = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        String privKey = Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/test"));
        Template template = ((TemplateBuilder)forKeyPair.getInstance(TemplateBuilder.class)).osFamily(OsFamily.CENTOS).locationId("2").build();
        ((CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class)).keyPair("mykeypair").setupStaticNat(false).overrideLoginPrivateKey(privKey);
        CloudStackComputeServiceAdapter adapter = (CloudStackComputeServiceAdapter)forKeyPair.getInstance(CloudStackComputeServiceAdapter.class);
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((String)((String)server.getCredentials().getOptionalPrivateKey().get()), (String)privKey);
    }

    public void testCreateNodeWithGroupEncodedIntoNameWithKeyPairDefaultSecurityGroupAndDisk() throws IOException {
        HttpRequest deployVM = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deployVirtualMachine"}).addQueryParam("zoneid", new String[]{"2"}).addQueryParam("serviceofferingid", new String[]{"1"}).addQueryParam("templateid", new String[]{"241"}).addQueryParam("displayname", new String[]{"test-e92"}).addQueryParam("name", new String[]{"test-e92"}).addQueryParam("networkids", new String[]{"204"}).addQueryParam("group", new String[]{"test"}).addQueryParam("keypair", new String[]{"mykeypair"}).addQueryParam("diskofferingid", new String[]{"5678"}).addQueryParam("size", new String[]{"10"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"lDzBXtVKCktueskyI/haID9ohJU="}).addHeader("Accept", new String[]{"application/json"})).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listProjects, (Object)this.listProjectsResponse).put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksWithSecurityGroupsResponse).put((Object)this.getZoneWithSecurityGroups, (Object)this.getZoneWithSecurityGroupsResponse).put((Object)deployVM, (Object)this.deployVMResponse).put((Object)this.queryAsyncJobResult, (Object)this.queryAsyncJobResultResponse).build();
        Injector forKeyPair = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        String privKey = Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/test"));
        Template template = ((TemplateBuilder)forKeyPair.getInstance(TemplateBuilder.class)).osFamily(OsFamily.CENTOS).locationId("2").build();
        ((CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class)).keyPair("mykeypair").diskOfferingId("5678").dataDiskSize(10).setupStaticNat(false).overrideLoginPrivateKey(privKey);
        CloudStackComputeServiceAdapter adapter = (CloudStackComputeServiceAdapter)forKeyPair.getInstance(CloudStackComputeServiceAdapter.class);
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((String)((String)server.getCredentials().getOptionalPrivateKey().get()), (String)privKey);
    }

    public void testCreateNodeWithGroupEncodedIntoNameWithKeyPairGenerateSecurityGroup() throws IOException {
        HttpRequest deployVM = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deployVirtualMachine"}).addQueryParam("zoneid", new String[]{"2"}).addQueryParam("serviceofferingid", new String[]{"1"}).addQueryParam("templateid", new String[]{"241"}).addQueryParam("displayname", new String[]{"test-e92"}).addQueryParam("name", new String[]{"test-e92"}).addQueryParam("networkids", new String[]{"204"}).addQueryParam("group", new String[]{"test"}).addQueryParam("keypair", new String[]{"mykeypair"}).addQueryParam("securitygroupids", new String[]{"30"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"rz8V/tMk/UbxUhNqp7Bq3CrSg/k="}).addHeader("Accept", new String[]{"application/json"})).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listProjects, (Object)this.listProjectsResponse).put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksWithSecurityGroupsResponse).put((Object)this.getZoneWithSecurityGroups, (Object)this.getZoneWithSecurityGroupsResponse).put((Object)deployVM, (Object)this.deployVMResponse).put((Object)this.queryAsyncJobResult, (Object)this.queryAsyncJobResultSecurityGroupResponse).put((Object)this.queryAsyncJobResultAuthorizeIngress, (Object)this.queryAsyncJobResultAuthorizeIngressResponse).put((Object)this.getSecurityGroup, (Object)this.getSecurityGroupResponse).put((Object)this.createSecurityGroup, (Object)this.createSecurityGroupResponse).put((Object)this.authorizeIngress, (Object)this.authorizeIngressResponse).build();
        Injector forKeyPair = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        String privKey = Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/test"));
        Template template = ((TemplateBuilder)forKeyPair.getInstance(TemplateBuilder.class)).osFamily(OsFamily.CENTOS).locationId("2").build();
        ((CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class)).keyPair("mykeypair").setupStaticNat(false).generateSecurityGroup(true).overrideLoginPrivateKey(privKey);
        CloudStackComputeServiceAdapter adapter = (CloudStackComputeServiceAdapter)forKeyPair.getInstance(CloudStackComputeServiceAdapter.class);
        CloudStackContext context = (CloudStackContext)forKeyPair.getInstance(CloudStackContext.class);
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((String)((String)server.getCredentials().getOptionalPrivateKey().get()), (String)privKey);
    }

    public void testCreateNodeWithGroupEncodedIntoNameWithKeyPairAssignedToAccountAndDomain() throws IOException {
        HttpRequest deployVM = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deployVirtualMachine"}).addQueryParam("zoneid", new String[]{"1"}).addQueryParam("serviceofferingid", new String[]{"1"}).addQueryParam("templateid", new String[]{"4"}).addQueryParam("displayname", new String[]{"test-e92"}).addQueryParam("name", new String[]{"test-e92"}).addQueryParam("account", new String[]{"account"}).addQueryParam("domainid", new String[]{"domainId"}).addQueryParam("networkids", new String[]{"204"}).addQueryParam("group", new String[]{"test"}).addQueryParam("keypair", new String[]{"mykeypair"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"hGV6gZZakwvNKhTJurkm48+zgso="}).addHeader("Accept", new String[]{"application/json"})).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listProjects, (Object)this.listProjectsResponse).put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)this.getZone, (Object)this.getZoneResponse).put((Object)deployVM, (Object)this.deployVMResponse).put((Object)this.queryAsyncJobResult, (Object)this.queryAsyncJobResultResponse).build();
        Injector forKeyPair = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        String privKey = Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/test"));
        Template template = ((TemplateBuilder)forKeyPair.getInstance(TemplateBuilder.class)).osFamily(OsFamily.CENTOS).build();
        ((CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class)).keyPair("mykeypair").account("account").domainId("domainId").setupStaticNat(false).overrideLoginPrivateKey(privKey);
        CloudStackComputeServiceAdapter adapter = (CloudStackComputeServiceAdapter)forKeyPair.getInstance(CloudStackComputeServiceAdapter.class);
        CloudStackContext context = (CloudStackContext)forKeyPair.getInstance(CloudStackContext.class);
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((String)((String)server.getCredentials().getOptionalPrivateKey().get()), (String)privKey);
    }

    @Override
    protected Injector clientFrom(CloudStackContext context) {
        return context.utils().injector();
    }
}

