/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.extensions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Module;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.compute.functions.ZoneToLocationTest;
import org.jclouds.cloudstack.internal.BaseCloudStackComputeServiceContextExpectTest;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CloudStackSecurityGroupExtensionExpectTest")
public class CloudStackSecurityGroupExtensionExpectTest
extends BaseCloudStackComputeServiceContextExpectTest<ComputeService> {
    protected final HttpResponse addRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/authorizesecuritygroupingressresponse.json"))).build();
    protected final HttpResponse revokeRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/revokesecuritygroupingressresponse.json"))).build();
    protected final HttpRequest queryAsyncJobResultAuthorizeIngress = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"queryAsyncJobResult"}).addQueryParam("jobid", new String[]{"13330fc9-8b3e-4582-aa3e-90883c041010"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"y4gk3ckWAMPDNZM26LUK0gAhfiE="}).addHeader("Accept", new String[]{"application/json"})).build();
    protected final HttpResponse queryAsyncJobResultAuthorizeIngressResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/queryasyncjobresultresponse-authorizeingress.json"))).build();
    protected final HttpRequest getWithRule = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listSecurityGroups"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("id", new String[]{"13"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"TmlGaO2ICM+iXQr88+ZCyWUniSw="}).addHeader("Accept", new String[]{"application/json"})).build();
    protected final HttpResponse getEmptyResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse_extension_byid_empty.json"))).build();

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        overrides.setProperty("jclouds.zones", "MTV-Zone1");
        return overrides;
    }

    public void testListSecurityGroups() {
        HttpRequest listSecurityGroups = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listSecurityGroups"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"o+d8xxWT1Pa+I57SG2caFAblBYA="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse listSecurityGroupsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listsecuritygroupsresponse.json"))).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)this.getZone, (Object)this.getZoneResponse).put((Object)listSecurityGroups, (Object)listSecurityGroupsResponse).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap)).getSecurityGroupExtension().get();
        Set groups = extension.listSecurityGroups();
        Assert.assertEquals((int)groups.size(), (int)5);
    }

    public void testListSecurityGroupsForNode() {
        HttpRequest listSecurityGroups = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listSecurityGroups"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("virtualmachineid", new String[]{"some-node"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"x4f9fGMjIHXl5biaaFK5oOEONcg="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse listSecurityGroupsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listsecuritygroupsresponse.json"))).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)this.getZone, (Object)this.getZoneResponse).put((Object)listSecurityGroups, (Object)listSecurityGroupsResponse).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap)).getSecurityGroupExtension().get();
        Set groups = extension.listSecurityGroupsForNode("some-node");
        Assert.assertEquals((int)groups.size(), (int)5);
    }

    public void testGetSecurityGroupById() {
        HttpRequest listSecurityGroups = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listSecurityGroups"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("id", new String[]{"13"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"TmlGaO2ICM+iXQr88+ZCyWUniSw="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse listSecurityGroupsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse_extension_byid.json"))).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)this.getZone, (Object)this.getZoneResponse).put((Object)listSecurityGroups, (Object)listSecurityGroupsResponse).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap)).getSecurityGroupExtension().get();
        SecurityGroup group = extension.getSecurityGroupById("13");
        Assert.assertEquals((String)group.getId(), (String)"13");
        Assert.assertEquals((int)group.getIpPermissions().size(), (int)2);
    }

    public void testCreateSecurityGroup() {
        HttpRequest listSecurityGroups = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listSecurityGroups"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("securitygroupname", new String[]{"jclouds-test"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"zGp2rfHY6fBIGkgODRxyNzFfPFI="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse listSecurityGroupsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse.json"))).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)this.getZoneWithSecurityGroups, (Object)this.getZoneWithSecurityGroupsResponse).put((Object)listSecurityGroups, (Object)listSecurityGroupsResponse).put((Object)this.createSecurityGroup, (Object)this.createSecurityGroupResponse).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap)).getSecurityGroupExtension().get();
        SecurityGroup group = extension.createSecurityGroup("test", ZoneToLocationTest.two);
        Assert.assertEquals((String)group.getId(), (String)"30");
        Assert.assertEquals((int)group.getIpPermissions().size(), (int)0);
    }

    @Test(expectedExceptions={UncheckedExecutionException.class}, expectedExceptionsMessageRegExp="java.lang.IllegalArgumentException: .* does not support security groups")
    public void testCreateSecurityGroupBadZone() {
        HttpRequest listSecurityGroups = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listSecurityGroups"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("securitygroupname", new String[]{"jclouds-test"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"zGp2rfHY6fBIGkgODRxyNzFfPFI="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse listSecurityGroupsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse.json"))).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)this.getZone, (Object)this.getZoneResponse).put((Object)listSecurityGroups, (Object)listSecurityGroupsResponse).put((Object)this.createSecurityGroup, (Object)this.createSecurityGroupResponse).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap)).getSecurityGroupExtension().get();
        SecurityGroup group = extension.createSecurityGroup("test", ZoneToLocationTest.one);
        Assert.assertEquals((String)group.getId(), (String)"30");
        Assert.assertEquals((int)group.getIpPermissions().size(), (int)0);
    }

    public void testRemoveSecurityGroup() {
        HttpRequest listSecurityGroups = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listSecurityGroups"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("id", new String[]{"13"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"TmlGaO2ICM+iXQr88+ZCyWUniSw="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse listSecurityGroupsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse_extension_byid_empty.json"))).build();
        HttpRequest deleteSecurityGroup = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deleteSecurityGroup"}).addQueryParam("id", new String[]{"13"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"S1A2lYR/ibf4+HGFxVLdZvXZujQ="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse deleteSecurityGroupResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deletesecuritygroupresponse.json"))).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)listSecurityGroups, (Object)listSecurityGroupsResponse).put((Object)deleteSecurityGroup, (Object)deleteSecurityGroupResponse).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap)).getSecurityGroupExtension().get();
        Assert.assertTrue((boolean)extension.removeSecurityGroup("13"), (String)"Did not remove security group");
    }

    public void testRemoveSecurityGroupDoesNotExist() {
        HttpRequest listSecurityGroups = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listSecurityGroups"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("id", new String[]{"14"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"pWQ30A6l5qh4eaNypGwM9FoLnUM="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse listSecurityGroupsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse.json"))).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)listSecurityGroups, (Object)listSecurityGroupsResponse).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap)).getSecurityGroupExtension().get();
        Assert.assertFalse((boolean)extension.removeSecurityGroup("14"), (String)"Should not have found security group to remove");
    }

    public void testAddIpPermissionCidrFromIpPermission() {
        HttpRequest addRule = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"authorizeSecurityGroupIngress"}).addQueryParam("securitygroupid", new String[]{"13"}).addQueryParam("protocol", new String[]{"UDP"}).addQueryParam("startport", new String[]{"11"}).addQueryParam("endport", new String[]{"11"}).addQueryParam("cidrlist", new String[]{"1.1.1.1/24"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"XyokGNutHwcyU7KQVFZOTHvc4RY="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse getWithRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse_extension_byid_with_cidr.json"))).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.orderedRequestsSendResponses((List)ImmutableList.of((Object)addRule, (Object)this.queryAsyncJobResultAuthorizeIngress, (Object)this.getWithRule), (List)ImmutableList.of((Object)this.addRuleResponse, (Object)this.queryAsyncJobResultAuthorizeIngressResponse, (Object)getWithRuleResponse))).getSecurityGroupExtension().get();
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(IpProtocol.UDP);
        builder.fromPort(11);
        builder.toPort(11);
        builder.cidrBlock("1.1.1.1/24");
        IpPermission perm = builder.build();
        SecurityGroup origGroup = new SecurityGroupBuilder().id("13").build();
        SecurityGroup newGroup = extension.addIpPermission(perm, origGroup);
        Assert.assertEquals((int)1, (int)newGroup.getIpPermissions().size());
        IpPermission newPerm = (IpPermission)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions());
        Assert.assertNotNull((Object)newPerm);
        Assert.assertEquals((Object)newPerm.getIpProtocol(), (Object)IpProtocol.UDP);
        Assert.assertEquals((int)newPerm.getFromPort(), (int)11);
        Assert.assertEquals((int)newPerm.getToPort(), (int)11);
        Assert.assertEquals((int)newPerm.getCidrBlocks().size(), (int)1);
        Assert.assertTrue((boolean)newPerm.getCidrBlocks().contains("1.1.1.1/24"));
    }

    public void testAddIpPermissionCidrFromParams() {
        HttpRequest addRule = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"authorizeSecurityGroupIngress"}).addQueryParam("securitygroupid", new String[]{"13"}).addQueryParam("protocol", new String[]{"UDP"}).addQueryParam("startport", new String[]{"11"}).addQueryParam("endport", new String[]{"11"}).addQueryParam("cidrlist", new String[]{"1.1.1.1/24"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"XyokGNutHwcyU7KQVFZOTHvc4RY="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse getWithRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse_extension_byid_with_cidr.json"))).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.orderedRequestsSendResponses((List)ImmutableList.of((Object)addRule, (Object)this.queryAsyncJobResultAuthorizeIngress, (Object)this.getWithRule), (List)ImmutableList.of((Object)this.addRuleResponse, (Object)this.queryAsyncJobResultAuthorizeIngressResponse, (Object)getWithRuleResponse))).getSecurityGroupExtension().get();
        SecurityGroup origGroup = new SecurityGroupBuilder().id("13").build();
        SecurityGroup newGroup = extension.addIpPermission(IpProtocol.UDP, 11, 11, this.emptyMultimap(), (Iterable)ImmutableSet.of((Object)"1.1.1.1/24"), this.emptyStringSet(), origGroup);
        Assert.assertEquals((int)1, (int)newGroup.getIpPermissions().size());
        IpPermission newPerm = (IpPermission)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions());
        Assert.assertNotNull((Object)newPerm);
        Assert.assertEquals((Object)newPerm.getIpProtocol(), (Object)IpProtocol.UDP);
        Assert.assertEquals((int)newPerm.getFromPort(), (int)11);
        Assert.assertEquals((int)newPerm.getToPort(), (int)11);
        Assert.assertEquals((int)newPerm.getCidrBlocks().size(), (int)1);
        Assert.assertTrue((boolean)newPerm.getCidrBlocks().contains("1.1.1.1/24"));
    }

    public void testAddIpPermissionGroupFromIpPermission() {
        HttpRequest addRule = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"authorizeSecurityGroupIngress"}).addQueryParam("securitygroupid", new String[]{"13"}).addQueryParam("protocol", new String[]{"TCP"}).addQueryParam("startport", new String[]{"22"}).addQueryParam("endport", new String[]{"22"}).addQueryParam("usersecuritygrouplist[0].account", new String[]{"adrian"}).addQueryParam("usersecuritygrouplist[0].group", new String[]{"adriancole"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"v2OgKc2IftwX9pfKq2Pw/Z2xh9w="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse getWithRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse_extension_byid_with_group.json"))).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.orderedRequestsSendResponses((List)ImmutableList.of((Object)addRule, (Object)this.queryAsyncJobResultAuthorizeIngress, (Object)this.getWithRule), (List)ImmutableList.of((Object)this.addRuleResponse, (Object)this.queryAsyncJobResultAuthorizeIngressResponse, (Object)getWithRuleResponse))).getSecurityGroupExtension().get();
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(IpProtocol.TCP);
        builder.fromPort(22);
        builder.toPort(22);
        builder.tenantIdGroupNamePair("adrian", "adriancole");
        IpPermission perm = builder.build();
        SecurityGroup origGroup = new SecurityGroupBuilder().id("13").build();
        SecurityGroup newGroup = extension.addIpPermission(perm, origGroup);
        Assert.assertEquals((int)1, (int)newGroup.getIpPermissions().size());
        IpPermission newPerm = (IpPermission)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions());
        Assert.assertNotNull((Object)newPerm);
        Assert.assertEquals((Object)newPerm.getIpProtocol(), (Object)IpProtocol.TCP);
        Assert.assertEquals((int)newPerm.getFromPort(), (int)22);
        Assert.assertEquals((int)newPerm.getToPort(), (int)22);
        Assert.assertEquals((int)newPerm.getCidrBlocks().size(), (int)0);
        Assert.assertEquals((int)newPerm.getTenantIdGroupNamePairs().size(), (int)1);
        Assert.assertTrue((boolean)newPerm.getTenantIdGroupNamePairs().containsEntry((Object)"adrian", (Object)"adriancole"));
    }

    public void testAddIpPermissionGroupFromParams() {
        HttpRequest addRule = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"authorizeSecurityGroupIngress"}).addQueryParam("securitygroupid", new String[]{"13"}).addQueryParam("protocol", new String[]{"TCP"}).addQueryParam("startport", new String[]{"22"}).addQueryParam("endport", new String[]{"22"}).addQueryParam("usersecuritygrouplist[0].account", new String[]{"adrian"}).addQueryParam("usersecuritygrouplist[0].group", new String[]{"adriancole"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"v2OgKc2IftwX9pfKq2Pw/Z2xh9w="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse getWithRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse_extension_byid_with_group.json"))).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.orderedRequestsSendResponses((List)ImmutableList.of((Object)addRule, (Object)this.queryAsyncJobResultAuthorizeIngress, (Object)this.getWithRule), (List)ImmutableList.of((Object)this.addRuleResponse, (Object)this.queryAsyncJobResultAuthorizeIngressResponse, (Object)getWithRuleResponse))).getSecurityGroupExtension().get();
        ImmutableMultimap.Builder permBuilder = ImmutableMultimap.builder();
        permBuilder.put((Object)"adrian", (Object)"adriancole");
        SecurityGroup origGroup = new SecurityGroupBuilder().id("13").build();
        SecurityGroup newGroup = extension.addIpPermission(IpProtocol.TCP, 22, 22, (Multimap)permBuilder.build(), this.emptyStringSet(), this.emptyStringSet(), origGroup);
        Assert.assertEquals((int)1, (int)newGroup.getIpPermissions().size());
        IpPermission newPerm = (IpPermission)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions());
        Assert.assertNotNull((Object)newPerm);
        Assert.assertEquals((Object)newPerm.getIpProtocol(), (Object)IpProtocol.TCP);
        Assert.assertEquals((int)newPerm.getFromPort(), (int)22);
        Assert.assertEquals((int)newPerm.getToPort(), (int)22);
        Assert.assertEquals((int)newPerm.getCidrBlocks().size(), (int)0);
        Assert.assertEquals((int)newPerm.getTenantIdGroupNamePairs().size(), (int)1);
        Assert.assertTrue((boolean)newPerm.getTenantIdGroupNamePairs().containsEntry((Object)"adrian", (Object)"adriancole"));
    }

    public void testRemoveIpPermissionCidrFromIpPermission() {
        HttpRequest revokeRule = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"revokeSecurityGroupIngress"}).addQueryParam("id", new String[]{"6"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"H7cY/MEYGN7df1hiz0mMAFVBfa8="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse getWithRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse_extension_byid_with_cidr.json"))).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.orderedRequestsSendResponses((List)ImmutableList.of((Object)this.getWithRule, (Object)revokeRule, (Object)this.queryAsyncJobResultAuthorizeIngress, (Object)this.getWithRule), (List)ImmutableList.of((Object)getWithRuleResponse, (Object)this.revokeRuleResponse, (Object)this.queryAsyncJobResultAuthorizeIngressResponse, (Object)this.getEmptyResponse))).getSecurityGroupExtension().get();
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(IpProtocol.UDP);
        builder.fromPort(11);
        builder.toPort(11);
        builder.cidrBlock("1.1.1.1/24");
        IpPermission perm = builder.build();
        SecurityGroup origGroup = new SecurityGroupBuilder().id("13").build();
        SecurityGroup newGroup = extension.removeIpPermission(perm, origGroup);
        Assert.assertEquals((int)newGroup.getIpPermissions().size(), (int)0);
    }

    public void testRemoveIpPermissionCidrFromParams() {
        HttpRequest revokeRule = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"revokeSecurityGroupIngress"}).addQueryParam("id", new String[]{"6"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"H7cY/MEYGN7df1hiz0mMAFVBfa8="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse getWithRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse_extension_byid_with_cidr.json"))).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.orderedRequestsSendResponses((List)ImmutableList.of((Object)this.getWithRule, (Object)revokeRule, (Object)this.queryAsyncJobResultAuthorizeIngress, (Object)this.getWithRule), (List)ImmutableList.of((Object)getWithRuleResponse, (Object)this.revokeRuleResponse, (Object)this.queryAsyncJobResultAuthorizeIngressResponse, (Object)this.getEmptyResponse))).getSecurityGroupExtension().get();
        SecurityGroup origGroup = new SecurityGroupBuilder().id("13").build();
        SecurityGroup newGroup = extension.removeIpPermission(IpProtocol.UDP, 11, 11, this.emptyMultimap(), (Iterable)ImmutableSet.of((Object)"1.1.1.1/24"), this.emptyStringSet(), origGroup);
        Assert.assertEquals((int)newGroup.getIpPermissions().size(), (int)0);
    }

    public void testRemoveIpPermissionGroupFromIpPermission() {
        HttpRequest revokeRule = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"revokeSecurityGroupIngress"}).addQueryParam("id", new String[]{"5"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"bEzvrLtO7aEWkIqJgUeTnd+0XbY="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse getWithRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse_extension_byid_with_group.json"))).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.orderedRequestsSendResponses((List)ImmutableList.of((Object)this.getWithRule, (Object)revokeRule, (Object)this.queryAsyncJobResultAuthorizeIngress, (Object)this.getWithRule), (List)ImmutableList.of((Object)getWithRuleResponse, (Object)this.revokeRuleResponse, (Object)this.queryAsyncJobResultAuthorizeIngressResponse, (Object)this.getEmptyResponse))).getSecurityGroupExtension().get();
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(IpProtocol.TCP);
        builder.fromPort(22);
        builder.toPort(22);
        builder.tenantIdGroupNamePair("adrian", "adriancole");
        IpPermission perm = builder.build();
        SecurityGroup origGroup = new SecurityGroupBuilder().id("13").build();
        SecurityGroup newGroup = extension.removeIpPermission(perm, origGroup);
        Assert.assertEquals((int)newGroup.getIpPermissions().size(), (int)0);
    }

    public void testRemoveIpPermissionGroupFromParams() {
        HttpRequest revokeRule = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"revokeSecurityGroupIngress"}).addQueryParam("id", new String[]{"5"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"bEzvrLtO7aEWkIqJgUeTnd+0XbY="}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse getWithRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getsecuritygroupresponse_extension_byid_with_group.json"))).build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.orderedRequestsSendResponses((List)ImmutableList.of((Object)this.getWithRule, (Object)revokeRule, (Object)this.queryAsyncJobResultAuthorizeIngress, (Object)this.getWithRule), (List)ImmutableList.of((Object)getWithRuleResponse, (Object)this.revokeRuleResponse, (Object)this.queryAsyncJobResultAuthorizeIngressResponse, (Object)this.getEmptyResponse))).getSecurityGroupExtension().get();
        ImmutableMultimap.Builder permBuilder = ImmutableMultimap.builder();
        permBuilder.put((Object)"adrian", (Object)"adriancole");
        SecurityGroup origGroup = new SecurityGroupBuilder().id("13").build();
        SecurityGroup newGroup = extension.removeIpPermission(IpProtocol.TCP, 22, 22, (Multimap)permBuilder.build(), this.emptyStringSet(), this.emptyStringSet(), origGroup);
        Assert.assertEquals((int)newGroup.getIpPermissions().size(), (int)0);
    }

    @Override
    public ComputeService createClient(Function<HttpRequest, HttpResponse> fn, Module module, Properties props) {
        return this.clientFrom((CloudStackContext)this.createInjector(fn, module, props).getInstance(CloudStackContext.class));
    }

    @Override
    protected ComputeService clientFrom(CloudStackContext context) {
        return context.getComputeService();
    }

    private Multimap<String, String> emptyMultimap() {
        return LinkedHashMultimap.create();
    }

    private Set<String> emptyStringSet() {
        return Sets.newLinkedHashSet();
    }
}

