/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.options;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.collections.Maps;

@Test(groups={"unit"}, testName="CloudStackTemplateOptionsTest")
public class CloudStackTemplateOptionsTest {
    @Test
    public void testAs() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        Assert.assertEquals((Object)options.as(CloudStackTemplateOptions.class), (Object)options);
    }

    @Test
    public void testDefaultSecurityGroupIds() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getSecurityGroupIds(), (Set)ImmutableSet.of());
    }

    @Test
    public void testSecurityGroupIds() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().securityGroupIds((Iterable)ImmutableSet.of((Object)"3"));
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getSecurityGroupIds(), (Set)ImmutableSet.of((Object)"3"));
    }

    @Test
    public void testSecurityGroupIdsStatic() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.securityGroupIds((Iterable)ImmutableSet.of((Object)"3"));
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getSecurityGroupIds(), (Set)ImmutableSet.of((Object)"3"));
    }

    @Test
    public void testGenerateSecurityGroupDefaultsFalse() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        Assert.assertFalse((boolean)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).shouldGenerateSecurityGroup());
    }

    @Test
    public void testGenerateSecurityGroup() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().generateSecurityGroup(true);
        Assert.assertTrue((boolean)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).shouldGenerateSecurityGroup());
    }

    @Test
    public void testGenerateSecurityGroupStatic() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.generateSecurityGroup((boolean)true);
        Assert.assertTrue((boolean)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).shouldGenerateSecurityGroup());
    }

    @Test
    public void testDefaultNetworkIds() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getNetworks(), (Set)ImmutableSet.of());
    }

    @Test
    public void testNetworkId() {
        TemplateOptions options = new CloudStackTemplateOptions().networks(new String[]{"3"});
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getNetworks(), (Set)ImmutableSet.of((Object)"3"));
    }

    @Test
    public void testIpOnDefaultNetwork() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().ipOnDefaultNetwork("10.0.0.1");
        Assert.assertEquals((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getIpOnDefaultNetwork(), (String)"10.0.0.1");
    }

    @Test
    public void testIpOnDefaultNetworkStatic() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.ipOnDefaultNetwork((String)"10.0.0.1");
        Assert.assertEquals((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getIpOnDefaultNetwork(), (String)"10.0.0.1");
    }

    @Test
    public void testIpsToNetwork() {
        Map ipsToNetworks = Maps.newHashMap();
        ipsToNetworks.put("10.0.0.1", "5");
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().ipsToNetworks(ipsToNetworks);
        Assert.assertEquals((String)((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getIpsToNetworks().get("10.0.0.1")), (String)"5");
    }

    @Test
    public void testIpsToNetworkStatic() {
        Map ipsToNetworks = Maps.newHashMap();
        ipsToNetworks.put("10.0.0.1", "5");
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.ipsToNetworks((Map)ipsToNetworks);
        Assert.assertEquals((String)((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getIpsToNetworks().get("10.0.0.1")), (String)"5");
    }

    @Test
    public void testSetupStaticNatDefaultsTrue() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        Assert.assertTrue((boolean)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).shouldSetupStaticNat());
    }

    @Test
    public void testSetupStaticNat() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().setupStaticNat(false);
        Assert.assertFalse((boolean)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).shouldSetupStaticNat());
    }

    @Test
    public void testSetupStaticNatStatic() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.setupStaticNat((boolean)false);
        Assert.assertFalse((boolean)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).shouldSetupStaticNat());
    }

    @Test
    public void testGenerateKeyPairDefaultsFalse() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        Assert.assertFalse((boolean)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).shouldGenerateKeyPair());
    }

    @Test
    public void testGenerateKeyPair() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().generateKeyPair(true);
        Assert.assertTrue((boolean)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).shouldGenerateKeyPair());
    }

    @Test
    public void testGenerateKeyPairStatic() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.generateKeyPair((boolean)true);
        Assert.assertTrue((boolean)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).shouldGenerateKeyPair());
    }

    @Test
    public void testKeyPair() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.keyPair((String)"test");
        Assert.assertEquals((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getKeyPair(), (String)"test");
    }

    @Test
    public void testDiskOfferingId() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.diskOfferingId((String)"test");
        Assert.assertEquals((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getDiskOfferingId(), (String)"test");
    }

    @Test
    public void testDataDiskSizeDefault() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        Assert.assertEquals((int)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getDataDiskSize(), (int)0);
    }

    @Test
    public void testDataDiskSize() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.dataDiskSize((int)10);
        Assert.assertEquals((int)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getDataDiskSize(), (int)10);
    }

    @Test
    public void testAccount() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.account((String)"test");
        Assert.assertEquals((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getAccount(), (String)"test");
    }

    @Test
    public void testDomainId() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.domainId((String)"test");
        Assert.assertEquals((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getDomainId(), (String)"test");
    }
}

