/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.AssociateIPAddressOptions;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.jclouds.cloudstack.options.ListPublicIPAddressesOptions;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="AddressApiLiveTest")
public class AddressApiLiveTest
extends BaseCloudStackApiLiveTest {
    private boolean networksEnabled;
    private PublicIPAddress ip = null;

    @BeforeGroups(groups={"live"})
    void networksEnabled() {
        this.networksEnabled = !this.client.getNetworkApi().listNetworks(new ListNetworksOptions[0]).isEmpty();
    }

    public void testAssociateDisassociatePublicIPAddress() throws Exception {
        if (!this.networksEnabled) {
            return;
        }
        AsyncCreateResponse job = this.client.getAddressApi().associateIPAddressInZone(((Network)Iterables.get((Iterable)this.client.getNetworkApi().listNetworks(new ListNetworksOptions[0]), (int)0)).getZoneId(), new AssociateIPAddressOptions[0]);
        Preconditions.checkState((boolean)this.jobComplete.apply((Object)job.getJobId()), (String)"job %s failed to complete", (Object[])new Object[]{job.getJobId()});
        this.ip = (PublicIPAddress)this.client.getAsyncJobApi().getAsyncJob(job.getJobId()).getResult();
        this.checkIP(this.ip);
    }

    @AfterGroups(groups={"live"})
    protected void tearDownContext() {
        if (this.ip != null) {
            this.client.getAddressApi().disassociateIPAddress(this.ip.getId());
        }
        super.tearDownContext();
    }

    public void testListPublicIPAddresss() throws Exception {
        if (!this.networksEnabled) {
            return;
        }
        Set response = this.client.getAddressApi().listPublicIPAddresses(new ListPublicIPAddressesOptions[0]);
        assert (null != response);
        Assert.assertTrue((response.size() > 0 ? 1 : 0) != 0);
        for (PublicIPAddress ip : response) {
            PublicIPAddress newDetails = (PublicIPAddress)Iterables.getOnlyElement((Iterable)this.client.getAddressApi().listPublicIPAddresses(new ListPublicIPAddressesOptions[]{ListPublicIPAddressesOptions.Builder.id((String)ip.getId())}));
            Assert.assertEquals((String)ip.getId(), (String)newDetails.getId());
            this.checkIP(ip);
        }
    }

    protected void checkIP(PublicIPAddress ip) {
        Assert.assertEquals((String)ip.getId(), (String)this.client.getAddressApi().getPublicIPAddress(ip.getId()).getId());
        assert (ip.getId() != null) : ip;
        assert (ip.getAccount() != null) : ip;
        assert (ip.getDomain() != null) : ip;
        assert (ip.getDomainId() != null) : ip;
        assert (ip.getState() != null) : ip;
        assert (ip.getZoneId() != null) : ip;
        assert (ip.getZoneName() != null) : ip;
    }
}

