/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.features.AddressApi;
import org.jclouds.cloudstack.functions.CloudStackFallbacks;
import org.jclouds.cloudstack.internal.BaseCloudStackApiTest;
import org.jclouds.cloudstack.options.AssociateIPAddressOptions;
import org.jclouds.cloudstack.options.ListPublicIPAddressesOptions;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AddressApiTest")
public class AddressApiTest
extends BaseCloudStackApiTest<AddressApi> {
    public void testListPublicIPAddresses() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AddressApi.class, (String)"listPublicIPAddresses", (Class[])new Class[]{ListPublicIPAddressesOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listPublicIpAddresses&listAll=true HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListPublicIPAddressesOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AddressApi.class, (String)"listPublicIPAddresses", (Class[])new Class[]{ListPublicIPAddressesOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListPublicIPAddressesOptions.Builder.accountInDomain((String)"adrian", (String)"6").usesVirtualNetwork(true)));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listPublicIpAddresses&listAll=true&account=adrian&domainid=6&forvirtualnetwork=true HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetPublicIPAddress() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AddressApi.class, (String)"getPublicIPAddress", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)5));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listPublicIpAddresses&listAll=true&id=5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, Functions.compose((Function)IdentityFunction.INSTANCE, (Function)IdentityFunction.INSTANCE).getClass());
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testAssociateIPAddressInZone() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AddressApi.class, (String)"associateIPAddressInZone", (Class[])new Class[]{String.class, AssociateIPAddressOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)6));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=associateIpAddress&zoneid=6 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDisassociateIPAddress() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AddressApi.class, (String)"disassociateIPAddress", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)5));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=disassociateIpAddress&id=5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, CloudStackFallbacks.VoidOnNotFoundOr404OrUnableToFindAccountOwner.class);
        this.checkFilters((HttpRequest)httpRequest);
    }
}

