/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Set;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.ListAsyncJobsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="AsyncJobApiLiveTest")
public class AsyncJobApiLiveTest
extends BaseCloudStackApiLiveTest {
    @Test(enabled=true)
    public void testListAsyncJobs() throws Exception {
        Set response = this.client.getAsyncJobApi().listAsyncJobs(new ListAsyncJobsOptions[0]);
        assert (null != response);
        long asyncJobCount = response.size();
        Assert.assertTrue((asyncJobCount >= 0L ? 1 : 0) != 0);
        for (AsyncJob asyncJob : response) {
            assert (asyncJob.getCmd() != null) : asyncJob;
            assert (asyncJob.getUserId() != null) : asyncJob;
            this.checkJob(asyncJob);
            AsyncJob query = this.client.getAsyncJobApi().getAsyncJob(asyncJob.getId());
            Assert.assertEquals((String)query.getId(), (String)asyncJob.getId());
            assert (query.getResultType() != null) : query;
            this.checkJob(query);
        }
    }

    private void checkJob(AsyncJob<?> query) {
        assert (query.getStatus().code() >= 0) : query;
        assert (query.getResultCode().code() >= 0) : query;
        assert (query.getProgress() >= 0) : query;
        if (query.getResultCode() == AsyncJob.ResultCode.SUCCESS) {
            if (query.getResult() != null) {
                Assert.assertEquals((Object)query.getResult().getClass().getPackage(), (Object)AsyncJob.class.getPackage());
            }
        } else if (query.getResultCode() == AsyncJob.ResultCode.FAIL) {
            assert (query.getResult() == null) : query;
            assert (query.getError() != null) : query;
        } else assert (query.getResult() == null) : query;
    }
}

