/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.PortForwardingRule;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.features.VirtualMachineApiLiveTest;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.CreateFirewallRuleOptions;
import org.jclouds.cloudstack.options.ListEgressFirewallRulesOptions;
import org.jclouds.cloudstack.options.ListFirewallRulesOptions;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.jclouds.cloudstack.options.ListPortForwardingRulesOptions;
import org.jclouds.cloudstack.predicates.NetworkPredicates;
import org.jclouds.logging.Logger;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="FirewallApiLiveTest")
public class FirewallApiLiveTest
extends BaseCloudStackApiLiveTest {
    private PublicIPAddress ip = null;
    private VirtualMachine vm;
    private FirewallRule firewallRule;
    private FirewallRule egressFirewallRule;
    private PortForwardingRule portForwardingRule;
    private Network network;
    private boolean networksDisabled;

    @Override
    @BeforeGroups(groups={"live"})
    public void setupContext() {
        super.setupContext();
        this.prefix = this.prefix + "rule";
        try {
            this.network = (Network)Iterables.find((Iterable)this.client.getNetworkApi().listNetworks(new ListNetworksOptions[0]), (Predicate)Predicates.and((Predicate)NetworkPredicates.supportsPortForwarding(), (Predicate)new Predicate<Network>(){

                public boolean apply(Network network) {
                    return network.isDefault() && !network.isSecurityGroupEnabled() && network.getAccount().equals(FirewallApiLiveTest.this.user.getAccount());
                }
            }));
            String defaultTemplate = this.templateBuilderSpec != null ? this.templateBuilderSpec.getImageId() : null;
            this.vm = VirtualMachineApiLiveTest.createVirtualMachineInNetwork(this.network, FirewallApiLiveTest.defaultTemplateOrPreferredInZone(defaultTemplate, this.client, this.network.getZoneId()), this.client, (Predicate<String>)this.jobComplete, (Predicate<VirtualMachine>)this.virtualMachineRunning);
            if (this.vm.getPassword() != null && !this.loginCredentials.getOptionalPassword().isPresent()) {
                this.loginCredentials = this.loginCredentials.toBuilder().password(this.vm.getPassword()).build();
            }
        }
        catch (NoSuchElementException e) {
            this.networksDisabled = true;
        }
    }

    public void testCreatePortForwardingRule() throws Exception {
        if (this.networksDisabled) {
            return;
        }
        while (this.portForwardingRule == null) {
            this.ip = this.reuseOrAssociate.apply(this.network);
            try {
                AsyncCreateResponse job = this.client.getFirewallApi().createPortForwardingRuleForVirtualMachine(this.ip.getId(), PortForwardingRule.Protocol.TCP, 22, this.vm.getId(), 22);
                Assert.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
                this.portForwardingRule = this.client.getFirewallApi().getPortForwardingRule(job.getId());
            }
            catch (IllegalStateException e) {
                Logger.CONSOLE.error("Failed while trying to allocate ip: " + e, new Object[0]);
            }
        }
        Assert.assertEquals((String)this.portForwardingRule.getIPAddressId(), (String)this.ip.getId());
        Assert.assertEquals((String)this.portForwardingRule.getVirtualMachineId(), (String)this.vm.getId());
        Assert.assertEquals((int)this.portForwardingRule.getPublicPort(), (int)22);
        Assert.assertEquals((Object)this.portForwardingRule.getProtocol(), (Object)PortForwardingRule.Protocol.TCP);
        this.checkPortForwardingRule(this.portForwardingRule);
        this.checkSSH(HostAndPort.fromParts((String)this.ip.getIPAddress(), (int)22));
    }

    @Test(dependsOnMethods={"testCreatePortForwardingRule"})
    public void testListPortForwardingRules() throws Exception {
        Set response = this.client.getFirewallApi().listPortForwardingRules(new ListPortForwardingRulesOptions[0]);
        assert (null != response);
        Assert.assertTrue((response.size() > 0 ? 1 : 0) != 0);
        for (PortForwardingRule rule : response) {
            this.checkPortForwardingRule(rule);
        }
    }

    @Test(dependsOnMethods={"testCreatePortForwardingRule"})
    public void testCreateFirewallRule() {
        if (this.networksDisabled) {
            return;
        }
        AsyncCreateResponse job = this.client.getFirewallApi().createFirewallRuleForIpAndProtocol(this.ip.getId(), FirewallRule.Protocol.TCP, new CreateFirewallRuleOptions[]{CreateFirewallRuleOptions.Builder.startPort((int)30).endPort(35)});
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
        this.firewallRule = this.client.getFirewallApi().getFirewallRule(job.getId());
        Assert.assertEquals((int)this.firewallRule.getStartPort(), (int)30);
        Assert.assertEquals((int)this.firewallRule.getEndPort(), (int)35);
        Assert.assertEquals((Object)this.firewallRule.getProtocol(), (Object)FirewallRule.Protocol.TCP);
        this.checkFirewallRule(this.firewallRule);
    }

    @Test(dependsOnMethods={"testCreateFirewallRule"})
    public void testListFirewallRules() {
        Set rules = this.client.getFirewallApi().listFirewallRules(new ListFirewallRulesOptions[0]);
        assert (rules != null);
        Assert.assertTrue((!rules.isEmpty() ? 1 : 0) != 0);
        for (FirewallRule rule : rules) {
            this.checkFirewallRule(rule);
        }
    }

    @Test(dependsOnMethods={"testCreatePortForwardingRule"})
    public void testCreateEgressFirewallRule() {
        if (this.networksDisabled) {
            return;
        }
        AsyncCreateResponse job = this.client.getFirewallApi().createEgressFirewallRuleForNetworkAndProtocol(this.network.getId(), FirewallRule.Protocol.TCP, new CreateFirewallRuleOptions[]{CreateFirewallRuleOptions.Builder.startPort((int)30).endPort(35)});
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
        this.egressFirewallRule = this.client.getFirewallApi().getEgressFirewallRule(job.getId());
        Assert.assertEquals((int)this.egressFirewallRule.getStartPort(), (int)30);
        Assert.assertEquals((int)this.egressFirewallRule.getEndPort(), (int)35);
        Assert.assertEquals((Object)this.egressFirewallRule.getProtocol(), (Object)FirewallRule.Protocol.TCP);
        this.checkEgressFirewallRule(this.egressFirewallRule);
    }

    @Test(dependsOnMethods={"testCreateEgressFirewallRule"})
    public void testListEgressFirewallRules() {
        Set rules = this.client.getFirewallApi().listEgressFirewallRules(new ListEgressFirewallRulesOptions[0]);
        assert (rules != null);
        Assert.assertTrue((!rules.isEmpty() ? 1 : 0) != 0);
        for (FirewallRule rule : rules) {
            this.checkEgressFirewallRule(rule);
        }
    }

    @AfterGroups(groups={"live"})
    protected void tearDownContext() {
        if (this.firewallRule != null) {
            this.client.getFirewallApi().deleteFirewallRule(this.firewallRule.getId());
        }
        if (this.egressFirewallRule != null) {
            this.client.getFirewallApi().deleteEgressFirewallRule(this.egressFirewallRule.getId());
        }
        if (this.portForwardingRule != null) {
            this.client.getFirewallApi().deletePortForwardingRule(this.portForwardingRule.getId());
        }
        if (this.vm != null) {
            this.jobComplete.apply((Object)this.client.getVirtualMachineApi().destroyVirtualMachine(this.vm.getId()));
        }
        if (this.ip != null) {
            this.client.getAddressApi().disassociateIPAddress(this.ip.getId());
        }
        super.tearDownContext();
    }

    protected void checkFirewallRule(FirewallRule rule) {
        Assert.assertEquals((Object)rule, (Object)this.client.getFirewallApi().getFirewallRule(rule.getId()));
        assert (rule.getId() != null) : rule;
        assert (rule.getStartPort() > 0) : rule;
        assert (rule.getEndPort() >= rule.getStartPort()) : rule;
        assert (rule.getProtocol() != null);
    }

    protected void checkEgressFirewallRule(FirewallRule rule) {
        Assert.assertEquals((Object)rule, (Object)this.client.getFirewallApi().getEgressFirewallRule(rule.getId()));
        assert (rule.getId() != null) : rule;
        assert (rule.getStartPort() > 0) : rule;
        assert (rule.getEndPort() >= rule.getStartPort()) : rule;
        assert (rule.getProtocol() != null);
    }

    protected void checkPortForwardingRule(PortForwardingRule rule) {
        Assert.assertEquals((Object)rule, (Object)this.client.getFirewallApi().getPortForwardingRule(rule.getId()));
        assert (rule.getId() != null) : rule;
        assert (rule.getIPAddress() != null) : rule;
        assert (rule.getIPAddressId() != null) : rule;
        assert (rule.getPrivatePort() > 0) : rule;
        assert (rule.getProtocol() != null) : rule;
        assert (rule.getPublicPort() > 0) : rule;
        assert (rule.getState() != null) : rule;
        assert (rule.getVirtualMachineId() != null) : rule;
        assert (rule.getVirtualMachineName() != null) : rule;
    }
}

