/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.cloudstack.domain.DiskOffering;
import org.jclouds.cloudstack.domain.NetworkOffering;
import org.jclouds.cloudstack.domain.NetworkOfferingAvailabilityType;
import org.jclouds.cloudstack.domain.ServiceOffering;
import org.jclouds.cloudstack.domain.StorageType;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.CreateDiskOfferingOptions;
import org.jclouds.cloudstack.options.CreateServiceOfferingOptions;
import org.jclouds.cloudstack.options.ListNetworkOfferingsOptions;
import org.jclouds.cloudstack.options.UpdateDiskOfferingOptions;
import org.jclouds.cloudstack.options.UpdateNetworkOfferingOptions;
import org.jclouds.cloudstack.options.UpdateServiceOfferingOptions;
import org.jclouds.logging.Logger;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalOfferingApiLiveTest")
public class GlobalOfferingApiLiveTest
extends BaseCloudStackApiLiveTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"live"}, enabled=true)
    public void testCreateServiceOffering() throws Exception {
        this.skipIfNotGlobalAdmin();
        String name = this.prefix + "-test-create-service-offering";
        String displayText = name + "-display";
        ServiceOffering offering = null;
        try {
            offering = this.globalAdminClient.getOfferingApi().createServiceOffering(name, displayText, 2, 1024, 2048, new CreateServiceOfferingOptions[]{CreateServiceOfferingOptions.Builder.highlyAvailable((boolean)true).storageType(StorageType.LOCAL)});
            Logger.CONSOLE.info("Created Service Offering: " + offering, new Object[0]);
            Assert.assertEquals((String)offering.getName(), (String)name);
            Assert.assertEquals((String)offering.getDisplayText(), (String)displayText);
            this.checkServiceOffering(offering);
            offering = this.globalAdminClient.getOfferingApi().updateServiceOffering(offering.getId(), new UpdateServiceOfferingOptions[]{UpdateServiceOfferingOptions.Builder.name((String)(name + "-2")).displayText(displayText + "-2")});
            Assert.assertEquals((String)offering.getName(), (String)(name + "-2"));
            Assert.assertEquals((String)offering.getDisplayText(), (String)(displayText + "-2"));
            this.checkServiceOffering(offering);
        }
        finally {
            if (offering != null) {
                this.globalAdminClient.getOfferingApi().deleteServiceOffering(offering.getId());
            }
        }
    }

    private void checkServiceOffering(ServiceOffering offering) {
        Assert.assertNotNull((Object)offering.getId());
        Assert.assertEquals((int)offering.getCpuNumber(), (int)2);
        Assert.assertEquals((int)offering.getCpuSpeed(), (int)1024);
        Assert.assertEquals((int)offering.getMemory(), (int)2048);
        Assert.assertTrue((boolean)offering.supportsHA());
        Assert.assertEquals((Object)offering.getStorageType(), (Object)StorageType.LOCAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"live"}, enabled=true)
    public void testCreateDiskOffering() throws Exception {
        this.skipIfNotGlobalAdmin();
        String name = this.prefix + "-test-create-disk-offering";
        String displayText = name + "-display";
        DiskOffering offering = null;
        try {
            offering = this.globalAdminClient.getOfferingApi().createDiskOffering(name, displayText, new CreateDiskOfferingOptions[]{CreateDiskOfferingOptions.Builder.diskSizeInGB((int)100).customized(true).tags((Set)ImmutableSet.of((Object)"dummy-tag"))});
            Assert.assertEquals((String)offering.getName(), (String)name);
            Assert.assertEquals((String)offering.getDisplayText(), (String)displayText);
            this.checkDiskOffering(offering);
            offering = this.globalAdminClient.getOfferingApi().updateDiskOffering(offering.getId(), new UpdateDiskOfferingOptions[]{UpdateDiskOfferingOptions.Builder.name((String)(name + "-2")).displayText(displayText + "-2")});
            Assert.assertEquals((String)offering.getName(), (String)(name + "-2"));
            Assert.assertEquals((String)offering.getDisplayText(), (String)(displayText + "-2"));
            this.checkDiskOffering(offering);
        }
        finally {
            if (offering != null) {
                this.globalAdminClient.getOfferingApi().deleteDiskOffering(offering.getId());
            }
        }
    }

    private void checkDiskOffering(DiskOffering offering) {
        Assert.assertTrue((boolean)offering.isCustomized());
        Assert.assertEquals((int)offering.getDiskSize(), (int)100);
        Assert.assertTrue((boolean)offering.getTags().contains("dummy-tag"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"live"}, enabled=true)
    public void testUpdateNetworkOffering() throws Exception {
        this.skipIfNotGlobalAdmin();
        NetworkOffering offering = (NetworkOffering)Iterables.getFirst((Iterable)this.globalAdminClient.getOfferingApi().listNetworkOfferings(new ListNetworkOfferingsOptions[0]), null);
        Assert.assertNotNull((Object)offering, (String)"Unable to test, no network offering found.");
        String name = offering.getName();
        NetworkOfferingAvailabilityType availability = offering.getAvailability();
        try {
            NetworkOfferingAvailabilityType newValue = NetworkOfferingAvailabilityType.OPTIONAL;
            if (availability == NetworkOfferingAvailabilityType.OPTIONAL) {
                newValue = NetworkOfferingAvailabilityType.REQUIRED;
            }
            NetworkOffering updated = this.globalAdminClient.getOfferingApi().updateNetworkOffering(offering.getId(), new UpdateNetworkOfferingOptions[]{UpdateNetworkOfferingOptions.Builder.name((String)(this.prefix + name)).availability(newValue)});
            Assert.assertEquals((String)updated.getName(), (String)(this.prefix + name));
            Assert.assertEquals((Object)updated.getAvailability(), (Object)newValue);
        }
        catch (Throwable throwable) {
            this.globalAdminClient.getOfferingApi().updateNetworkOffering(offering.getId(), new UpdateNetworkOfferingOptions[]{UpdateNetworkOfferingOptions.Builder.name((String)name).availability(availability)});
            throw throwable;
        }
        this.globalAdminClient.getOfferingApi().updateNetworkOffering(offering.getId(), new UpdateNetworkOfferingOptions[]{UpdateNetworkOfferingOptions.Builder.name((String)name).availability(availability)});
    }
}

