/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.util.List;
import org.jclouds.cloudstack.features.GlobalStoragePoolApi;
import org.jclouds.cloudstack.internal.BaseCloudStackApiTest;
import org.jclouds.cloudstack.options.ListStoragePoolsOptions;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalStoragePoolApiTest")
public class GlobalStoragePoolApiTest
extends BaseCloudStackApiTest<GlobalStoragePoolApi> {
    public void testListStoragePools() throws NoSuchMethodException {
        Invokable method = Reflection2.method(GlobalStoragePoolApi.class, (String)"listStoragePools", (Class[])new Class[]{ListStoragePoolsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listStoragePools&listAll=true HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListStoragePoolsOptions() throws NoSuchMethodException {
        Invokable method = Reflection2.method(GlobalStoragePoolApi.class, (String)"listStoragePools", (Class[])new Class[]{ListStoragePoolsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListStoragePoolsOptions.Builder.clusterId((String)"3").id("4").ipAddress("192.168.42.42").keyword("fred").name("bob").path("/mnt/store42").podId("4").zoneId("5")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listStoragePools&listAll=true&clusterid=3&id=4&ipaddress=192.168.42.42&keyword=fred&name=bob&path=/mnt/store42&podid=4&zoneid=5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }
}

