/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.features.SecurityGroupApi;
import org.jclouds.cloudstack.internal.BaseCloudStackApiTest;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.ListSecurityGroupsOptions;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SecurityGroupApiTest")
public class SecurityGroupApiTest
extends BaseCloudStackApiTest<SecurityGroupApi> {
    HttpRequest authorizeSecurityGroupIngress3 = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"authorizeSecurityGroupIngress"}).addQueryParam("securitygroupid", new String[]{"2"}).addQueryParam("protocol", new String[]{"tcp"}).addQueryParam("startport", new String[]{"22"}).addQueryParam("endport", new String[]{"22"}).addQueryParam("cidrlist", new String[]{"1.1.1.1/24,1.2.2.2/16"}).build();
    HttpRequest authorizeSecurityGroupIngress4 = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"authorizeSecurityGroupIngress"}).addQueryParam("securitygroupid", new String[]{"2"}).addQueryParam("protocol", new String[]{"tcp"}).addQueryParam("startport", new String[]{"22"}).addQueryParam("endport", new String[]{"22"}).addQueryParam("usersecuritygrouplist[0].account", new String[]{"adrian"}).addQueryParam("usersecuritygrouplist[0].group", new String[]{"group1"}).addQueryParam("usersecuritygrouplist[1].account", new String[]{"adrian"}).addQueryParam("usersecuritygrouplist[1].group", new String[]{"group2"}).addQueryParam("usersecuritygrouplist[2].account", new String[]{"bob"}).addQueryParam("usersecuritygrouplist[2].group", new String[]{"group1"}).build();
    HttpRequest authorizeSecurityGroupIngress1 = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"authorizeSecurityGroupIngress"}).addQueryParam("protocol", new String[]{"ICMP"}).addQueryParam("securitygroupid", new String[]{"2"}).addQueryParam("icmpcode", new String[]{"22"}).addQueryParam("icmptype", new String[]{"22"}).addQueryParam("cidrlist", new String[]{"1.1.1.1/24,1.2.2.2/16"}).build();
    HttpRequest authorizeSecurityGroupIngress2 = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"authorizeSecurityGroupIngress"}).addQueryParam("protocol", new String[]{"ICMP"}).addQueryParam("securitygroupid", new String[]{"2"}).addQueryParam("icmpcode", new String[]{"22"}).addQueryParam("icmptype", new String[]{"22"}).addQueryParam("usersecuritygrouplist[0].account", new String[]{"adrian"}).addQueryParam("usersecuritygrouplist[0].group", new String[]{"group1"}).addQueryParam("usersecuritygrouplist[1].account", new String[]{"adrian"}).addQueryParam("usersecuritygrouplist[1].group", new String[]{"group2"}).addQueryParam("usersecuritygrouplist[2].account", new String[]{"bob"}).addQueryParam("usersecuritygrouplist[2].group", new String[]{"group1"}).build();

    public void testListSecurityGroups() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupApi.class, (String)"listSecurityGroups", (Class[])new Class[]{ListSecurityGroupsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listSecurityGroups&listAll=true HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListSecurityGroupsOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupApi.class, (String)"listSecurityGroups", (Class[])new Class[]{ListSecurityGroupsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListSecurityGroupsOptions.Builder.virtualMachineId((String)"4").domainId("5").id("6")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listSecurityGroups&listAll=true&virtualmachineid=4&domainid=5&id=6 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetSecurityGroup() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupApi.class, (String)"getSecurityGroup", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)5));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listSecurityGroups&listAll=true&id=5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, Functions.compose((Function)IdentityFunction.INSTANCE, (Function)IdentityFunction.INSTANCE).getClass());
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetSecurityGroupByName() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupApi.class, (String)"getSecurityGroupByName", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"some-name"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listSecurityGroups&listAll=true&securitygroupname=some-name HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, Functions.compose((Function)IdentityFunction.INSTANCE, (Function)IdentityFunction.INSTANCE).getClass());
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateSecurityGroup() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupApi.class, (String)"createSecurityGroup", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"goo"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=createSecurityGroup&name=goo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testAuthorizeIngressPortsToCIDRs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupApi.class, (String)"authorizeIngressPortsToCIDRs", (Class[])new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE, Iterable.class, AccountInDomainOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)2, (Object)"tcp", (Object)22, (Object)22, (Object)ImmutableSet.of((Object)"1.1.1.1/24", (Object)"1.2.2.2/16")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.authorizeSecurityGroupIngress3.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testAuthorizeIngressPortsToSecurityGroups() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupApi.class, (String)"authorizeIngressPortsToSecurityGroups", (Class[])new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE, Multimap.class, AccountInDomainOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)2, (Object)"tcp", (Object)22, (Object)22, (Object)ImmutableMultimap.of((Object)"adrian", (Object)"group1", (Object)"adrian", (Object)"group2", (Object)"bob", (Object)"group1")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.authorizeSecurityGroupIngress4.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testAuthorizeIngressICMPToCIDRs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupApi.class, (String)"authorizeIngressICMPToCIDRs", (Class[])new Class[]{String.class, Integer.TYPE, Integer.TYPE, Iterable.class, AccountInDomainOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)2, (Object)22, (Object)22, (Object)ImmutableSet.of((Object)"1.1.1.1/24", (Object)"1.2.2.2/16")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.authorizeSecurityGroupIngress1.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testAuthorizeIngressICMPToSecurityGroups() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupApi.class, (String)"authorizeIngressICMPToSecurityGroups", (Class[])new Class[]{String.class, Integer.TYPE, Integer.TYPE, Multimap.class, AccountInDomainOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)2, (Object)22, (Object)22, (Object)ImmutableMultimap.of((Object)"adrian", (Object)"group1", (Object)"adrian", (Object)"group2", (Object)"bob", (Object)"group1")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.authorizeSecurityGroupIngress2.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testRevokeIngressRule() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupApi.class, (String)"revokeIngressRule", (Class[])new Class[]{String.class, AccountInDomainOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)5, (Object)AccountInDomainOptions.Builder.accountInDomain((String)"adrian", (String)"1")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=revokeSecurityGroupIngress&id=5&account=adrian&domainid=1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteSecurityGroup() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupApi.class, (String)"deleteSecurityGroup", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)5));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=deleteSecurityGroup&id=5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }
}

