/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.features.TagApi;
import org.jclouds.cloudstack.internal.BaseCloudStackApiTest;
import org.jclouds.cloudstack.options.CreateTagsOptions;
import org.jclouds.cloudstack.options.DeleteTagsOptions;
import org.jclouds.cloudstack.options.ListTagsOptions;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Strings2;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TagApiTest")
public class TagApiTest
extends BaseCloudStackApiTest<TagApi> {
    public void testListTags() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TagApi.class, (String)"listTags", (Class[])new Class[]{ListTagsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listTags&listAll=true HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListTagsOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TagApi.class, (String)"listTags", (Class[])new Class[]{ListTagsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListTagsOptions.Builder.accountInDomain((String)"adrian", (String)"6").resourceType(Tag.ResourceType.TEMPLATE)));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listTags&listAll=true&account=adrian&domainid=6&resourcetype=Template HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateTags() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TagApi.class, (String)"createTags", (Class[])new Class[]{CreateTagsOptions.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)CreateTagsOptions.Builder.resourceIds((String[])new String[]{"1"}).resourceType(Tag.ResourceType.TEMPLATE).tags((Map)ImmutableMap.of((Object)"some-tag", (Object)"some-value"))));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=createTags&resourceids=1&resourcetype=Template&" + Strings2.urlEncode((String)"tags[0].key", (char[])new char[0]) + "=some-tag&" + Strings2.urlEncode((String)"tags[0].value", (char[])new char[0]) + "=some-value HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteTags() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TagApi.class, (String)"deleteTags", (Class[])new Class[]{DeleteTagsOptions.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)DeleteTagsOptions.Builder.resourceIds((String[])new String[]{"1"}).resourceType(Tag.ResourceType.TEMPLATE).tags((Map)ImmutableMap.of((Object)"some-tag", (Object)"some-value"))));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=deleteTags&resourceids=1&resourcetype=Template&" + Strings2.urlEncode((String)"tags[0].key", (char[])new char[0]) + "=some-tag&" + Strings2.urlEncode((String)"tags[0].value", (char[])new char[0]) + "=some-value HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }
}

