/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.DiskOffering;
import org.jclouds.cloudstack.domain.Snapshot;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Volume;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.ListDiskOfferingsOptions;
import org.jclouds.cloudstack.options.ListSnapshotsOptions;
import org.jclouds.cloudstack.options.ListVirtualMachinesOptions;
import org.jclouds.cloudstack.options.ListVolumesOptions;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.logging.Logger;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="VolumeApiLiveTest")
public class VolumeApiLiveTest
extends BaseCloudStackApiLiveTest {
    @Resource
    Logger logger = Logger.NULL;
    protected String prefix = System.getProperty("user.name") + "-" + ((Object)((Object)this)).getClass().getSimpleName();
    private String zoneId;

    @BeforeMethod(groups={"live"})
    public void setZoneId() {
        Set zones = this.client.getZoneApi().listZones(new ListZonesOptions[0]);
        AssertJUnit.assertNotNull((Object)zones);
        AssertJUnit.assertFalse((boolean)zones.isEmpty());
        this.zoneId = ((Zone)Iterables.get((Iterable)zones, (int)0)).getId();
    }

    public void testListVolumes() {
        Set volumes = this.client.getVolumeApi().listVolumes(new ListVolumesOptions[0]);
        AssertJUnit.assertNotNull((Object)volumes);
        AssertJUnit.assertFalse((boolean)volumes.isEmpty());
        for (Volume volume : volumes) {
            VolumeApiLiveTest.checkVolume(volume);
        }
    }

    public void testListVolumesById() {
        Iterable volumeIds = Iterables.transform((Iterable)this.client.getVolumeApi().listVolumes(new ListVolumesOptions[0]), (Function)new Function<Volume, String>(){

            public String apply(Volume input) {
                return input.getId();
            }
        });
        AssertJUnit.assertNotNull((Object)volumeIds);
        AssertJUnit.assertFalse((boolean)Iterables.isEmpty((Iterable)volumeIds));
        for (String id : volumeIds) {
            Set found = this.client.getVolumeApi().listVolumes(new ListVolumesOptions[]{ListVolumesOptions.Builder.id((String)id)});
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((int)1, (int)found.size());
            Volume volume = (Volume)Iterables.getOnlyElement((Iterable)found);
            AssertJUnit.assertEquals((String)id, (String)volume.getId());
            VolumeApiLiveTest.checkVolume(volume);
        }
    }

    public void testListVolumesNonexistantId() {
        Set found = this.client.getVolumeApi().listVolumes(new ListVolumesOptions[]{ListVolumesOptions.Builder.id((String)"foo")});
        AssertJUnit.assertNotNull((Object)found);
        AssertJUnit.assertTrue((boolean)found.isEmpty());
    }

    public void testGetVolumeById() {
        Iterable volumeIds = Iterables.transform((Iterable)this.client.getVolumeApi().listVolumes(new ListVolumesOptions[0]), (Function)new Function<Volume, String>(){

            public String apply(Volume input) {
                return input.getId();
            }
        });
        AssertJUnit.assertNotNull((Object)volumeIds);
        AssertJUnit.assertFalse((boolean)Iterables.isEmpty((Iterable)volumeIds));
        for (String id : volumeIds) {
            Volume found = this.client.getVolumeApi().getVolume(id);
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((String)id, (String)found.getId());
            VolumeApiLiveTest.checkVolume(found);
        }
    }

    public void testGetVolumeNonexistantId() {
        Volume found = this.client.getVolumeApi().getVolume("foo");
        AssertJUnit.assertNull((Object)found);
    }

    protected DiskOffering getPreferredDiskOffering() {
        Iterator iterator = this.client.getOfferingApi().listDiskOfferings(new ListDiskOfferingsOptions[0]).iterator();
        if (iterator.hasNext()) {
            DiskOffering candidate = (DiskOffering)iterator.next();
            return candidate;
        }
        throw new AssertionError((Object)"No suitable DiskOffering found.");
    }

    protected Snapshot getPreferredSnapshot() {
        for (Snapshot candidate : this.client.getSnapshotApi().listSnapshots(new ListSnapshotsOptions[0])) {
            if (candidate.getState() != Snapshot.State.BACKED_UP) continue;
            return candidate;
        }
        throw new AssertionError((Object)"No suitable Snapshot found.");
    }

    protected VirtualMachine getPreferredVirtualMachine() {
        for (VirtualMachine candidate : this.client.getVirtualMachineApi().listVirtualMachines(new ListVirtualMachinesOptions[0])) {
            if (candidate.getState() != VirtualMachine.State.RUNNING && candidate.getState() != VirtualMachine.State.STOPPED) continue;
            return candidate;
        }
        throw new AssertionError((Object)"No suitable VirtualMachine found.");
    }

    protected Volume createPreferredVolumeFromDisk() {
        AsyncCreateResponse job = this.client.getVolumeApi().createVolumeFromDiskOfferingInZone(this.prefix + "-jclouds-volume", this.getPreferredDiskOffering().getId(), this.zoneId);
        AssertJUnit.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
        this.logger.info("created volume " + job.getId(), new Object[0]);
        return this.findVolumeWithId(job.getId());
    }

    public void testCreateVolumeFromDiskofferingInZoneAndDeleteVolume() {
        this.logger.info("testCreateVolumeFromDiskofferingInZoneAndDeleteVolume", new Object[0]);
        Volume volume = this.createPreferredVolumeFromDisk();
        VolumeApiLiveTest.checkVolume(volume);
        this.client.getVolumeApi().deleteVolume(volume.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateVolumeFromCustomDiskOffering() {
        boolean size = true;
        DiskOffering offering = null;
        for (DiskOffering candidate : this.client.getOfferingApi().listDiskOfferings(new ListDiskOfferingsOptions[0])) {
            if (!candidate.isCustomized()) continue;
            offering = candidate;
            break;
        }
        AssertJUnit.assertNotNull((String)"No custom disk offering found!", offering);
        AsyncCreateResponse job = this.client.getVolumeApi().createVolumeFromCustomDiskOfferingInZone(this.prefix + "-jclouds-volume", offering.getId(), this.zoneId, 1);
        AssertJUnit.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
        this.logger.info("created volume " + job.getId(), new Object[0]);
        Volume volume = this.findVolumeWithId(job.getId());
        try {
            VolumeApiLiveTest.checkVolume(volume);
            AssertJUnit.assertEquals((long)volume.getSize(), (long)0x40000000L);
        }
        finally {
            this.client.getVolumeApi().deleteVolume(volume.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateVolumeFromDiskofferingInZoneAndAttachVolumeToVirtualMachineAndDetachAndDelete() {
        this.logger.info("testCreateVolumeFromDiskofferingInZoneAndAttachVolumeToVirtualMachineAndDetachAndDelete", new Object[0]);
        Volume volume = this.createPreferredVolumeFromDisk();
        try {
            VolumeApiLiveTest.checkVolume(volume);
            VirtualMachine virtualMachine = this.getPreferredVirtualMachine();
            this.logger.info("attaching volume %s to vm %s", new Object[]{volume, virtualMachine});
            AsyncCreateResponse job = this.client.getVolumeApi().attachVolume(volume.getId(), virtualMachine.getId());
            AssertJUnit.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
            Volume attachedVolume = this.findVolumeWithId(volume.getId());
            VolumeApiLiveTest.checkVolume(attachedVolume);
            AssertJUnit.assertEquals((String)virtualMachine.getId(), (String)attachedVolume.getVirtualMachineId());
            AssertJUnit.assertNotNull((Object)attachedVolume.getAttached());
            this.logger.info("detaching volume %s from vm %s", new Object[]{volume, virtualMachine});
            job = this.client.getVolumeApi().detachVolume(volume.getId());
            AssertJUnit.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
            Volume detachedVolume = this.findVolumeWithId(volume.getId());
            VolumeApiLiveTest.checkVolume(detachedVolume);
            AssertJUnit.assertNull((Object)detachedVolume.getAttached());
        }
        finally {
            this.client.getVolumeApi().deleteVolume(volume.getId());
        }
    }

    public void testCreateVolumeFromSnapshotInZoneAndDeleteVolume() {
        this.logger.info("testCreateVolumeFromSnapshotInZoneAndDeleteVolume (takes ~3m)", new Object[0]);
        AssertJUnit.assertNotNull((Object)this.getPreferredSnapshot());
        AsyncCreateResponse job = this.client.getVolumeApi().createVolumeFromSnapshotInZone(this.prefix + "-jclouds-volume", this.getPreferredSnapshot().getId(), this.zoneId);
        AssertJUnit.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
        Volume volume = this.findVolumeWithId(job.getId());
        VolumeApiLiveTest.checkVolume(volume);
        this.client.getVolumeApi().deleteVolume(volume.getId());
    }

    static void checkVolume(Volume volume) {
        AssertJUnit.assertNotNull((Object)volume.getId());
        AssertJUnit.assertNotNull((Object)volume.getName());
        AssertJUnit.assertNotSame((Object)Volume.Type.UNRECOGNIZED, (Object)volume.getType());
    }

    Volume findVolumeWithId(String id) {
        return VolumeApiLiveTest.findVolumeWithId(this.client, id);
    }

    static Volume findVolumeWithId(CloudStackApi client, String id) {
        for (Volume v : client.getVolumeApi().listVolumes(new ListVolumesOptions[0])) {
            if (!v.getId().equals(id)) continue;
            return v;
        }
        throw new NoSuchElementException("no volume with id " + id);
    }
}

