/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.easymock.EasyMock;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.domain.ZoneSecurityGroupNamePortsCidrs;
import org.jclouds.cloudstack.features.AsyncJobApi;
import org.jclouds.cloudstack.features.SecurityGroupApi;
import org.jclouds.cloudstack.features.ZoneApi;
import org.jclouds.cloudstack.functions.CreateSecurityGroupIfNeeded;
import org.jclouds.cloudstack.functions.ZoneIdToZone;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.predicates.JobComplete;
import org.jclouds.cloudstack.suppliers.ZoneIdToZoneSupplier;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CreateSecurityGroupIfNeededTest")
public class CreateSecurityGroupIfNeededTest {
    @Test
    public void testApply() throws UnknownHostException {
        final CloudStackApi client = (CloudStackApi)EasyMock.createMock(CloudStackApi.class);
        SecurityGroupApi secClient = (SecurityGroupApi)EasyMock.createMock(SecurityGroupApi.class);
        ZoneApi zoneClient = (ZoneApi)EasyMock.createMock(ZoneApi.class);
        AsyncJobApi jobClient = (AsyncJobApi)EasyMock.createMock(AsyncJobApi.class);
        SecurityGroup group = (SecurityGroup)EasyMock.createMock(SecurityGroup.class);
        Zone zone = (Zone)EasyMock.createMock(Zone.class);
        EasyMock.expect((Object)group.getIngressRules()).andReturn((Object)ImmutableSet.of());
        EasyMock.expect((Object)group.getId()).andReturn((Object)"sec-1234").anyTimes();
        EasyMock.expect((Object)zone.isSecurityGroupsEnabled()).andReturn((Object)true);
        EasyMock.expect((Object)client.getSecurityGroupApi()).andReturn((Object)secClient).anyTimes();
        EasyMock.expect((Object)client.getZoneApi()).andReturn((Object)zoneClient);
        EasyMock.expect((Object)client.getAsyncJobApi()).andReturn((Object)jobClient).anyTimes();
        EasyMock.expect((Object)zoneClient.getZone("zone-abc1")).andReturn((Object)zone);
        EasyMock.expect((Object)secClient.createSecurityGroup("group-1")).andReturn((Object)group);
        EasyMock.expect((Object)secClient.authorizeIngressPortsToCIDRs("sec-1234", "TCP", 22, 22, (Iterable)ImmutableSet.of((Object)"0.0.0.0/0"), new AccountInDomainOptions[0])).andReturn((Object)"job-1234");
        EasyMock.replay((Object[])new Object[]{client, secClient, zoneClient, zone, group});
        ZoneSecurityGroupNamePortsCidrs input = ZoneSecurityGroupNamePortsCidrs.builder().zone("zone-abc1").name("group-1").ports((Set)ImmutableSet.of((Object)22)).cidrs((Set)ImmutableSet.of()).build();
        CreateSecurityGroupIfNeeded parser = (CreateSecurityGroupIfNeeded)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)Suppliers.ofInstance((Object)"1"));
                this.bind(CloudStackApi.class).toInstance((Object)client);
                this.bind((TypeLiteral)new TypeLiteral<CacheLoader<String, Zone>>(){}).to(ZoneIdToZone.class);
                this.bind((TypeLiteral)new TypeLiteral<Supplier<LoadingCache<String, Zone>>>(){}).to(ZoneIdToZoneSupplier.class);
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"jclouds.session-interval")).toInstance((Object)"60");
            }

            @Provides
            @Singleton
            protected Predicate<String> jobComplete(JobComplete jobComplete) {
                return Predicates2.retry((Predicate)jobComplete, (long)1200L, (long)1L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
        }}).getInstance(CreateSecurityGroupIfNeeded.class);
        Assert.assertEquals((Object)parser.apply(input), (Object)group);
        EasyMock.verify((Object[])new Object[]{client, secClient, zoneClient, zone, group});
    }

    @Test
    public void testApplyGroupAlreadyExists() throws UnknownHostException {
        final CloudStackApi client = (CloudStackApi)EasyMock.createMock(CloudStackApi.class);
        SecurityGroupApi secClient = (SecurityGroupApi)EasyMock.createMock(SecurityGroupApi.class);
        ZoneApi zoneClient = (ZoneApi)EasyMock.createMock(ZoneApi.class);
        AsyncJobApi jobClient = (AsyncJobApi)EasyMock.createMock(AsyncJobApi.class);
        SecurityGroup group = (SecurityGroup)EasyMock.createMock(SecurityGroup.class);
        Zone zone = (Zone)EasyMock.createMock(Zone.class);
        EasyMock.expect((Object)group.getId()).andReturn((Object)"sec-1234").anyTimes();
        EasyMock.expect((Object)zone.isSecurityGroupsEnabled()).andReturn((Object)true);
        EasyMock.expect((Object)client.getSecurityGroupApi()).andReturn((Object)secClient).anyTimes();
        EasyMock.expect((Object)client.getZoneApi()).andReturn((Object)zoneClient);
        EasyMock.expect((Object)client.getAsyncJobApi()).andReturn((Object)jobClient).anyTimes();
        EasyMock.expect((Object)zoneClient.getZone("zone-abc2")).andReturn((Object)zone);
        EasyMock.expect((Object)secClient.createSecurityGroup("group-1")).andThrow((Throwable)new IllegalStateException());
        EasyMock.expect((Object)secClient.getSecurityGroupByName("group-1")).andReturn((Object)group);
        EasyMock.replay((Object[])new Object[]{client, secClient, zoneClient, zone, group});
        ZoneSecurityGroupNamePortsCidrs input = ZoneSecurityGroupNamePortsCidrs.builder().zone("zone-abc2").name("group-1").ports((Set)ImmutableSet.of((Object)22)).cidrs((Set)ImmutableSet.of()).build();
        CreateSecurityGroupIfNeeded parser = (CreateSecurityGroupIfNeeded)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)Suppliers.ofInstance((Object)"1"));
                this.bind(CloudStackApi.class).toInstance((Object)client);
                this.bind((TypeLiteral)new TypeLiteral<CacheLoader<String, Zone>>(){}).to(ZoneIdToZone.class);
                this.bind((TypeLiteral)new TypeLiteral<Supplier<LoadingCache<String, Zone>>>(){}).to(ZoneIdToZoneSupplier.class);
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"jclouds.session-interval")).toInstance((Object)"60");
            }

            @Provides
            @Singleton
            protected Predicate<String> jobComplete(JobComplete jobComplete) {
                return Predicates2.retry((Predicate)jobComplete, (long)1200L, (long)1L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
        }}).getInstance(CreateSecurityGroupIfNeeded.class);
        Assert.assertEquals((Object)parser.apply(input), (Object)group);
        EasyMock.verify((Object[])new Object[]{client, secClient, zoneClient, zone, group});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testApplyZoneNoSecurityGroups() throws UnknownHostException {
        final CloudStackApi client = (CloudStackApi)EasyMock.createMock(CloudStackApi.class);
        SecurityGroupApi secClient = (SecurityGroupApi)EasyMock.createMock(SecurityGroupApi.class);
        ZoneApi zoneClient = (ZoneApi)EasyMock.createMock(ZoneApi.class);
        AsyncJobApi jobClient = (AsyncJobApi)EasyMock.createMock(AsyncJobApi.class);
        SecurityGroup group = (SecurityGroup)EasyMock.createMock(SecurityGroup.class);
        Zone zone = (Zone)EasyMock.createMock(Zone.class);
        EasyMock.expect((Object)zone.isSecurityGroupsEnabled()).andReturn((Object)false);
        EasyMock.expect((Object)client.getZoneApi()).andReturn((Object)zoneClient);
        EasyMock.expect((Object)zoneClient.getZone("zone-abc3")).andReturn((Object)zone);
        EasyMock.replay((Object[])new Object[]{client, zoneClient, zone});
        ZoneSecurityGroupNamePortsCidrs input = ZoneSecurityGroupNamePortsCidrs.builder().zone("zone-abc3").name("group-1").ports((Set)ImmutableSet.of((Object)22)).cidrs((Set)ImmutableSet.of()).build();
        CreateSecurityGroupIfNeeded parser = (CreateSecurityGroupIfNeeded)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)Suppliers.ofInstance((Object)"1"));
                this.bind(CloudStackApi.class).toInstance((Object)client);
                this.bind((TypeLiteral)new TypeLiteral<CacheLoader<String, Zone>>(){}).to(ZoneIdToZone.class);
                this.bind((TypeLiteral)new TypeLiteral<Supplier<LoadingCache<String, Zone>>>(){}).to(ZoneIdToZoneSupplier.class);
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"jclouds.session-interval")).toInstance((Object)"60");
            }

            @Provides
            @Singleton
            protected Predicate<String> jobComplete(JobComplete jobComplete) {
                return Predicates2.retry((Predicate)jobComplete, (long)1200L, (long)1L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
        }}).getInstance(CreateSecurityGroupIfNeeded.class);
        Assert.assertEquals((Object)parser.apply(input), (Object)group);
        EasyMock.verify((Object[])new Object[]{client, zoneClient, zone});
    }
}

