/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.handlers;

import com.google.common.cache.LoadingCache;
import java.util.concurrent.atomic.AtomicInteger;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.jclouds.cloudstack.features.SessionApi;
import org.jclouds.cloudstack.handlers.InvalidateSessionAndRetryOn401AndLogoutOnClose;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="InvalidateSessionAndRetryOn401AndLogoutOnCloseTest")
public class InvalidateSessionAndRetryOn401AndLogoutOnCloseTest {
    @Test
    public void test401ShouldRetryAndFailAfterFiveAttempts() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        SessionApi sessionClient = (SessionApi)EasyMock.createMock(SessionApi.class);
        LoadingCache cache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        cache.invalidateAll();
        EasyMock.expectLastCall().anyTimes();
        final AtomicInteger counter = new AtomicInteger();
        EasyMock.expect((Object)command.incrementFailureCount()).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return counter.incrementAndGet();
            }
        }).anyTimes();
        EasyMock.expect((Object)command.isReplayable()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)command.getFailureCount()).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return counter.get();
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{cache, command});
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload((Payload)Payloads.newStringPayload((String)"Not relevant"))).statusCode(401).build();
        InvalidateSessionAndRetryOn401AndLogoutOnClose retry = new InvalidateSessionAndRetryOn401AndLogoutOnClose(cache, sessionClient);
        for (int i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)retry.shouldRetryRequest(command, response));
        }
        Assert.assertFalse((boolean)retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{cache, command});
    }
}

