/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkService;
import org.jclouds.cloudstack.predicates.NetworkPredicates;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class NetworkPredicatesTest {
    public void testHasLoadBalancerService() {
        Network network = Network.builder().id("204").services((Set)ImmutableSet.of((Object)NetworkService.builder().name("Lb").build())).build();
        assert (NetworkPredicates.hasLoadBalancerService().apply((Object)network));
        assert (!NetworkPredicates.supportsStaticNAT().apply((Object)network));
        assert (!NetworkPredicates.supportsPortForwarding().apply((Object)network));
    }

    public void testSupportsStaticNATFindsWhenFirewallHasStaticNatFeature() {
        Network network = Network.builder().id("204").services((Set)ImmutableSet.of((Object)NetworkService.builder().name("Firewall").capabilities((Map)ImmutableMap.of((Object)"StaticNat", (Object)"true")).build())).build();
        assert (!NetworkPredicates.hasLoadBalancerService().apply((Object)network));
        assert (NetworkPredicates.supportsStaticNAT().apply((Object)network));
        assert (!NetworkPredicates.supportsPortForwarding().apply((Object)network));
    }

    public void testNoSupport() {
        Network network = Network.builder().id("204").services((Set)ImmutableSet.of((Object)NetworkService.builder().name("Firewall").capabilities((Map)ImmutableMap.of()).build())).build();
        assert (!NetworkPredicates.hasLoadBalancerService().apply((Object)network));
        assert (!NetworkPredicates.supportsStaticNAT().apply((Object)network));
        assert (!NetworkPredicates.supportsPortForwarding().apply((Object)network));
    }

    public void testSupportsPortForwardingFindsWhenFirewallHasPortForwardingFeature() {
        Network network = Network.builder().id("204").services((Set)ImmutableSet.of((Object)NetworkService.builder().name("Firewall").capabilities((Map)ImmutableMap.of((Object)"PortForwarding", (Object)"true")).build())).build();
        assert (!NetworkPredicates.hasLoadBalancerService().apply((Object)network));
        assert (!NetworkPredicates.supportsStaticNAT().apply((Object)network));
        assert (NetworkPredicates.supportsPortForwarding().apply((Object)network));
    }

    public void testSupportsPortForwardingAndStaticNATWhenFirewallHasFeatures() {
        Network network = Network.builder().id("204").services((Set)ImmutableSet.of((Object)NetworkService.builder().name("Firewall").capabilities((Map)ImmutableMap.of((Object)"StaticNat", (Object)"true", (Object)"PortForwarding", (Object)"true")).build())).build();
        assert (Predicates.and((Predicate)NetworkPredicates.supportsPortForwarding(), (Predicate)NetworkPredicates.supportsStaticNAT()).apply((Object)network));
        assert (!NetworkPredicates.hasLoadBalancerService().apply((Object)network));
    }

    public void testDefaultNetworkInZone() {
        Network defaultInZone = Network.builder().id("42-1").isDefault(true).zoneId("42").build();
        Network defaultNotInZone = Network.builder().id("200-1").isDefault(true).zoneId("200").build();
        Network notDefaultInZone = Network.builder().id("42-2").isDefault(false).zoneId("42").build();
        Network notDefaultNotInZone = Network.builder().id("200-2").isDefault(false).zoneId("200").build();
        Predicate predicate = NetworkPredicates.defaultNetworkInZone((String)"42");
        Assert.assertTrue((boolean)predicate.apply((Object)defaultInZone));
        Assert.assertFalse((boolean)predicate.apply((Object)defaultNotInZone));
        Assert.assertFalse((boolean)predicate.apply((Object)notDefaultInZone));
        Assert.assertFalse((boolean)predicate.apply((Object)notDefaultNotInZone));
    }
}

