/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import org.easymock.EasyMock;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.features.VirtualMachineApi;
import org.jclouds.cloudstack.predicates.VirtualMachineExpunged;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="VirtualMachineExpungedTest")
public class VirtualMachineExpungedTest {
    CloudStackApi client;
    VirtualMachineApi virtualMachineClient;

    @BeforeMethod
    public void setUp() {
        this.client = (CloudStackApi)EasyMock.createMock(CloudStackApi.class);
        this.virtualMachineClient = (VirtualMachineApi)EasyMock.createMock(VirtualMachineApi.class);
        EasyMock.expect((Object)this.client.getVirtualMachineApi()).andReturn((Object)this.virtualMachineClient);
    }

    @Test
    public void testWaitForVirtualMachineToBeExpunged() {
        VirtualMachine virtualMachine = VirtualMachine.builder().id("229").build();
        EasyMock.expect((Object)this.virtualMachineClient.getVirtualMachine(virtualMachine.getId())).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.client, this.virtualMachineClient});
        Assert.assertTrue((boolean)new VirtualMachineExpunged(this.client).apply(virtualMachine));
        EasyMock.verify((Object[])new Object[]{this.client, this.virtualMachineClient});
    }

    @Test
    public void testNoRemovedYet() {
        VirtualMachine virtualMachine = VirtualMachine.builder().id("229").build();
        EasyMock.expect((Object)this.virtualMachineClient.getVirtualMachine(virtualMachine.getId())).andReturn((Object)virtualMachine);
        EasyMock.replay((Object[])new Object[]{this.client, this.virtualMachineClient});
        Assert.assertFalse((boolean)new VirtualMachineExpunged(this.client).apply(virtualMachine));
        EasyMock.verify((Object[])new Object[]{this.client, this.virtualMachineClient});
    }
}

