/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.java.impl;

import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.commons.compiler.CompilationResult;
import org.apache.sling.commons.compiler.CompilerMessage;
import org.apache.sling.commons.compiler.Options;
import org.apache.sling.scripting.java.impl.CompilationUnit;
import org.apache.sling.scripting.java.impl.CompilerUtil;
import org.apache.sling.scripting.java.impl.SlingIOProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletWrapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServletConfig config;
    private final SlingIOProvider ioProvider;
    private final String className;
    private final String sourcePath;
    private volatile long lastModificationTest = 0L;
    private volatile Class<?> servletClass;
    private volatile Servlet theServlet;
    private long available = 0L;
    private volatile Exception compileException;

    public ServletWrapper(ServletConfig config, SlingIOProvider ioProvider, String servletPath) {
        this.config = config;
        this.ioProvider = ioProvider;
        this.sourcePath = servletPath;
        this.className = CompilerUtil.mapSourcePath(this.sourcePath).substring(1).replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block23: {
            try {
                ServletWrapper servletWrapper;
                if (this.available > 0L && this.available < Long.MAX_VALUE) {
                    if (this.available > System.currentTimeMillis()) {
                        response.setDateHeader("Retry-After", this.available);
                        response.sendError(503, "Servlet unavailable.");
                        this.logger.error("Java servlet {} is unavailable.", (Object)this.sourcePath);
                        return;
                    }
                    this.available = 0L;
                }
                if (this.lastModificationTest == 0L) {
                    servletWrapper = this;
                    synchronized (servletWrapper) {
                        if (this.lastModificationTest == 0L) {
                            try {
                                this.compileException = null;
                                this.compile();
                            }
                            catch (Exception ex) {
                                this.compileException = ex;
                                throw ex;
                            }
                            finally {
                                this.lastModificationTest = System.currentTimeMillis();
                            }
                        } else if (this.compileException != null) {
                            throw this.compileException;
                        }
                    }
                } else if (this.compileException != null) {
                    throw this.compileException;
                }
                if (this.theServlet instanceof SingleThreadModel) {
                    servletWrapper = this;
                    synchronized (servletWrapper) {
                        this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                        break block23;
                    }
                }
                this.theServlet.service((ServletRequest)request, (ServletResponse)response);
            }
            catch (UnavailableException ex) {
                int unavailableSeconds = ex.getUnavailableSeconds();
                if (unavailableSeconds <= 0) {
                    unavailableSeconds = 60;
                }
                this.available = System.currentTimeMillis() + (long)unavailableSeconds * 1000L;
                response.sendError(503, ex.getMessage());
                this.logger.error("Java servlet {} is unavailable.", (Object)this.sourcePath);
                return;
            }
        }
    }

    public void destroy() {
        if (this.theServlet != null) {
            this.theServlet.destroy();
            this.theServlet = null;
        }
    }

    public void handleModification() {
        this.lastModificationTest = 0L;
    }

    private void compile() throws Exception {
        CompilationUnit unit = new CompilationUnit(this.sourcePath, this.className, this.ioProvider);
        CompilationResult result = this.ioProvider.getCompiler().compile(new org.apache.sling.commons.compiler.CompilationUnit[]{unit}, (Options)this.ioProvider.getOptions());
        List errors = result.getErrors();
        if (errors != null && errors.size() > 0) {
            throw CompilerException.create(errors);
        }
        if (result.didCompile() || this.theServlet == null) {
            this.destroy();
            this.servletClass = result.loadCompiledClass(this.className);
            Servlet servlet = (Servlet)this.servletClass.newInstance();
            servlet.init(this.config);
            this.theServlet = servlet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class CompilerException
    extends ServletException {
        public static CompilerException create(List<CompilerMessage> errors) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Compilation errors:\n");
            for (CompilerMessage e : errors) {
                buffer.append(e.getFile());
                buffer.append(", line ");
                buffer.append(e.getLine());
                buffer.append(", column ");
                buffer.append(e.getColumn());
                buffer.append(" : ");
                buffer.append(e.getMessage());
                buffer.append("\n");
            }
            return new CompilerException(buffer.toString());
        }

        public CompilerException(String message) {
            super(message);
        }
    }
}

