/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.java.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.scripting.java.impl.CompilerOptions;
import org.apache.sling.scripting.java.impl.ServletCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingIOProvider {
    private final Logger logger = LoggerFactory.getLogger(SlingIOProvider.class);
    private ThreadLocal<ResourceResolver> requestResourceResolver;
    private final JavaCompiler compiler;
    private final CompilerOptions options;
    private final ServletCache servletCache = new ServletCache();

    SlingIOProvider(JavaCompiler compiler, CompilerOptions options) {
        this.requestResourceResolver = new ThreadLocal();
        this.compiler = compiler;
        this.options = options;
    }

    void destroy() {
        this.servletCache.destroy();
    }

    void setRequestResourceResolver(ResourceResolver resolver) {
        this.requestResourceResolver.set(resolver);
    }

    void resetRequestResourceResolver() {
        this.requestResourceResolver.remove();
    }

    public JavaCompiler getCompiler() {
        return this.compiler;
    }

    public CompilerOptions getOptions() {
        return this.options;
    }

    public ServletCache getServletCache() {
        return this.servletCache;
    }

    public InputStream getInputStream(String fileName) throws FileNotFoundException, IOException {
        try {
            Resource resource = this.getResourceInternal(fileName);
            if (resource == null) {
                throw new FileNotFoundException("Cannot find " + fileName);
            }
            InputStream stream = (InputStream)resource.adaptTo(InputStream.class);
            if (stream == null) {
                throw new FileNotFoundException("Cannot find " + fileName);
            }
            return stream;
        }
        catch (SlingException se) {
            throw (IOException)new IOException("Failed to get InputStream for " + fileName).initCause(se);
        }
    }

    public long lastModified(String fileName) {
        try {
            Resource resource = this.getResourceInternal(fileName);
            if (resource != null) {
                ResourceMetadata meta = resource.getResourceMetadata();
                long modTime = meta.getModificationTime();
                return modTime > 0L ? modTime : 0L;
            }
        }
        catch (SlingException se) {
            this.logger.error("Cannot get last modification time for " + fileName, (Throwable)se);
        }
        return -1L;
    }

    public URL getURL(String path) throws MalformedURLException {
        try {
            Resource resource = this.getResourceInternal(path);
            return resource != null ? (URL)resource.adaptTo(URL.class) : null;
        }
        catch (SlingException se) {
            throw (MalformedURLException)new MalformedURLException("Cannot get URL for " + path).initCause(se);
        }
    }

    public Set<String> getResourcePaths(String path) {
        HashSet<String> paths = new HashSet<String>();
        try {
            Resource resource = this.getResourceInternal(path);
            if (resource != null) {
                Iterator entries = resource.getResourceResolver().listChildren(resource);
                while (entries.hasNext()) {
                    paths.add(((Resource)entries.next()).getPath());
                }
            }
        }
        catch (SlingException se) {
            this.logger.warn("Unable to get resource at path " + path, (Throwable)se);
        }
        return paths.isEmpty() ? null : paths;
    }

    private Resource getResourceInternal(String path) throws SlingException {
        ResourceResolver resolver = this.requestResourceResolver.get();
        if (resolver != null) {
            return resolver.getResource(path);
        }
        return null;
    }
}

