/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.java.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingIOException;
import org.apache.sling.api.SlingServletException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.java.impl.CompilerOptions;
import org.apache.sling.scripting.java.impl.JavaServletConfig;
import org.apache.sling.scripting.java.impl.JavaServletContext;
import org.apache.sling.scripting.java.impl.ServletWrapper;
import org.apache.sling.scripting.java.impl.SlingIOProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%javahandler.name", description="%javahandler.description")
@Service(value={ScriptEngineFactory.class, ResourceChangeListener.class})
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Java Servlet Script Handler"}), @Property(name="java.compilerSourceVM", value={"auto"}), @Property(name="java.compilerTargetVM", value={"auto"}), @Property(name="java.classdebuginfo", boolValue={true}), @Property(name="java.javaEncoding", value={"UTF-8"}), @Property(name="resource.change.types", value={"CHANGED", "REMOVED"}), @Property(name="resource.paths", value={"."}, propertyPrivate=true)})
public class JavaScriptEngineFactory
extends AbstractScriptEngineFactory
implements ResourceChangeListener,
ExternalResourceChangeListener {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String PROPERTY_COMPILER_SOURCE_V_M = "java.compilerSourceVM";
    public static final String PROPERTY_COMPILER_TARGET_V_M = "java.compilerTargetVM";
    public static final String PROPERTY_CLASSDEBUGINFO = "java.classdebuginfo";
    public static final String PROPERTY_ENCODING = "java.javaEncoding";
    public static final String VERSION_AUTO = "auto";
    @Reference
    private JavaCompiler javaCompiler;
    @Reference(target="(name=org.apache.sling)")
    private ServletContext slingServletContext;
    private SlingIOProvider ioProvider;
    private JavaServletContext javaServletContext;
    private ServletConfig servletConfig;
    public static final String SCRIPT_TYPE = "java";

    public JavaScriptEngineFactory() {
        this.setExtensions(new String[]{SCRIPT_TYPE});
    }

    public ScriptEngine getScriptEngine() {
        return new JavaScriptEngine(this);
    }

    public String getLanguageName() {
        return "Java Servlet Compiler";
    }

    public String getLanguageVersion() {
        return "1.5";
    }

    public Object getParameter(String name) {
        if ("THREADING".equals(name)) {
            return "STATELESS";
        }
        return super.getParameter(name);
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        CompilerOptions opts = CompilerOptions.createOptions(new Hashtable<String, Object>(config));
        this.ioProvider = new SlingIOProvider(this.javaCompiler, opts);
        this.javaServletContext = new JavaServletContext(this.ioProvider, this.slingServletContext);
        this.servletConfig = new JavaServletConfig(this.javaServletContext, config);
        this.logger.info("Activating Apache Sling Script Engine for Java with options {}", (Object)opts);
    }

    @Deactivate
    protected void deactivate() {
        if (this.ioProvider != null) {
            this.ioProvider.destroy();
            this.ioProvider = null;
        }
        this.javaServletContext = null;
        this.servletConfig = null;
        this.logger.info("Deactivating Apache Sling Script Engine for Java");
    }

    private void callServlet(Bindings bindings, SlingScriptHelper scriptHelper, ScriptContext context) {
        SlingBindings slingBindings = new SlingBindings();
        slingBindings.putAll((Map)bindings);
        ResourceResolver resolver = (ResourceResolver)context.getAttribute("org.apache.sling.api.scripting.ScriptResourceResolver", -314);
        if (resolver == null) {
            resolver = scriptHelper.getScript().getScriptResource().getResourceResolver();
        }
        this.ioProvider.setRequestResourceResolver(resolver);
        SlingHttpServletRequest request = slingBindings.getRequest();
        Object oldValue = request.getAttribute(SlingBindings.class.getName());
        try {
            ServletWrapper servlet = this.getWrapperAdapter(scriptHelper);
            request.setAttribute(SlingBindings.class.getName(), (Object)slingBindings);
            servlet.service((HttpServletRequest)request, (HttpServletResponse)slingBindings.getResponse());
        }
        catch (SlingException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw new SlingIOException(ioe);
        }
        catch (ServletException se) {
            throw new SlingServletException(se);
        }
        catch (Exception ex) {
            throw new SlingException(null, (Throwable)ex);
        }
        finally {
            request.setAttribute(SlingBindings.class.getName(), oldValue);
            this.ioProvider.resetRequestResourceResolver();
        }
    }

    private ServletWrapper getWrapperAdapter(SlingScriptHelper scriptHelper) throws SlingException {
        SlingScript script = scriptHelper.getScript();
        String scriptName = script.getScriptResource().getPath();
        ServletWrapper wrapper = this.ioProvider.getServletCache().getWrapper(scriptName);
        if (wrapper != null) {
            return wrapper;
        }
        wrapper = new ServletWrapper(this.servletConfig, this.ioProvider, scriptName, scriptHelper);
        wrapper = this.ioProvider.getServletCache().addWrapper(scriptName, wrapper);
        return wrapper;
    }

    public void onChange(List<ResourceChange> resourceChange) {
        for (ResourceChange change : resourceChange) {
            ResourceChange.ChangeType topic = change.getType();
            if (topic.equals((Object)ResourceChange.ChangeType.CHANGED)) {
                this.handleModification(change.getPath(), false);
                continue;
            }
            if (!topic.equals((Object)ResourceChange.ChangeType.REMOVED)) continue;
            this.handleModification(change.getPath(), true);
        }
    }

    private void handleModification(String scriptName, boolean remove) {
        this.ioProvider.getServletCache().removeWrapper(scriptName, remove);
    }

    protected void bindJavaCompiler(JavaCompiler javaCompiler) {
        this.javaCompiler = javaCompiler;
    }

    protected void unbindJavaCompiler(JavaCompiler javaCompiler) {
        if (this.javaCompiler == javaCompiler) {
            this.javaCompiler = null;
        }
    }

    protected void bindSlingServletContext(ServletContext servletContext) {
        this.slingServletContext = servletContext;
    }

    protected void unbindSlingServletContext(ServletContext servletContext) {
        if (this.slingServletContext == servletContext) {
            this.slingServletContext = null;
        }
    }

    private static class JavaScriptEngine
    extends AbstractSlingScriptEngine {
        JavaScriptEngine(JavaScriptEngineFactory factory) {
            super((ScriptEngineFactory)((Object)factory));
        }

        public Object eval(Reader script, ScriptContext context) throws ScriptException {
            Bindings props = context.getBindings(100);
            SlingScriptHelper scriptHelper = (SlingScriptHelper)props.get("sling");
            if (scriptHelper != null) {
                ((JavaScriptEngineFactory)((Object)this.getFactory())).callServlet(props, scriptHelper, context);
            }
            return null;
        }
    }
}

