/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.java.impl;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class JavaServletConfig
implements ServletConfig {
    private final ServletContext servletContext;
    private final String servletName;
    private final Map<String, String> initParams;

    public JavaServletConfig(ServletContext servletContext, Map<String, Object> config) {
        this.servletContext = servletContext;
        this.servletName = config.get("service.description") == null ? "Java Script Handler" : config.get("service.description").toString();
        this.initParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            String strValue;
            if (!entry.getKey().startsWith("java.") || entry.getValue() == null || (strValue = String.valueOf(entry.getValue()).trim()).length() <= 0) continue;
            this.initParams.put(entry.getKey().substring("java.".length()), strValue);
        }
    }

    public String getInitParameter(String name) {
        return this.initParams.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParams.keySet());
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletName() {
        return this.servletName;
    }
}

