/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.GatewayServer;

public class PythonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonUtils.class);

    public static GatewayServer createGatewayServer(Object entryPoint, String serverAddress, int port, String secretKey) throws IOException {
        LOGGER.info("Launching GatewayServer at {}:{}", (Object)serverAddress, (Object)port);
        try {
            return new GatewayServer.GatewayServerBuilder(entryPoint).authToken(secretKey).javaPort(port).javaAddress(InetAddress.getByName(serverAddress)).callbackClient(port, InetAddress.getByName(serverAddress), secretKey).build();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static String getLocalIP(Properties properties) {
        String gatewayserver_address = properties.getProperty("zeppelin.python.gatewayserver_address");
        if (gatewayserver_address != null) {
            return gatewayserver_address;
        }
        try {
            return Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("can't get local IP", (Throwable)e);
            return "127.0.0.1";
        }
    }

    public static String createSecret(int secretBitLength) {
        SecureRandom rnd = new SecureRandom();
        byte[] secretBytes = new byte[secretBitLength / 8];
        rnd.nextBytes(secretBytes);
        return Base64.encodeBase64String((byte[])secretBytes);
    }
}

